/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class JPopupMenuUtils {
    private static Rectangle screenRect;
    private static boolean problemTested;
    private static boolean problem;
    private static RequestProcessor reqProc;
    private static RequestProcessor.Task task;

    public static void dynamicChange(JPopupMenu popup, boolean usedToBeContained) {
        if (!popup.isShowing()) {
            return;
        }
        if (JPopupMenuUtils.isProblemConfig()) {
            JPopupMenuUtils.callRefreshLater(popup);
            return;
        }
        JPopupMenuUtils.refreshPopup(popup);
        Point p = popup.getLocationOnScreen();
        Point newPt = JPopupMenuUtils.getPopupMenuOrigin(popup, p);
        boolean willBeContained = JPopupMenuUtils.willPopupBeContained(popup, newPt);
        if (usedToBeContained != willBeContained) {
            popup.setVisible(false);
        }
        if (!newPt.equals(p)) {
            popup.setLocation(newPt.x, newPt.y);
        }
        if (usedToBeContained != willBeContained) {
            popup.setVisible(true);
        }
    }

    private static void refreshPopup(JPopupMenu popup) {
        popup.pack();
        popup.invalidate();
        Container c = popup.getParent();
        if (c != null) {
            ((Component)c).validate();
        }
    }

    private static void callRefreshLater(final JPopupMenu popup) {
        if (reqProc == null) {
            reqProc = new RequestProcessor();
        }
        if (task == null) {
            task = reqProc.create(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run() {
                            JPopupMenuUtils.access$002(null);
                            if (!1.access$100(this.this$0).isShowing()) {
                                return;
                            }
                            Point p = 1.access$100(this.this$0).getLocationOnScreen();
                            Point newPt = JPopupMenuUtils.getPopupMenuOrigin(1.access$100(this.this$0), p);
                            1.access$100(this.this$0).setVisible(false);
                            JPopupMenuUtils.access$200(1.access$100(this.this$0));
                            if (!newPt.equals(p)) {
                                1.access$100(this.this$0).setLocation(newPt.x, newPt.y);
                            }
                            1.access$100(this.this$0).setVisible(true);
                        }
                    });
                }

                static /* synthetic */ JPopupMenu access$100(1 x0) {
                    return x0.popup;
                }
            });
        }
        task.schedule(100);
    }

    private static boolean isProblemConfig() {
        if (problemTested) {
            return problem;
        }
        problem = false;
        String needHack = System.getProperty("netbeans.popup.linuxhack");
        if (needHack != null) {
            problem = true;
        }
        return problem;
    }

    public static void dynamicChangeToSubmenu(JPopupMenu popup, boolean usedToBeContained) {
        Component invoker = popup.getInvoker();
        if (!(invoker instanceof JMenu)) {
            return;
        }
        JMenu menu = (JMenu)invoker;
        if (!popup.isShowing()) {
            return;
        }
        if (JPopupMenuUtils.isProblemConfig()) {
            JPopupMenuUtils.callRefreshLater2(popup, menu);
            return;
        }
        JPopupMenuUtils.refreshPopup(popup);
        Point p = popup.getLocationOnScreen();
        Dimension popupSize = popup.getPreferredSize();
        Rectangle popupRect = new Rectangle(p, popupSize);
        Rectangle screenRect = JPopupMenuUtils.getScreenRect();
        boolean willBeContained = JPopupMenuUtils.isPopupContained(popup);
        if (!screenRect.contains(popupRect)) {
            menu.setPopupMenuVisible(false);
            menu.setPopupMenuVisible(true);
        } else if (usedToBeContained != willBeContained) {
            popup.setVisible(false);
            popup.setVisible(true);
        }
    }

    private static void callRefreshLater2(final JPopupMenu popup, final JMenu menu) {
        if (reqProc == null) {
            reqProc = new RequestProcessor();
        }
        if (task == null) {
            task = reqProc.create(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run() {
                            JPopupMenuUtils.access$002(null);
                            if (!3.access$300(this.this$0).isShowing()) {
                                return;
                            }
                            3.access$300(this.this$0).setVisible(false);
                            JPopupMenuUtils.access$200(3.access$300(this.this$0));
                            3.access$300(this.this$0).setVisible(true);
                            Point p = 3.access$300(this.this$0).getLocationOnScreen();
                            Dimension popupSize = 3.access$300(this.this$0).getPreferredSize();
                            Rectangle popupRect = new Rectangle(p, popupSize);
                            Rectangle screenRect = JPopupMenuUtils.getScreenRect();
                            if (!screenRect.contains(popupRect)) {
                                3.access$400(this.this$0).setPopupMenuVisible(false);
                                3.access$400(this.this$0).setPopupMenuVisible(true);
                            }
                        }
                    });
                }

                static /* synthetic */ JPopupMenu access$300(3 x0) {
                    return x0.popup;
                }

                static /* synthetic */ JMenu access$400(3 x0) {
                    return x0.menu;
                }
            });
        }
        task.schedule(100);
    }

    static Point getPopupMenuOrigin(JPopupMenu popup, Point p) {
        Point newPt = new Point(p);
        Dimension popupSize = popup.getPreferredSize();
        Rectangle screenRect = JPopupMenuUtils.getScreenRect();
        int popupRight = newPt.x + popupSize.width;
        int popupBottom = newPt.y + popupSize.height;
        int screenRight = screenRect.x + screenRect.width;
        int screenBottom = screenRect.y + screenRect.height;
        if (popupRight > screenRight) {
            newPt.x = screenRight - popupSize.width;
        }
        if (newPt.x < screenRect.x) {
            newPt.x = screenRect.x;
        }
        if (popupBottom > screenBottom) {
            newPt.y = screenBottom - popupSize.height;
        }
        if (newPt.y < screenRect.y) {
            newPt.y = screenRect.y;
        }
        return newPt;
    }

    public static boolean isPopupContained(JPopupMenu popup) {
        if (!popup.isShowing()) {
            return false;
        }
        return JPopupMenuUtils.willPopupBeContained(popup, popup.getLocationOnScreen());
    }

    private static boolean willPopupBeContained(JPopupMenu popup, Point origin) {
        if (!popup.isShowing()) {
            return false;
        }
        Window w = SwingUtilities.windowForComponent(popup.getInvoker());
        Rectangle r = new Rectangle(origin, popup.getSize());
        return w != null && w.getBounds().contains(r);
    }

    public static Rectangle getScreenRect() {
        if (screenRect != null) {
            return screenRect;
        }
        screenRect = JPopupMenuUtils.getRectFromProperty();
        if (screenRect != null) {
            return screenRect;
        }
        Dimension screen = Utilities.getScreenSize();
        return new Rectangle(0, 0, screen.width, screen.height);
    }

    private static Rectangle getRectFromProperty() {
        String prop = System.getProperty("netbeans.screen.rect");
        if (prop == null) {
            return null;
        }
        StringTokenizer strtok = new StringTokenizer(prop, ",", false);
        if (strtok.countTokens() != 4) {
            return null;
        }
        try {
            int x = Integer.parseInt(strtok.nextToken());
            int y = Integer.parseInt(strtok.nextToken());
            int width = Integer.parseInt(strtok.nextToken());
            int height = Integer.parseInt(strtok.nextToken());
            return new Rectangle(x, y, width, height);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static /* synthetic */ RequestProcessor.Task access$002(RequestProcessor.Task x0) {
        task = x0;
        return task;
    }

    static /* synthetic */ void access$200(JPopupMenu x0) {
        JPopupMenuUtils.refreshPopup(x0);
    }

    static {
        problemTested = false;
        problem = false;
    }
}

