/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Timer;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

public class ExplorerActions {
    private final CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private final CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private final DeleteActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    private final OwnPaste pasteActionPerformer = new OwnPaste();
    private ActionStateUpdater actionStateUpdater;
    private ExplorerManager manager;
    private boolean confirmDelete = true;
    private boolean attachPerformers;
    private static CopyAction copy = null;
    private static CutAction cut = null;
    private static DeleteAction delete = null;
    private static PasteAction paste = null;
    static /* synthetic */ Class class$org$openide$util$datatransfer$ClipboardListener;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;

    public ExplorerActions() {
        this(true);
    }

    ExplorerActions(boolean attachPerformers) {
        this.attachPerformers = attachPerformers;
    }

    final Action copyAction() {
        return this.copyActionPerformer;
    }

    final Action cutAction() {
        return this.cutActionPerformer;
    }

    final Action deleteAction() {
        return this.deleteActionPerformer;
    }

    final Action pasteAction() {
        return this.pasteActionPerformer;
    }

    public synchronized void attach(ExplorerManager m) {
        if (this.manager != null) {
            this.detach();
        }
        this.manager = m;
        this.actionStateUpdater = new ActionStateUpdater();
        this.manager.addPropertyChangeListener(WeakListener.propertyChange(this.actionStateUpdater, this.manager));
        Clipboard c = ExplorerActions.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.addClipboardListener((ClipboardListener)WeakListener.create(class$org$openide$util$datatransfer$ClipboardListener == null ? (class$org$openide$util$datatransfer$ClipboardListener = ExplorerActions.class$("org.openide.util.datatransfer.ClipboardListener")) : class$org$openide$util$datatransfer$ClipboardListener, this.actionStateUpdater, clip));
        }
        this.updateActions();
    }

    public synchronized void detach() {
        if (this.manager == null) {
            return;
        }
        this.actionStateUpdater = null;
        this.stopActions();
        this.manager = null;
    }

    ExplorerManager getAttachedManager() {
        return this.manager;
    }

    public final void setConfirmDelete(boolean yes) {
        this.confirmDelete = yes;
    }

    public final boolean isConfirmDelete() {
        return this.confirmDelete;
    }

    private void stopActions() {
        if (this.copyActionPerformer != null) {
            if (this.attachPerformers) {
                if (copy.getActionPerformer() instanceof CopyCutActionPerformer) {
                    copy.setActionPerformer(null);
                }
                if (cut.getActionPerformer() instanceof CopyCutActionPerformer) {
                    cut.setActionPerformer(null);
                }
                paste.setPasteTypes(null);
                if (delete.getActionPerformer() instanceof DeleteActionPerformer) {
                    delete.setActionPerformer(null);
                }
            } else {
                this.copyActionPerformer.setEnabled(false);
                this.cutActionPerformer.setEnabled(false);
                this.deleteActionPerformer.setEnabled(false);
                this.pasteActionPerformer.setEnabled(false);
            }
        }
    }

    private void updateActions() {
        int k;
        if (this.manager == null) {
            return;
        }
        Node[] path = this.manager.getSelectedNodes();
        if (copy == null) {
            copy = (CopyAction)SharedClassObject.findObject(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ExplorerActions.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction, true);
            cut = (CutAction)SharedClassObject.findObject(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = ExplorerActions.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction, true);
            paste = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ExplorerActions.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction, true);
            delete = (DeleteAction)SharedClassObject.findObject(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ExplorerActions.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction, true);
        }
        int n = k = path != null ? path.length : 0;
        if (k > 0) {
            int i;
            boolean incest = false;
            if (k > 1) {
                HashMap allNodes = new HashMap(101);
                i = 0;
                while (i < k) {
                    if (!this.checkParents(path[i], allNodes)) {
                        incest = true;
                        break;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < k) {
                if (incest || !path[i].canCopy()) {
                    if (this.attachPerformers) {
                        copy.setActionPerformer(null);
                        break;
                    }
                    this.copyActionPerformer.setEnabled(false);
                    break;
                }
                ++i;
            }
            if (i == k) {
                if (this.attachPerformers) {
                    copy.setActionPerformer(this.copyActionPerformer);
                } else {
                    this.copyActionPerformer.setEnabled(true);
                }
            }
            i = 0;
            while (i < k) {
                if (incest || !path[i].canCut()) {
                    if (this.attachPerformers) {
                        cut.setActionPerformer(null);
                        break;
                    }
                    this.cutActionPerformer.setEnabled(false);
                    break;
                }
                ++i;
            }
            if (i == k) {
                if (this.attachPerformers) {
                    cut.setActionPerformer(this.cutActionPerformer);
                } else {
                    this.cutActionPerformer.setEnabled(true);
                }
            }
            i = 0;
            while (i < k) {
                if (incest || !path[i].canDestroy()) {
                    if (this.attachPerformers) {
                        delete.setActionPerformer(null);
                        break;
                    }
                    this.deleteActionPerformer.setEnabled(false);
                    break;
                }
                ++i;
            }
            if (i == k) {
                if (this.attachPerformers) {
                    delete.setActionPerformer(this.deleteActionPerformer);
                } else {
                    this.deleteActionPerformer.setEnabled(true);
                }
            }
        } else if (this.attachPerformers) {
            copy.setActionPerformer(null);
            cut.setActionPerformer(null);
            delete.setActionPerformer(null);
        } else {
            this.copyActionPerformer.setEnabled(false);
            this.cutActionPerformer.setEnabled(false);
            this.deleteActionPerformer.setEnabled(false);
        }
        this.updatePasteAction(path);
    }

    private boolean checkParents(Node node, HashMap set) {
        if (set.get(node) != null) {
            return false;
        }
        set.put(node, this);
        do {
            if ((node = node.getParentNode()) != null) continue;
            return true;
        } while (set.put(node, node) != this);
        return false;
    }

    private void updatePasteAction(Node[] path) {
        ExplorerManager man = this.manager;
        if (man == null) {
            if (this.attachPerformers) {
                paste.setPasteTypes(null);
            } else {
                this.pasteActionPerformer.setPasteTypes(null);
            }
            return;
        }
        if (path != null && path.length > 1) {
            if (this.attachPerformers) {
                paste.setPasteTypes(null);
            } else {
                this.pasteActionPerformer.setPasteTypes(null);
            }
            return;
        }
        Node node = man.getExploredContext();
        Node[] selectedNodes = man.getSelectedNodes();
        if (selectedNodes != null && selectedNodes.length == 1) {
            node = selectedNodes[0];
        }
        if (node != null) {
            Transferable trans = ExplorerActions.getClipboard().getContents(this);
            this.updatePasteTypes(trans, node);
        }
    }

    private void updatePasteTypes(Transferable trans, Node pan) {
        if (trans != null) {
            PasteType[] pasteTypes;
            PasteType[] pasteTypeArray = pasteTypes = pan == null ? new PasteType[]{} : pan.getPasteTypes(trans);
            if (pasteTypes.length != 0) {
                if (this.attachPerformers) {
                    paste.setPasteTypes(pasteTypes);
                } else {
                    this.pasteActionPerformer.setPasteTypes(pasteTypes);
                }
                return;
            }
            boolean flavorSupported = false;
            try {
                flavorSupported = trans.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (flavorSupported) {
                try {
                    MultiTransferObject obj = (MultiTransferObject)trans.getTransferData(ExTransferable.multiFlavor);
                    int count = obj.getCount();
                    boolean ok = true;
                    Transferable[] t = new Transferable[count];
                    PasteType[] p = new PasteType[count];
                    int i = 0;
                    while (i < count) {
                        t[i] = obj.getTransferableAt(i);
                        PasteType[] pasteTypeArray2 = pasteTypes = pan == null ? new PasteType[]{} : pan.getPasteTypes(t[i]);
                        if (pasteTypes.length == 0) {
                            ok = false;
                            break;
                        }
                        p[i] = pasteTypes[0];
                        ++i;
                    }
                    if (ok) {
                        PasteType[] arrOfPaste = new PasteType[]{new MultiPasteType(t, p)};
                        if (this.attachPerformers) {
                            paste.setPasteTypes(arrOfPaste);
                        } else {
                            this.pasteActionPerformer.setPasteTypes(arrOfPaste);
                        }
                        return;
                    }
                }
                catch (UnsupportedFlavorException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (this.attachPerformers) {
            if (paste != null) {
                paste.setPasteTypes(null);
            }
        } else {
            this.pasteActionPerformer.setPasteTypes(null);
        }
    }

    private static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = ExplorerActions.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    private void updateActionsState() {
        ActionStateUpdater asu;
        ExplorerActions explorerActions = this;
        synchronized (explorerActions) {
            asu = this.actionStateUpdater;
        }
        if (asu != null) {
            this.actionStateUpdater.update();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FixIssue29405Timer
    extends Timer {
        private boolean running;

        public FixIssue29405Timer(int delay, ActionListener l) {
            super(delay, l);
        }

        public void restart() {
            super.restart();
            this.running = true;
        }

        public void stop() {
            this.running = false;
            super.stop();
        }

        public boolean isRunning() {
            return this.running;
        }
    }

    private class ActionStateUpdater
    implements PropertyChangeListener,
    ClipboardListener,
    ActionListener {
        private final Timer timer = new FixIssue29405Timer(150, this);

        ActionStateUpdater() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        public void propertyChange(PropertyChangeEvent e) {
            this.timer.restart();
        }

        public void clipboardChanged(ClipboardEvent ev) {
            if (!ev.isConsumed()) {
                ExplorerActions.this.updatePasteAction(ExplorerActions.this.manager.getSelectedNodes());
            }
        }

        public void actionPerformed(ActionEvent evt) {
            ExplorerActions.this.updateActions();
            this.timer.stop();
        }

        public void update() {
            if (this.timer.isRunning()) {
                this.timer.stop();
                ExplorerActions.this.updateActions();
            }
        }
    }

    private class DeleteActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        static /* synthetic */ Class class$org$openide$loaders$DataShadow;
        static /* synthetic */ Class class$org$openide$explorer$ExplorerActions;
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        DeleteActionPerformer() {
        }

        public boolean isEnabled() {
            ExplorerActions.this.updateActionsState();
            return super.isEnabled();
        }

        public void performAction(SystemAction action) {
            Node[] sel = ExplorerActions.this.manager.getSelectedNodes();
            if (sel == null || sel.length == 0) {
                return;
            }
            if (!ExplorerActions.this.confirmDelete || this.doConfirm(sel)) {
                try {
                    if (ExplorerActions.this.manager != null) {
                        ExplorerActions.this.manager.setSelectedNodes(new Node[0]);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.doDestroy(sel);
                if (ExplorerActions.this.attachPerformers) {
                    delete.setActionPerformer(null);
                } else {
                    this.setEnabled(false);
                }
            }
        }

        private boolean doConfirm(Node[] sel) {
            String message;
            String title;
            if (sel.length == 1) {
                if (sel[0].getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = DeleteActionPerformer.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow) != null) {
                    title = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteShadowTitle");
                    DataShadow obj = (DataShadow)sel[0].getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = DeleteActionPerformer.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
                    message = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteShadow", new Object[]{obj.getName(), sel[0].getDisplayName(), this.fullName(obj), this.fullName(obj.getOriginal())});
                } else if (sel[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DeleteActionPerformer.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) != null) {
                    message = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteFolder", sel[0].getDisplayName());
                    title = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteFolderTitle");
                } else {
                    message = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObject", sel[0].getDisplayName());
                    title = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjectTitle");
                }
            } else {
                message = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjects", new Integer(sel.length));
                title = NbBundle.getMessage(class$org$openide$explorer$ExplorerActions == null ? (class$org$openide$explorer$ExplorerActions = DeleteActionPerformer.class$("org.openide.explorer.ExplorerActions")) : class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjectsTitle");
            }
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, title, 0);
            return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify(desc));
        }

        private String fullName(DataObject obj) {
            FileObject f = obj.getPrimaryFile();
            if (f.isRoot()) {
                try {
                    return f.getFileSystem().getDisplayName();
                }
                catch (FileStateInvalidException e) {
                    return "";
                }
            }
            return f.toString();
        }

        private void doDestroy(Node[] sel) {
            try {
                Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(this, sel){
                    private final /* synthetic */ Node[] val$sel;
                    private final /* synthetic */ DeleteActionPerformer this$1;
                    {
                        this.this$1 = this$1;
                        this.val$sel = val$sel;
                    }

                    public void run() throws IOException {
                        int i = 0;
                        while (i < this.val$sel.length) {
                            try {
                                this.val$sel[i].destroy();
                            }
                            catch (IOException e) {
                                ErrorManager.getDefault().notify(e);
                            }
                            ++i;
                        }
                    }
                });
            }
            catch (IOException ioe) {
                IllegalStateException ise = new IllegalStateException();
                ErrorManager.getDefault().annotate((Throwable)ise, ioe);
                throw ise;
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class CopyCutActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        private boolean copyCut;

        public CopyCutActionPerformer(boolean b) {
            this.copyCut = b;
        }

        public boolean isEnabled() {
            ExplorerActions.this.updateActionsState();
            return super.isEnabled();
        }

        public void performAction(SystemAction action) {
            Transferable trans = null;
            Node[] sel = ExplorerActions.this.manager.getSelectedNodes();
            if (sel.length != 1) {
                Transferable[] arrayTrans = new Transferable[sel.length];
                int i = 0;
                while (i < sel.length) {
                    arrayTrans[i] = this.getTransferableOwner(sel[i]);
                    if (arrayTrans[i] == null) {
                        return;
                    }
                    ++i;
                }
                trans = new ExTransferable.Multi(arrayTrans);
            } else {
                trans = this.getTransferableOwner(sel[0]);
            }
            if (trans != null) {
                Clipboard clipboard = ExplorerActions.getClipboard();
                clipboard.setContents(trans, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copyCut ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, e);
                return null;
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }
    }

    private class OwnPaste
    extends AbstractAction {
        private PasteType[] pasteTypes;

        OwnPaste() {
        }

        public boolean isEnabled() {
            ExplorerActions.this.updateActionsState();
            return super.isEnabled();
        }

        public void setPasteTypes(PasteType[] arr) {
            OwnPaste ownPaste = this;
            synchronized (ownPaste) {
                this.pasteTypes = arr;
            }
            this.setEnabled(arr != null);
        }

        public void actionPerformed(ActionEvent e) {
            throw new IllegalStateException("Should not be invoked at all. Paste types: " + Arrays.asList(this.pasteTypes));
        }

        public Object getValue(String s) {
            if ("delegates".equals(s)) {
                return this.pasteTypes;
            }
            return super.getValue(s);
        }
    }

    private static class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] t, PasteType[] p) {
            this.t = t;
            this.p = p;
        }

        public Transferable paste() throws IOException {
            int size = this.p.length;
            Transferable[] arr = new Transferable[size];
            int i = 0;
            while (i < size) {
                Transferable newTransferable = this.p[i].paste();
                arr[i] = newTransferable != null ? newTransferable : this.t[i];
                ++i;
            }
            return new ExTransferable.Multi(arr);
        }
    }
}

