/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.ErrorManager;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.MouseUtils;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.propertysheet.EmptyPanel;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.NamesPanel;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.explorer.propertysheet.PropertySheetTab;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.SheetButton;
import org.openide.explorer.propertysheet.SheetButtonListener;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

class PropertySheetTab
extends JPanel
implements PropertyChangeListener {
    private NamesPanel namesPanel;
    private NamesPanel valuesPanel;
    private Node.PropertySet properties;
    private Node node;
    private HashMap modelCache;
    private boolean changeInProgress;
    private SettingsListener settingsListener;
    private Comparator sorter;
    private int sortingMode;
    private PropertySheet mySheet;
    private static final Comparator SORTER_TYPE = new Comparator(){

        public int compare(Object l, Object r) {
            Class t2;
            String s2;
            if (!(l instanceof Node.Property)) {
                throw new IllegalArgumentException("Can compare only Node.Property instances.");
            }
            if (!(r instanceof Node.Property)) {
                throw new IllegalArgumentException("Can compare only Node.Property instances.");
            }
            Class t1 = ((Node.Property)l).getValueType();
            String s1 = t1 != null ? t1.getName() : "";
            int s = s1.compareToIgnoreCase(s2 = (t2 = ((Node.Property)r).getValueType()) != null ? t2.getName() : "");
            if (s != 0) {
                return s;
            }
            s1 = ((Node.Property)l).getDisplayName();
            s2 = ((Node.Property)r).getDisplayName();
            return s1.compareToIgnoreCase(s2);
        }
    };
    private static final Comparator SORTER_NAME = new Comparator(){

        public int compare(Object l, Object r) {
            if (!(l instanceof Node.Property)) {
                throw new IllegalArgumentException("Can compare only Node.Property instances.");
            }
            if (!(r instanceof Node.Property)) {
                throw new IllegalArgumentException("Can compare only Node.Property instances.");
            }
            String s1 = ((Node.Property)l).getDisplayName();
            String s2 = ((Node.Property)r).getDisplayName();
            return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
        }
    };
    private JPopupMenu popupMenu;
    private boolean paneCreated;
    private static final HashSet propsToIgnore = new HashSet();
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$SetDefaultValueAction;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheetTab;

    public PropertySheetTab(Node.PropertySet properties, Node node, PropertySheet mySheet) {
        this.properties = properties;
        this.node = node;
        this.modelCache = new HashMap();
        this.mySheet = mySheet;
        this.setLayout(new BorderLayout());
        this.add((Component)new EmptyPanel(properties.getDisplayName()), "Center");
        try {
            this.setSortingMode(mySheet.getSortingMode());
        }
        catch (PropertyVetoException x) {
            ErrorManager.getDefault().notify(x);
        }
        this.settingsListener = new SettingsListener();
        mySheet.addPropertyChangeListener(WeakListener.propertyChange(this.settingsListener, mySheet));
    }

    public void addNotify() {
        super.addNotify();
        if (this.node != null) {
            this.node.addPropertyChangeListener(this);
        }
    }

    public void removeNotify() {
        if (this.node != null) {
            this.node.removePropertyChangeListener(this);
        }
        super.removeNotify();
    }

    void detachPropertyChangeListener() {
        this.node.removePropertyChangeListener(this);
    }

    void setActions(final Node.Property pd) {
        final CallbackSystemAction setDefault = (CallbackSystemAction)SystemAction.get(class$org$openide$explorer$propertysheet$SetDefaultValueAction == null ? (class$org$openide$explorer$propertysheet$SetDefaultValueAction = PropertySheetTab.class$("org.openide.explorer.propertysheet.SetDefaultValueAction")) : class$org$openide$explorer$propertysheet$SetDefaultValueAction);
        if (pd.supportsDefaultValue() && pd.canWrite()) {
            setDefault.setActionPerformer(new ActionPerformer(){

                public void performAction(SystemAction a) {
                    try {
                        pd.restoreDefaultValue();
                        PropertySheetTab.this.propertyChange(new PropertyChangeEvent(this, pd.getName(), null, null));
                    }
                    catch (Exception e) {
                        setDefault.setActionPerformer(null);
                    }
                }
            });
        } else {
            setDefault.setActionPerformer(null);
        }
    }

    void ensurePaneCreated() {
        if (!this.paneCreated) {
            this.createPane();
        }
    }

    private void createPane() {
        this.paneCreated = true;
        Component c = this.getComponent(0);
        if (this.properties.getProperties().length == 0) {
            if (c != null && c instanceof EmptyPanel) {
                return;
            }
            this.removeAll();
            this.add((Component)new EmptyPanel(this.properties.getDisplayName()), "Center");
            this.invalidate();
            this.validate();
            this.repaint();
            return;
        }
        if (this.namesPanel == null) {
            this.namesPanel = new NamesPanel();
            this.valuesPanel = new NamesPanel(this.namesPanel);
        } else {
            this.namesPanel.removeAll();
            this.valuesPanel.removeAll();
        }
        if (c == null || !(c instanceof JScrollPane)) {
            this.removeAll();
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setBorder(null);
            ScrollableSplittedPanel splittedPanel = new ScrollableSplittedPanel(scrollPane, this.namesPanel);
            splittedPanel.add((Component)this.namesPanel, SplittedPanel.ADD_LEFT);
            splittedPanel.add((Component)this.valuesPanel, SplittedPanel.ADD_RIGHT);
            splittedPanel.setSplitAbsolute(true);
            scrollPane.setViewportView(splittedPanel);
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.getVerticalScrollBar().setUnitIncrement(25);
            this.add((Component)scrollPane, "Center");
        }
        this.fillProperties();
    }

    private void fillProperties() {
        Node.Property[] p = this.properties.getProperties();
        ArrayList<Node.Property> a = new ArrayList<Node.Property>(p.length);
        int i = 0;
        while (i < p.length) {
            if (!this.mySheet.getDisplayWritableOnly() || p[i].canWrite()) {
                a.add(p[i]);
            }
            ++i;
        }
        if (this.sorter != null) {
            Collections.sort(a, this.sorter);
        }
        Object[] beans = new Object[]{this.node};
        if (this.node instanceof ProxyNode) {
            beans = ((ProxyNode)this.node).getOriginalNodes();
        }
        Iterator i2 = ((AbstractList)a).iterator();
        while (i2.hasNext()) {
            final Node.Property prop = (Node.Property)i2.next();
            class LazyToolTipSheetButton
            extends SheetButton {
                private String toolTipText;
                Node.Property pr;
                private final /* synthetic */ PropertySheetTab this$0;

                public LazyToolTipSheetButton(PropertySheetTab this$0, Node.Property pr) {
                    super(pr.getDisplayName(), false, true);
                    this.this$0 = this$0;
                    this.toolTipText = null;
                    this.setToolTipText("dummy");
                    this.pr = pr;
                }

                public String getToolTipText(MouseEvent event) {
                    if (this.toolTipText == null) {
                        this.toolTipText = PropertySheetTab.access$000(this.pr);
                    }
                    return this.toolTipText;
                }
            }
            final LazyToolTipSheetButton leftButton = new LazyToolTipSheetButton(this, prop);
            leftButton.setFocusTraversable(false);
            this.namesPanel.add(leftButton);
            PropertyPanel rightPanel = new PropertyPanel(prop, beans);
            this.modelCache.put(prop.getName(), rightPanel.getModel());
            this.valuesPanel.add(rightPanel);
            ButtonListener listener = new ButtonListener(leftButton, rightPanel);
            rightPanel.addSheetButtonListener(listener);
            leftButton.addSheetButtonListener(listener);
            leftButton.setPlastic(rightPanel.getPlastic());
            if (prop.canWrite()) {
                leftButton.setActiveForeground(this.mySheet.getValueColor());
            } else {
                leftButton.setActiveForeground(this.mySheet.getDisabledPropertyColor());
            }
            leftButton.addMouseListener(new MouseUtils.PopupMouseAdapter(){

                public void showPopup(MouseEvent ev) {
                    PropertySheetTab.this.setActions(prop);
                    PropertySheetTab.this.createPopup();
                    PropertySheetTab.this.popupMenu.show(leftButton, ev.getX(), ev.getY());
                }
            });
            rightPanel.addSheetButtonListener(new InstallPerformerListener(rightPanel));
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void setPlastic(boolean plastic) {
        int count = this.namesPanel.getComponentCount();
        int i = 0;
        while (i < count) {
            if (this.namesPanel.getComponent(i) instanceof SheetButton) {
                ((SheetButton)this.namesPanel.getComponent(i)).setPlastic(plastic);
            }
            ++i;
        }
        count = this.valuesPanel.getComponentCount();
        int i2 = 0;
        while (i2 < count) {
            if (this.valuesPanel.getComponent(i2) instanceof PropertyPanel) {
                ((PropertyPanel)this.valuesPanel.getComponent(i2)).setPlastic(plastic);
            }
            ++i2;
        }
    }

    void setForegroundColor(Color color) {
        int count = this.namesPanel.getComponentCount();
        int i = 0;
        while (i < count) {
            if (this.namesPanel.getComponent(i) instanceof SheetButton) {
                ((SheetButton)this.namesPanel.getComponent(i)).setActiveForeground(color);
            }
            ++i;
        }
        count = this.valuesPanel.getComponentCount();
        int i2 = 0;
        while (i2 < count) {
            if (this.valuesPanel.getComponent(i2) instanceof PropertyPanel) {
                ((PropertyPanel)this.valuesPanel.getComponent(i2)).setForegroundColor(color);
            }
            ++i2;
        }
    }

    void setDisabledColor(Color color) {
        int count = this.namesPanel.getComponentCount();
        int i = 0;
        while (i < count) {
            if (this.namesPanel.getComponent(i) instanceof SheetButton) {
                ((SheetButton)this.namesPanel.getComponent(i)).setInactiveForeground(color);
            }
            ++i;
        }
        count = this.valuesPanel.getComponentCount();
        int i2 = 0;
        while (i2 < count) {
            if (this.valuesPanel.getComponent(i2) instanceof PropertyPanel) {
                ((PropertyPanel)this.valuesPanel.getComponent(i2)).setDisabledColor(color);
            }
            ++i2;
        }
    }

    void setPaintingStyle(int style) {
        int count = this.valuesPanel.getComponentCount();
        int i = 0;
        while (i < count) {
            if (this.valuesPanel.getComponent(i) instanceof PropertyPanel) {
                ((PropertyPanel)this.valuesPanel.getComponent(i)).setPaintingStyle(style);
            }
            ++i;
        }
    }

    public void setSortingMode(int sortingMode) throws PropertyVetoException {
        switch (sortingMode) {
            case 0: {
                this.sorter = null;
                break;
            }
            case 1: {
                this.sorter = SORTER_NAME;
                break;
            }
            case 2: {
                this.sorter = SORTER_TYPE;
                break;
            }
            default: {
                throw new PropertyVetoException(PropertySheetTab.getString("EXC_Unknown_sorting_mode"), new PropertyChangeEvent(this, "sortingMode", new Integer(this.sortingMode), new Integer(sortingMode)));
            }
        }
        int oldSortingMode = this.sortingMode;
        this.sortingMode = sortingMode;
        this.firePropertyChange("sortingMode", oldSortingMode, this.sortingMode);
    }

    public int getSortingMode() {
        return this.sortingMode;
    }

    String getHelpID() {
        return (String)this.properties.getValue("helpID");
    }

    private static String getString(String key) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$PropertySheetTab == null ? (class$org$openide$explorer$propertysheet$PropertySheetTab = PropertySheetTab.class$("org.openide.explorer.propertysheet.PropertySheetTab")) : class$org$openide$explorer$propertysheet$PropertySheetTab).getString(key);
    }

    private static String getToolTipTextForProperty(Node.Property prop) {
        StringBuffer buff = new StringBuffer();
        buff.append(prop.canRead() ? PropertySheetTab.getString("CTL_Property_Read_Yes") : PropertySheetTab.getString("CTL_Property_Read_No"));
        buff.append(prop.canWrite() ? PropertySheetTab.getString("CTL_Property_Write_Yes") : PropertySheetTab.getString("CTL_Property_Write_No"));
        buff.append(' ');
        String shortDesc = prop.getShortDescription();
        buff.append(shortDesc != null ? shortDesc : prop.getDisplayName());
        return buff.toString();
    }

    private void doPropertyChange(String propertyName) {
        if (this.changeInProgress) {
            return;
        }
        PropertyModel m = (PropertyModel)this.modelCache.get(propertyName);
        if (m == null) {
            return;
        }
        if (m instanceof PropertyPanel.SimpleModel) {
            PropertyPanel.SimpleModel sm = (PropertyPanel.SimpleModel)m;
            try {
                this.changeInProgress = true;
                sm.fireValueChanged();
                Object var5_4 = null;
                this.changeInProgress = false;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.changeInProgress = false;
                throw throwable;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (propsToIgnore.contains(evt.getPropertyName())) {
            return;
        }
        if (evt.getPropertyName() != null && evt.getSource().equals(this.node)) {
            this.doPropertyChange(evt.getPropertyName());
        } else {
            Node.Property[] prop = this.properties.getProperties();
            int i = 0;
            while (i < prop.length) {
                this.doPropertyChange(prop[i].getName());
                ++i;
            }
        }
    }

    private void createPopup() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenuPlus();
            CallbackSystemAction setDefault = (CallbackSystemAction)SystemAction.get(class$org$openide$explorer$propertysheet$SetDefaultValueAction == null ? (class$org$openide$explorer$propertysheet$SetDefaultValueAction = PropertySheetTab.class$("org.openide.explorer.propertysheet.SetDefaultValueAction")) : class$org$openide$explorer$propertysheet$SetDefaultValueAction);
            this.popupMenu.add(setDefault.getPopupPresenter());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$000(Node.Property x0) {
        return PropertySheetTab.getToolTipTextForProperty(x0);
    }

    static {
        propsToIgnore.addAll(Arrays.asList("cookie", "icon", "openedIcon", "parentNode"));
    }

    private class ScrollableSplittedPanel
    extends SplittedPanel
    implements Scrollable {
        private Component scroll;
        private Container element;

        ScrollableSplittedPanel(Component scroll, Container element) {
            this.scroll = scroll;
            this.element = element;
            this.setSplitPosition(PropertySheetTab.this.mySheet.getSavedPosition());
            JPanel c = new JPanel();
            c.setPreferredSize(new Dimension(2, 2));
            this.setSplitterComponent(c);
            Border b = UIManager.getBorder("nb.splitChildBorder");
            if (b != null) {
                this.setBorder(b);
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            Component[] c = this.element.getComponents();
            if (c.length < 1) {
                return 1;
            }
            Dimension d = c[0].getSize();
            if (orientation == 1) {
                return d.height;
            }
            return d.width;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 1) {
                return this.scroll.getSize().height;
            }
            return this.scroll.getSize().width;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public void setSplitPosition(int value) {
            super.setSplitPosition(value);
            PropertySheetTab.this.mySheet.setSavedPosition(value);
        }
    }

    final class SettingsListener
    implements PropertyChangeListener {
        SettingsListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name == null) {
                return;
            }
            if (name.equals("sortingMode")) {
                try {
                    PropertySheetTab.this.setSortingMode((Integer)e.getNewValue());
                    if (PropertySheetTab.this.paneCreated) {
                        PropertySheetTab.this.createPane();
                    }
                }
                catch (PropertyVetoException ee) {
                    PropertyDialogManager.notify(ee);
                }
            } else if (name.equals("displayWritableOnly")) {
                if (PropertySheetTab.this.paneCreated) {
                    PropertySheetTab.this.createPane();
                }
            } else if (name.equals("valueColor")) {
                PropertySheetTab.this.setForegroundColor((Color)e.getNewValue());
            } else if (name.equals("disabledPropertyColor")) {
                PropertySheetTab.this.setDisabledColor((Color)e.getNewValue());
            } else if (name.equals("plastic")) {
                PropertySheetTab.this.setPlastic((Boolean)e.getNewValue());
            } else if (name.equals("propertyPaintingStyle")) {
                PropertySheetTab.this.setPaintingStyle((Integer)e.getNewValue());
            }
        }
    }

    private final class ButtonListener
    implements SheetButtonListener {
        private SheetButton b;
        private PropertyPanel p;

        public ButtonListener(SheetButton b, PropertyPanel p) {
            this.b = b;
            this.p = p;
        }

        public void sheetButtonClicked(ActionEvent e) {
            if ("rightMouseActionCommand".equals(e.getActionCommand())) {
                if (this.p.isWriteState()) {
                    this.p.setReadState();
                }
                return;
            }
            if (e.getSource() == this.b) {
                if (e.getID() == 1003) {
                    this.p.tryToSelectNextTag();
                } else if (this.p.isWriteState()) {
                    this.p.setReadState();
                    this.p.requestDefaultFocus();
                } else {
                    this.p.setWriteState();
                }
            }
        }

        public void sheetButtonEntered(ActionEvent e) {
            if (e.getSource() == this.b) {
                if (this.p.getReadComponent() != null) {
                    this.p.getReadComponent().setPressed(true);
                }
            } else {
                this.b.setPressed(true);
            }
        }

        public void sheetButtonExited(ActionEvent e) {
            if (e.getSource() == this.b) {
                if (this.p.getReadComponent() != null) {
                    this.p.getReadComponent().setPressed(false);
                }
            } else {
                this.b.setPressed(false);
            }
        }
    }

    private final class InstallPerformerListener
    implements SheetButtonListener {
        private CallbackSystemAction csa;
        private PopupPerformer performer;
        private PropertyPanel panel;
        static /* synthetic */ Class class$org$openide$actions$PopupAction;

        public InstallPerformerListener(PropertyPanel p) {
            this.panel = p;
        }

        public void sheetButtonClicked(ActionEvent e) {
        }

        public void sheetButtonEntered(ActionEvent e) {
            if (this.csa == null) {
                this.csa = (CallbackSystemAction)SystemAction.get(class$org$openide$actions$PopupAction == null ? (class$org$openide$actions$PopupAction = InstallPerformerListener.class$("org.openide.actions.PopupAction")) : class$org$openide$actions$PopupAction);
                this.performer = new PopupPerformer(this.panel);
            }
            this.csa.setActionPerformer(this.performer);
        }

        public void sheetButtonExited(ActionEvent e) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupPerformer) {
                this.csa.setActionPerformer(null);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private final class PopupPerformer
    implements ActionPerformer {
        private PropertyPanel panel;

        public PopupPerformer(PropertyPanel p) {
            this.panel = p;
        }

        public void performAction(SystemAction act) {
            Mutex.EVENT.readAccess(new Runnable(this){
                private final /* synthetic */ PopupPerformer this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ExPropertyModel epm;
                    FeatureDescriptor fd;
                    PropertyModel pm = PopupPerformer.access$300(this.this$1).getModel();
                    if (pm instanceof ExPropertyModel && (fd = (epm = (ExPropertyModel)pm).getFeatureDescriptor()) instanceof Node.Property) {
                        Node.Property np = (Node.Property)fd;
                        PopupPerformer.access$400(this.this$1).setActions(np);
                        PropertySheetTab.access$100(PopupPerformer.access$400(this.this$1));
                        PropertySheetTab.access$200(PopupPerformer.access$400(this.this$1)).show(PopupPerformer.access$300(this.this$1), 0, 0);
                    }
                }
            });
        }

        static /* synthetic */ PropertyPanel access$300(PopupPerformer x0) {
            return x0.panel;
        }

        static /* synthetic */ PropertySheetTab access$400(PopupPerformer x0) {
            return x0.PropertySheetTab.this;
        }
    }
}

