/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileObject;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

public class MultiFileSystem
extends FileSystem {
    static final long serialVersionUID = -767493828111559560L;
    static final String MASK = "_hidden";
    private FileSystem[] systems;
    private boolean propagateMasks = false;
    private transient MultiFileObject root;
    private static final int WRITE_SYSTEM_INDEX = 0;
    static /* synthetic */ Class class$org$openide$filesystems$MultiFileSystem;

    protected MultiFileSystem() {
        this(new FileSystem[1]);
    }

    public MultiFileSystem(FileSystem[] fileSystems) {
        this.systems = (FileSystem[])fileSystems.clone();
    }

    public void refresh(boolean expected) {
        Enumeration en = this.getMultiRoot().existingSubFiles(true);
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            fo.refresh(expected);
        }
    }

    protected final void setDelegates(FileSystem[] fileSystems) {
        FileSystem[] oldSystems = this.systems;
        this.systems = fileSystems;
        this.getMultiRoot().updateAllAfterSetDelegates(oldSystems);
        List<FileSystem> oldList = Arrays.asList(oldSystems);
        List<FileSystem> newList = Arrays.asList(this.systems);
        HashSet<FileSystem> toRemove = new HashSet<FileSystem>(oldList);
        toRemove.removeAll(newList);
        Iterator<FileSystem> iter = toRemove.iterator();
        while (iter.hasNext()) {
            FileSystem fs = iter.next();
            if (fs == null) continue;
            fs.removeNotify();
        }
        HashSet<FileSystem> toAdd = new HashSet<FileSystem>(newList);
        toAdd.removeAll(oldList);
        Iterator<FileSystem> iter2 = toAdd.iterator();
        while (iter2.hasNext()) {
            FileSystem fs = iter2.next();
            if (fs == null) continue;
            fs.addNotify();
        }
    }

    protected final FileSystem[] getDelegates() {
        return this.systems;
    }

    public final boolean getPropagateMasks() {
        return this.propagateMasks;
    }

    protected final void setPropagateMasks(boolean pm) {
        this.propagateMasks = pm;
    }

    public boolean isReadOnly() {
        return this.systems[0] == null || this.systems[0].isReadOnly();
    }

    public String getDisplayName() {
        return FileSystem.getString("CTL_MultiFileSystem");
    }

    public FileObject getRoot() {
        return this.getMultiRoot();
    }

    private MultiFileObject getMultiRoot() {
        Class clazz = class$org$openide$filesystems$MultiFileSystem == null ? (class$org$openide$filesystems$MultiFileSystem = MultiFileSystem.class$("org.openide.filesystems.MultiFileSystem")) : class$org$openide$filesystems$MultiFileSystem;
        synchronized (clazz) {
            if (this.root == null) {
                this.root = new MultiFileObject(this);
            }
            MultiFileObject multiFileObject = this.root;
            return multiFileObject;
        }
    }

    public SystemAction[] getActions() {
        ArrayList<SystemAction> al = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> uniq = new HashSet<SystemAction>(101);
        FileSystem[] del = this.getDelegates();
        int i = 0;
        while (i < del.length) {
            if (del[i] != null) {
                SystemAction[] acts = del[i].getActions();
                int j = 0;
                while (j < acts.length) {
                    if (uniq.add(acts[j])) {
                        al.add(acts[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return al.toArray(new SystemAction[al.size()]);
    }

    public SystemAction[] getActions(Set foSet) {
        ArrayList<SystemAction> al = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> uniq = new HashSet<SystemAction>(101);
        FileSystem[] del = this.getDelegates();
        int i = 0;
        while (i < del.length) {
            if (del[i] != null) {
                SystemAction[] acts = del[i].getActions(foSet);
                int j = 0;
                while (j < acts.length) {
                    if (uniq.add(acts[j])) {
                        al.add(acts[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return al.toArray(new SystemAction[al.size()]);
    }

    public FileObject find(String aPackage, String name, String ext) {
        StringTokenizer st = new StringTokenizer(aPackage, ".");
        Enumeration<Object> en = name == null || ext == null ? st : new SequenceEnumeration(st, new SingletonEnumeration(name + '.' + ext));
        return this.getMultiRoot().find(en);
    }

    public FileObject findResource(String name) {
        if (name.length() == 0) {
            return this.getMultiRoot();
        }
        StringTokenizer tok = new StringTokenizer(name, "/");
        return this.getMultiRoot().find(tok);
    }

    protected final FileSystem findSystem(FileObject fo) throws IllegalArgumentException {
        try {
            if (fo instanceof MultiFileObject) {
                MultiFileObject mfo = (MultiFileObject)fo;
                return mfo.getLeaderFileSystem();
            }
        }
        catch (FileStateInvalidException ex) {
            return this;
        }
        throw new IllegalArgumentException(fo.getPath());
    }

    protected final void hideResource(String res, boolean hide) throws IOException {
        if (hide) {
            this.maskFile(this.createWritableOn(res), res);
        } else {
            this.unmaskFile(this.createWritableOn(res), res);
        }
    }

    protected static Enumeration hiddenFiles(FileObject folder, boolean rec) {
        Enumeration allFiles = folder.getChildren(rec);
        AlterEnumeration allNull = new AlterEnumeration(allFiles){

            public Object alter(Object fo) {
                String sf = ((FileObject)fo).getPath();
                if (sf.endsWith(MultiFileSystem.MASK)) {
                    return sf.substring(0, sf.length() - MultiFileSystem.MASK.length());
                }
                return null;
            }
        };
        return new FilterEnumeration(allNull);
    }

    protected FileObject findResourceOn(FileSystem fs, String res) {
        return fs.findResource(res);
    }

    protected FileSystem createWritableOn(String name) throws IOException {
        if (this.systems[0] == null || this.systems[0].isReadOnly()) {
            FSException.io("EXC_FSisRO", this.getDisplayName());
        }
        return this.systems[0];
    }

    protected FileSystem createWritableOnForRename(String oldName, String newName) throws IOException {
        return this.createWritableOn(newName);
    }

    protected Set createLocksOn(String name) throws IOException {
        FileSystem writable = this.createWritableOn(name);
        return Collections.singleton(writable);
    }

    protected void notifyMigration(FileObject fo) {
    }

    protected void markUnimportant(FileObject fo) {
    }

    public void prepareEnvironment(FileSystem.Environment env) throws EnvironmentNotSupportedException {
        FileSystem[] layers = this.getDelegates();
        int i = 0;
        while (i < layers.length) {
            if (layers[i] != null) {
                try {
                    layers[i].prepareEnvironment(env);
                }
                catch (EnvironmentNotSupportedException ense) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public void addNotify() {
        super.addNotify();
        int i = 0;
        while (i < this.systems.length) {
            if (this.systems[i] != null) {
                this.systems[i].addNotify();
            }
            ++i;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        int i = 0;
        while (i < this.systems.length) {
            if (this.systems[i] != null) {
                this.systems[i].removeNotify();
            }
            ++i;
        }
    }

    private static String[] split(String res, String[] store) {
        if (store == null) {
            store = new String[3];
        }
        int file = res.lastIndexOf(47);
        int dot = res.lastIndexOf(46);
        store[0] = file == -1 ? "" : res.substring(0, file);
        ++file;
        if (dot == -1) {
            store[1] = res.substring(file);
            store[2] = "";
        } else {
            store[1] = res.substring(file, dot);
            store[2] = res.substring(dot + 1);
        }
        return store;
    }

    Enumeration delegates(final String name) {
        ArrayEnumeration en = new ArrayEnumeration(this.systems);
        AlterEnumeration objsAndNulls = new AlterEnumeration(en){

            public Object alter(Object o) {
                FileSystem fs = (FileSystem)o;
                if (fs == null) {
                    return null;
                }
                return MultiFileSystem.this.findResourceOn(fs, name);
            }
        };
        return new FilterEnumeration(objsAndNulls);
    }

    void maskFile(FileSystem fs, String res) throws IOException {
        FileObject where = this.findResourceOn(fs, fs.getRoot().getPath());
        FileUtil.createData(where, res + MASK);
    }

    void unmaskFile(FileSystem fs, String res) throws IOException {
        FileObject fo = this.findResourceOn(fs, res + MASK);
        if (fo != null) {
            FileLock lock = fo.lock();
            try {
                fo.delete(lock);
                Object var6_5 = null;
                lock.releaseLock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                lock.releaseLock();
                throw throwable;
            }
        }
    }

    void unmaskFileOnAll(FileSystem fs, String res) throws IOException {
        FileSystem[] fss = this.getDelegates();
        int i = 0;
        while (i < fss.length) {
            if (fss[i] != null && !fss[i].isReadOnly()) {
                this.unmaskFile(fss[i], res);
                if (fss[i] == fs) {
                    return;
                }
            }
            ++i;
        }
    }

    static boolean isMaskFile(FileObject fo) {
        return fo.getExt().endsWith(MASK);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

