/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class DataObject
implements Node.Cookie,
Serializable,
HelpCtx.Provider {
    private static final long serialVersionUID = 3328227388376142699L;
    public static final String PROP_TEMPLATE = "template";
    public static final String PROP_NAME = "name";
    public static final String PROP_HELP = "helpCtx";
    public static final String PROP_MODIFIED = "modified";
    public static final String PROP_COOKIE = "cookie";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PRIMARY_FILE = "primaryFile";
    public static final String PROP_FILES = "files";
    static final String EA_ASSIGNED_LOADER = "NetBeansAttrAssignedLoader";
    static final String EA_ASSIGNED_LOADER_MODULE = "NetBeansAttrAssignedLoaderModule";
    private static ModifiedRegistry modified = new ModifiedRegistry();
    private static Set syncModified = Collections.synchronizedSet(modified);
    private boolean modif = false;
    private transient Node nodeDelegate;
    DataObjectPool.Item item;
    private DataLoader loader;
    private PropertyChangeSupport changeSupport;
    private VetoableChangeSupport vetoableChangeSupport;
    private static final Object listenersMethodLock = new Object();
    private Object nodeCreationLock = new Object();
    private static Registry REGISTRY_INSTANCE = new Registry();
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public DataObject(FileObject pf, DataLoader loader) throws DataObjectExistsException {
        this(pf, DataObjectPool.getPOOL().register(pf, loader), loader);
    }

    private DataObject(FileObject pf, DataObjectPool.Item item, DataLoader loader) {
        this.item = item;
        this.loader = loader;
        item.setDataObject(this);
    }

    protected void dispose() {
        DataObjectPool.Item item = this.item;
        if (item != null) {
            item.deregister(true);
            item.setDataObject(null);
            this.firePropertyChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void setValid(boolean valid) throws PropertyVetoException {
        if (!valid && this.isValid()) {
            this.fireVetoableChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
            this.dispose();
            this.setModified(false);
        }
    }

    public final boolean isValid() {
        return this.item.isValid();
    }

    public final DataLoader getLoader() {
        return this.loader;
    }

    protected final void markFiles() throws IOException {
        Iterator en = this.files().iterator();
        while (en.hasNext()) {
            FileObject fo = (FileObject)en.next();
            this.loader.markFile(fo);
        }
    }

    public Set files() {
        return Collections.singleton(this.getPrimaryFile());
    }

    public final Node getNodeDelegate() {
        if (!this.isValid()) {
            IllegalStateException e = new IllegalStateException("The data object " + this.getPrimaryFile() + " is invalid; you may not call getNodeDelegate on it any more; see #17020 and please fix your code");
            ErrorManager.getDefault().notify(1, e);
        }
        if (this.nodeDelegate == null) {
            Children.MUTEX.readAccess(new Runnable(){

                public void run() {
                    Object object = DataObject.this.nodeCreationLock;
                    synchronized (object) {
                        if (DataObject.this.nodeDelegate == null) {
                            DataObject.this.nodeDelegate = DataObject.this.createNodeDelegate();
                        }
                    }
                }
            });
            if (this.nodeDelegate == null) {
                throw new IllegalStateException("DataObject " + this + " has null node delegate");
            }
        }
        return this.nodeDelegate;
    }

    Node getClonedNodeDelegate(DataFilter filter) {
        return this.getNodeDelegate().cloneNode();
    }

    Node getNodeDelegateOrNull() {
        return this.nodeDelegate;
    }

    protected Node createNodeDelegate() {
        return new DataNode(this, Children.LEAF);
    }

    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryFile().lock();
    }

    static boolean setTemplate(FileObject fo, boolean newTempl) throws IOException {
        boolean oldTempl = false;
        Object o = fo.getAttribute(PROP_TEMPLATE);
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            oldTempl = true;
        }
        if (oldTempl == newTempl) {
            return false;
        }
        fo.setAttribute(PROP_TEMPLATE, newTempl ? Boolean.TRUE : null);
        return true;
    }

    public final void setTemplate(boolean newTempl) throws IOException {
        if (!DataObject.setTemplate(this.getPrimaryFile(), newTempl)) {
            return;
        }
        this.firePropertyChange(PROP_TEMPLATE, !newTempl ? Boolean.TRUE : Boolean.FALSE, newTempl ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isTemplate() {
        Object o = this.getPrimaryFile().getAttribute(PROP_TEMPLATE);
        boolean ret = false;
        if (o instanceof Boolean) {
            ret = (Boolean)o;
        }
        return ret;
    }

    public abstract boolean isDeleteAllowed();

    public abstract boolean isCopyAllowed();

    public abstract boolean isMoveAllowed();

    public boolean isShadowAllowed() {
        return true;
    }

    public abstract boolean isRenameAllowed();

    public boolean isModified() {
        return this.modif;
    }

    public void setModified(boolean modif) {
        if (this.modif != modif) {
            this.modif = modif;
            if (modif) {
                syncModified.add(this);
            } else {
                syncModified.remove(this);
            }
            this.firePropertyChange(PROP_MODIFIED, !modif ? Boolean.TRUE : Boolean.FALSE, modif ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public abstract HelpCtx getHelpCtx();

    public final FileObject getPrimaryFile() {
        return this.item.primaryFile;
    }

    public static DataObject find(FileObject fo) throws DataObjectNotFoundException {
        if (fo == null) {
            throw new IllegalArgumentException("Called DataObject.find on null");
        }
        try {
            if (!fo.isValid()) {
                throw new FileStateInvalidException(fo.toString());
            }
            DataObject obj = DataObjectPool.getPOOL().find(fo);
            if (obj != null) {
                return obj;
            }
            obj = ((DataLoaderPool)Lookup.getDefault().lookup(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = DataObject.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool)).findDataObject(fo);
            if (obj != null) {
                return obj;
            }
            throw new DataObjectNotFoundException(fo);
        }
        catch (DataObjectExistsException ex) {
            return ex.getDataObject();
        }
        catch (IOException ex) {
            DataObjectNotFoundException donfe = new DataObjectNotFoundException(fo);
            ErrorManager.getDefault().annotate((Throwable)donfe, ex);
            throw donfe;
        }
    }

    public static Registry getRegistry() {
        return REGISTRY_INSTANCE;
    }

    public String getName() {
        return this.getPrimaryFile().getName();
    }

    public String toString() {
        return super.toString() + '[' + this.getPrimaryFile() + ']';
    }

    public final DataFolder getFolder() {
        FileObject fo = this.getPrimaryFile().getParent();
        return fo == null ? null : DataFolder.findFolder(fo);
    }

    public final DataObject copy(final DataFolder f) throws IOException {
        final DataObject[] result = new DataObject[1];
        FileSystem fs = f.getPrimaryFile().getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                result[0] = DataObject.this.handleCopy(f);
            }
        });
        DataObject.fireOperationEvent(new OperationEvent.Copy(result[0], this), 1);
        return result[0];
    }

    protected abstract DataObject handleCopy(DataFolder var1) throws IOException;

    public final void delete() throws IOException {
        Object object = this.synchObject();
        synchronized (object) {
            FileSystem fs = this.getPrimaryFile().getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    DataObject.this.handleDelete();
                    DataObject.this.item.deregister(false);
                    DataObject.this.item.setDataObject(null);
                }
            });
        }
        this.firePropertyChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        DataObject.fireOperationEvent(new OperationEvent(this), 3);
    }

    protected abstract void handleDelete() throws IOException;

    public final void rename(final String name) throws IOException {
        String oldName;
        if (name != null && name.trim().length() == 0) {
            IllegalArgumentException iae = new IllegalArgumentException(this.getName());
            String msg = NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObject.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, "MSG_NotValidName", this.getName());
            ErrorManager.getDefault().annotate((Throwable)iae, msg);
            throw iae;
        }
        final FileObject[] files = new FileObject[2];
        Object object = this.synchObject();
        synchronized (object) {
            oldName = this.getName();
            if (oldName.equals(name)) {
                return;
            }
            files[0] = this.getPrimaryFile();
            FileSystem fs = files[0].getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    files[1] = DataObject.this.handleRename(name);
                    if (files[0] != files[1]) {
                        DataObject.this.item.changePrimaryFile(files[1]);
                    }
                }
            });
        }
        if (files[0] != files[1]) {
            this.firePropertyChange(PROP_PRIMARY_FILE, files[0], this.getPrimaryFile());
        }
        DataObject.fireOperationEvent(new OperationEvent.Rename(this, oldName), 4);
    }

    protected abstract FileObject handleRename(String var1) throws IOException;

    public final void move(final DataFolder df) throws IOException {
        FileObject old;
        Object object = this.synchObject();
        synchronized (object) {
            if (this.getFolder() == null) {
                return;
            }
            if (df.equals(this.getFolder())) {
                return;
            }
            old = this.getPrimaryFile();
            FileSystem fs = old.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject mf = DataObject.this.handleMove(df);
                    DataObject.this.item.changePrimaryFile(mf);
                }
            });
        }
        this.firePropertyChange(PROP_PRIMARY_FILE, old, this.getPrimaryFile());
        DataObject.fireOperationEvent(new OperationEvent.Move(this, old), 2);
    }

    protected abstract FileObject handleMove(DataFolder var1) throws IOException;

    protected DataShadow handleCreateShadow(DataFolder f) throws IOException {
        return DataShadow.create(f, this);
    }

    public final DataShadow createShadow(final DataFolder f) throws IOException {
        final DataShadow[] result = new DataShadow[1];
        FileSystem fs = f.getPrimaryFile().getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                result[0] = DataObject.this.handleCreateShadow(f);
            }
        });
        DataObject.fireOperationEvent(new OperationEvent.Copy(result[0], this), 5);
        return result[0];
    }

    public final DataObject createFromTemplate(DataFolder f) throws IOException {
        return this.createFromTemplate(f, null);
    }

    public final DataObject createFromTemplate(final DataFolder f, final String name) throws IOException {
        final DataObject[] result = new DataObject[1];
        FileSystem fs = f.getPrimaryFile().getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                result[0] = DataObject.this.handleCreateFromTemplate(f, name);
            }
        });
        DataObject.fireOperationEvent(new OperationEvent.Copy(result[0], this), 6);
        return result[0];
    }

    protected abstract DataObject handleCreateFromTemplate(DataFolder var1, String var2) throws IOException;

    private static void fireOperationEvent(OperationEvent ev, int type) {
        ((DataLoaderPool)Lookup.getDefault().lookup(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = DataObject.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool)).fireOperationEvent(ev, type);
    }

    Object synchObject() {
        return this.nodeCreationLock;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        Object object = listenersMethodLock;
        synchronized (object) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    protected final void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(name, oldValue, newValue);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        Object object = listenersMethodLock;
        synchronized (object) {
            if (this.vetoableChangeSupport == null) {
                this.vetoableChangeSupport = new VetoableChangeSupport(this);
            }
        }
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(l);
        }
    }

    protected final void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.fireVetoableChange(name, oldValue, newValue);
        }
    }

    public Node.Cookie getCookie(Class c) {
        if (c.isInstance(this)) {
            return this;
        }
        return null;
    }

    protected Node.Cookie getCookie(DataShadow shadow, Class clazz) {
        return this.getCookie(clazz);
    }

    public Object writeReplace() {
        return new Replace(this);
    }

    static String getString(String name) {
        return NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObject.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, name);
    }

    void recognizedByFolder() {
    }

    void notifyFileRenamed(FileRenameEvent fe) {
        if (fe.getFile().equals(this.getPrimaryFile())) {
            this.firePropertyChange(PROP_NAME, fe.getName(), this.getName());
        }
    }

    void notifyFileDeleted(FileEvent fe) {
    }

    void notifyFileDataCreated(FileEvent fe) {
    }

    void notifyAttributeChanged(FileAttributeEvent fae) {
        String attrFromFO;
        if (!EA_ASSIGNED_LOADER.equals(fae.getName())) {
            return;
        }
        FileObject f = fae.getFile();
        if (f != null && (attrFromFO = (String)f.getAttribute(EA_ASSIGNED_LOADER)) != null && !attrFromFO.equals(this.getLoader().getClass().getName())) {
            try {
                this.setValid(false);
            }
            catch (PropertyVetoException e) {
                ErrorManager.getDefault().notify(1, e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ModifiedRegistry
    extends HashSet {
        static final long serialVersionUID = -2861723614638919680L;
        private HashSet listeners;

        ModifiedRegistry() {
        }

        public final synchronized void addChangeListener(ChangeListener chl) {
            if (this.listeners == null) {
                this.listeners = new HashSet(5);
            }
            this.listeners.add(chl);
        }

        public final synchronized void removeChangeListener(ChangeListener chl) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(chl);
        }

        public boolean add(Object o) {
            boolean result = super.add(o);
            if (result) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
            return result;
        }

        public boolean remove(Object o) {
            boolean result = super.remove(o);
            if (result) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
            return result;
        }

        protected final void fireChangeEvent(ChangeEvent che) {
            HashSet cloned;
            if (this.listeners == null) {
                return;
            }
            ModifiedRegistry modifiedRegistry = this;
            synchronized (modifiedRegistry) {
                cloned = (HashSet)this.listeners.clone();
            }
            Iterator iter = cloned.iterator();
            while (iter.hasNext()) {
                ((ChangeListener)iter.next()).stateChanged(che);
            }
        }
    }

    public static final class Registry {
        private Registry() {
        }

        public void addChangeListener(ChangeListener chl) {
            modified.addChangeListener(chl);
        }

        public void removeChangeListener(ChangeListener chl) {
            modified.removeChangeListener(chl);
        }

        public Set getModifiedSet() {
            return Collections.unmodifiableSet(syncModified);
        }

        public DataObject[] getModified() {
            return ((AbstractCollection)modified).toArray(new DataObject[0]);
        }
    }

    public static interface Container
    extends Node.Cookie {
        public static final String PROP_CHILDREN = "children";

        public DataObject[] getChildren();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    private static final class Replace
    implements Serializable {
        private FileObject fo;
        private transient DataObject obj;
        private static final long serialVersionUID = -627843044348243058L;

        public Replace(DataObject obj) {
            this.obj = obj;
            this.fo = obj.getPrimaryFile();
        }

        public Object readResolve() {
            return this.obj;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.obj = DataObject.find(this.fo);
        }
    }
}

