/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.MultiDataObject;

public abstract class MultiFileLoader
extends DataLoader {
    static final long serialVersionUID = 1521919955690157343L;

    protected MultiFileLoader(Class representationClass) {
        super(representationClass);
    }

    protected MultiFileLoader(String representationClassName) {
        super(representationClassName);
    }

    protected final DataObject handleFindDataObject(FileObject fo, DataLoader.RecognizedFiles recognized) throws IOException {
        MultiDataObject obj;
        FileObject primary = this.findPrimaryFileImpl(fo);
        if (primary == null) {
            return null;
        }
        try {
            obj = this.createMultiObject(primary);
        }
        catch (DataObjectExistsException ex) {
            DataObject dataObject = ex.getDataObject();
            if (dataObject.getLoader() != this) {
                dataObject = this.checkCollision(dataObject, fo);
            }
            if (!(dataObject instanceof MultiDataObject)) {
                throw ex;
            }
            obj = (MultiDataObject)dataObject;
        }
        if (obj.getLoader() != this) {
            return null;
        }
        obj.markSecondaryEntriesRecognized(recognized);
        obj.registerEntry(fo);
        return obj;
    }

    protected abstract FileObject findPrimaryFile(FileObject var1);

    protected abstract MultiDataObject createMultiObject(FileObject var1) throws DataObjectExistsException, IOException;

    protected abstract MultiDataObject.Entry createPrimaryEntry(MultiDataObject var1, FileObject var2);

    protected abstract MultiDataObject.Entry createSecondaryEntry(MultiDataObject var1, FileObject var2);

    DataObject checkCollision(DataObject obj, FileObject file) {
        FileObject primary = obj.getPrimaryFile();
        DataObjectPool.getPOOL().revalidate(new HashSet<FileObject>(Collections.singleton(primary)));
        DataObject result = DataObjectPool.getPOOL().find(primary);
        return result;
    }

    void checkConsistency(MultiDataObject obj) {
        FileObject primary = obj.getPrimaryFile();
        if (primary.equals(this.findPrimaryFileImpl(primary))) {
            return;
        }
        try {
            obj.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    void checkFiles(MultiDataObject obj) {
        FileObject primary = obj.getPrimaryFile();
        FileObject parent = primary.getParent();
        FileObject[] arr = parent.getChildren();
        int i = 0;
        while (i < arr.length) {
            FileObject pf = this.findPrimaryFileImpl(arr[i]);
            if (pf == primary) {
                try {
                    DataObject.find(arr[i]);
                }
                catch (DataObjectNotFoundException ex) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    MultiDataObject.Entry createSecondaryEntryImpl(MultiDataObject obj, FileObject secondaryFile) {
        return this.createSecondaryEntry(obj, secondaryFile);
    }

    FileObject findPrimaryFileImpl(FileObject fo) {
        return this.findPrimaryFile(fo);
    }
}

