/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Utilities;

public abstract class WeakListener
implements EventListener {
    private Reference ref;
    Class listenerClass;
    private Reference source;
    static /* synthetic */ Class class$java$lang$Object;

    protected WeakListener(Class listenerClass, EventListener l) {
        this.listenerClass = listenerClass;
        this.ref = new ListenerReference(l, this);
        if (!listenerClass.isAssignableFrom(l.getClass())) {
            throw new IllegalArgumentException(this.getClass().getName() + " constructor is calling WeakListner.<init> with illegal arguments");
        }
    }

    protected final void setSource(Object source) {
        this.source = source == null ? null : new WeakReference<Object>(source);
    }

    protected abstract String removeMethodName();

    protected final EventListener get(EventObject ev) {
        Object l = this.ref.get();
        if (l == null) {
            this.removeListener(ev == null ? null : ev.getSource());
        }
        return (EventListener)l;
    }

    private void removeListener(Object eventSource) {
        Object[] params = new Object[]{this.getImplementator()};
        Object src = this.source == null ? null : this.source.get();
        try {
            Method m = null;
            if (src != null && (m = this.getRemoveMethod(src)) != null) {
                m.invoke(src, params);
            }
            if (eventSource != src && eventSource != null && (m = this.getRemoveMethod(eventSource)) != null) {
                m.invoke(eventSource, params);
            }
            if (m == null && this.source == null) {
                ErrorManager.getDefault().log(16, "Can't remove " + this.listenerClass.getName() + "source=" + this.source + ", src=" + src + ", eventSource=" + eventSource);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(4096, ex);
        }
    }

    private final Method getRemoveMethod(Object src) {
        Class[] clarray = new Class[]{this.listenerClass};
        String methodName = this.removeMethodName();
        Class<?> methodClass = src.getClass();
        Method m = null;
        try {
            m = methodClass.getMethod(methodName, clarray);
        }
        catch (NoSuchMethodException e) {
            do {
                try {
                    m = methodClass.getDeclaredMethod(methodName, clarray);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
                methodClass = methodClass.getSuperclass();
            } while (m == null && methodClass != (class$java$lang$Object == null ? WeakListener.class$("java.lang.Object") : class$java$lang$Object));
        }
        if (!(m == null || Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers()))) {
            ((AccessibleObject)m).setAccessible(true);
        }
        return m;
    }

    Object getImplementator() {
        return this;
    }

    public String toString() {
        Object listener = this.ref.get();
        return this.getClass().getName() + "[" + (listener == null ? "null" : listener.getClass().getName() + "]");
    }

    public static NodeListener node(NodeListener l, Object source) {
        Node wl = new Node(l);
        wl.setSource(source);
        return wl;
    }

    public static PropertyChangeListener propertyChange(PropertyChangeListener l, Object source) {
        PropertyChange wl = new PropertyChange(l);
        wl.setSource(source);
        return wl;
    }

    public static VetoableChangeListener vetoableChange(VetoableChangeListener l, Object source) {
        VetoableChange wl = new VetoableChange(l);
        wl.setSource(source);
        return wl;
    }

    public static FileChangeListener fileChange(FileChangeListener l, Object source) {
        FileChange wl = new FileChange(l);
        wl.setSource(source);
        return wl;
    }

    public static FileStatusListener fileStatus(FileStatusListener l, Object source) {
        FileStatus wl = new FileStatus(l);
        wl.setSource(source);
        return wl;
    }

    public static RepositoryListener repository(RepositoryListener l, Object source) {
        Repository wl = new Repository(l);
        wl.setSource(source);
        return wl;
    }

    public static DocumentListener document(DocumentListener l, Object source) {
        Document wl = new Document(l);
        wl.setSource(source);
        return wl;
    }

    public static ChangeListener change(ChangeListener l, Object source) {
        Change wl = new Change(l);
        wl.setSource(source);
        return wl;
    }

    public static FocusListener focus(FocusListener l, Object source) {
        Focus wl = new Focus(l);
        wl.setSource(source);
        return wl;
    }

    public static OperationListener operation(OperationListener l, Object source) {
        Operation wl = new Operation(l);
        wl.setSource(source);
        return wl;
    }

    public static EventListener create(Class lType, EventListener l, Object source) {
        ProxyListener pl = new ProxyListener(lType, l);
        pl.setSource(source);
        return (EventListener)pl.proxy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ListenerReference
    extends WeakReference
    implements Runnable {
        private static Class lastClass;
        private static String lastMethodName;
        private static Method lastRemove;
        private static Object LOCK;
        final WeakListener weakListener;

        public ListenerReference(Object ref, WeakListener weakListener) {
            super(ref, Utilities.activeReferenceQueue());
            this.weakListener = weakListener;
        }

        public void run() {
            WeakListener ref;
            Method remove;
            Object src;
            Class[] types;
            Object[] params;
            block23: {
                block22: {
                    ListenerReference lr = this;
                    params = new Object[1];
                    types = new Class[1];
                    src = null;
                    remove = null;
                    ref = lr.weakListener;
                    if (ref.source == null) break block22;
                    Object t = ref.source.get();
                    src = t;
                    if (t != null) break block23;
                }
                return;
            }
            Class<?> methodClass = src.getClass();
            String methodName = ref.removeMethodName();
            Object object = LOCK;
            synchronized (object) {
                if (lastClass == methodClass && lastMethodName == methodName && lastRemove != null) {
                    remove = lastRemove;
                }
            }
            if (remove == null) {
                types[0] = ref.listenerClass;
                remove = null;
                try {
                    remove = methodClass.getMethod(methodName, types);
                }
                catch (NoSuchMethodException e) {
                    while ((methodClass = methodClass.getSuperclass()) != null) {
                        try {
                            remove = methodClass.getDeclaredMethod(methodName, types);
                            break;
                        }
                        catch (NoSuchMethodException ex) {
                        }
                    }
                }
                if (remove == null) {
                    ErrorManager.getDefault().log(16, "Can't remove " + ref.listenerClass.getName() + "from " + src);
                    return;
                }
                if (!Modifier.isPublic(remove.getModifiers()) || !Modifier.isPublic(remove.getDeclaringClass().getModifiers())) {
                    ((AccessibleObject)remove).setAccessible(true);
                }
                Object e = LOCK;
                synchronized (e) {
                    lastClass = methodClass;
                    lastMethodName = methodName;
                    lastRemove = remove;
                }
            }
            if (remove == null) {
                return;
            }
            params[0] = ref.getImplementator();
            try {
                remove.invoke(src, params);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, "Problem encountered while calling " + methodClass + "." + methodName + "(...) on " + src);
                ErrorManager.getDefault().notify(1, ex);
            }
        }

        static {
            LOCK = new Object();
        }
    }

    private static class ProxyListener
    extends WeakListener
    implements InvocationHandler {
        public final Object proxy;
        private static Method equalsMth;
        static /* synthetic */ Class class$java$lang$Object;

        private static Method getEquals() {
            if (equalsMth == null) {
                try {
                    equalsMth = (class$java$lang$Object == null ? (class$java$lang$Object = ProxyListener.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = ProxyListener.class$("java.lang.Object")) : class$java$lang$Object);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            return equalsMth;
        }

        public ProxyListener(Class c, EventListener listener) {
            super(c, listener);
            this.proxy = Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)this);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = ProxyListener.class$("java.lang.Object")) : class$java$lang$Object)) {
                if (method == ProxyListener.getEquals()) {
                    boolean ret = this.equals(args[0]);
                    return ret ? Boolean.TRUE : Boolean.FALSE;
                }
                return method.invoke((Object)this, args);
            }
            EventObject ev = args[0] instanceof EventObject ? (EventObject)args[0] : null;
            EventListener listener = super.get(ev);
            if (listener != null) {
                return method.invoke((Object)listener, args);
            }
            return null;
        }

        protected String removeMethodName() {
            String name = this.listenerClass.getName();
            int dot = name.lastIndexOf(46);
            int i = (name = name.substring(dot + 1)).lastIndexOf(36);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            return "remove".concat(name);
        }

        public String toString() {
            return super.toString() + "[" + this.listenerClass + "]";
        }

        public boolean equals(Object obj) {
            return this.proxy == obj || this == obj;
        }

        Object getImplementator() {
            return this.proxy;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static final class Operation
    extends WeakListener
    implements OperationListener {
        static /* synthetic */ Class class$org$openide$loaders$OperationListener;

        public Operation(OperationListener l) {
            super(class$org$openide$loaders$OperationListener == null ? (class$org$openide$loaders$OperationListener = Operation.class$("org.openide.loaders.OperationListener")) : class$org$openide$loaders$OperationListener, l);
        }

        protected String removeMethodName() {
            return "removeOperationListener";
        }

        public void operationPostCreate(OperationEvent ev) {
            OperationListener l = (OperationListener)super.get(ev);
            if (l != null) {
                l.operationPostCreate(ev);
            }
        }

        public void operationCopy(OperationEvent.Copy ev) {
            OperationListener l = (OperationListener)super.get(ev);
            if (l != null) {
                l.operationCopy(ev);
            }
        }

        public void operationMove(OperationEvent.Move ev) {
            OperationListener l = (OperationListener)super.get(ev);
            if (l != null) {
                l.operationMove(ev);
            }
        }

        public void operationDelete(OperationEvent ev) {
            OperationListener l = (OperationListener)super.get(ev);
            if (l != null) {
                l.operationDelete(ev);
            }
        }

        public void operationRename(OperationEvent.Rename ev) {
            OperationListener l = (OperationListener)super.get(ev);
            if (l != null) {
                l.operationRename(ev);
            }
        }

        public void operationCreateShadow(OperationEvent.Copy ev) {
            OperationListener l = (OperationListener)super.get(ev);
            if (l != null) {
                l.operationCreateShadow(ev);
            }
        }

        public void operationCreateFromTemplate(OperationEvent.Copy ev) {
            OperationListener l = (OperationListener)super.get(ev);
            if (l != null) {
                l.operationCreateFromTemplate(ev);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class Focus
    extends WeakListener
    implements FocusListener {
        static /* synthetic */ Class class$java$awt$event$FocusListener;

        public Focus(FocusListener l) {
            super(class$java$awt$event$FocusListener == null ? (class$java$awt$event$FocusListener = Focus.class$("java.awt.event.FocusListener")) : class$java$awt$event$FocusListener, l);
        }

        public void focusGained(FocusEvent ev) {
            FocusListener l = (FocusListener)super.get(ev);
            if (l != null) {
                l.focusGained(ev);
            }
        }

        public void focusLost(FocusEvent ev) {
            FocusListener l = (FocusListener)super.get(ev);
            if (l != null) {
                l.focusLost(ev);
            }
        }

        protected String removeMethodName() {
            return "removeFocusListener";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class Node
    extends PropertyChange
    implements NodeListener {
        static /* synthetic */ Class class$org$openide$nodes$NodeListener;

        public Node(NodeListener l) {
            super(class$org$openide$nodes$NodeListener == null ? (class$org$openide$nodes$NodeListener = Node.class$("org.openide.nodes.NodeListener")) : class$org$openide$nodes$NodeListener, l);
        }

        public void childrenAdded(NodeMemberEvent ev) {
            NodeListener l = (NodeListener)super.get(ev);
            if (l != null) {
                l.childrenAdded(ev);
            }
        }

        public void childrenRemoved(NodeMemberEvent ev) {
            NodeListener l = (NodeListener)super.get(ev);
            if (l != null) {
                l.childrenRemoved(ev);
            }
        }

        public void childrenReordered(NodeReorderEvent ev) {
            NodeListener l = (NodeListener)super.get(ev);
            if (l != null) {
                l.childrenReordered(ev);
            }
        }

        public void nodeDestroyed(NodeEvent ev) {
            NodeListener l = (NodeListener)super.get(ev);
            if (l != null) {
                l.nodeDestroyed(ev);
            }
        }

        protected String removeMethodName() {
            return "removeNodeListener";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class Change
    extends WeakListener
    implements ChangeListener {
        static /* synthetic */ Class class$javax$swing$event$ChangeListener;

        public Change(ChangeListener l) {
            super(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = Change.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
        }

        public void stateChanged(ChangeEvent ev) {
            ChangeListener l = (ChangeListener)super.get(ev);
            if (l != null) {
                l.stateChanged(ev);
            }
        }

        protected String removeMethodName() {
            return "removeChangeListener";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class Document
    extends WeakListener
    implements DocumentListener {
        static /* synthetic */ Class class$javax$swing$event$DocumentListener;

        public Document(DocumentListener l) {
            super(class$javax$swing$event$DocumentListener == null ? (class$javax$swing$event$DocumentListener = Document.class$("javax.swing.event.DocumentListener")) : class$javax$swing$event$DocumentListener, l);
        }

        public void changedUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.changedUpdate(ev);
            }
        }

        public void insertUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.insertUpdate(ev);
            }
        }

        public void removeUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.removeUpdate(ev);
            }
        }

        protected String removeMethodName() {
            return "removeDocumentListener";
        }

        private DocumentListener docGet(DocumentEvent ev) {
            DocumentListener l = (DocumentListener)((WeakListener)this).ref.get();
            if (l == null) {
                ((WeakListener)this).removeListener(ev.getDocument());
            }
            return l;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class Repository
    extends WeakListener
    implements RepositoryListener {
        static /* synthetic */ Class class$org$openide$filesystems$RepositoryListener;

        public Repository(RepositoryListener l) {
            super(class$org$openide$filesystems$RepositoryListener == null ? (class$org$openide$filesystems$RepositoryListener = Repository.class$("org.openide.filesystems.RepositoryListener")) : class$org$openide$filesystems$RepositoryListener, l);
        }

        public void fileSystemAdded(RepositoryEvent ev) {
            RepositoryListener l = (RepositoryListener)super.get(ev);
            if (l != null) {
                l.fileSystemAdded(ev);
            }
        }

        public void fileSystemRemoved(RepositoryEvent ev) {
            RepositoryListener l = (RepositoryListener)super.get(ev);
            if (l != null) {
                l.fileSystemRemoved(ev);
            }
        }

        public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
            RepositoryListener l = (RepositoryListener)super.get(ev);
            if (l != null) {
                l.fileSystemPoolReordered(ev);
            }
        }

        protected String removeMethodName() {
            return "removeRepositoryListener";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class FileStatus
    extends WeakListener
    implements FileStatusListener {
        static /* synthetic */ Class class$org$openide$filesystems$FileStatusListener;

        public FileStatus(FileStatusListener l) {
            super(class$org$openide$filesystems$FileStatusListener == null ? (class$org$openide$filesystems$FileStatusListener = FileStatus.class$("org.openide.filesystems.FileStatusListener")) : class$org$openide$filesystems$FileStatusListener, l);
        }

        public void annotationChanged(FileStatusEvent ev) {
            FileStatusListener l = (FileStatusListener)super.get(ev);
            if (l != null) {
                l.annotationChanged(ev);
            }
        }

        protected String removeMethodName() {
            return "removeFileStatusListener";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class FileChange
    extends WeakListener
    implements FileChangeListener {
        static /* synthetic */ Class class$org$openide$filesystems$FileChangeListener;

        public FileChange(FileChangeListener l) {
            super(class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = FileChange.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener, l);
        }

        public void fileFolderCreated(FileEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get(ev);
            if (l != null) {
                l.fileFolderCreated(ev);
            }
        }

        public void fileDataCreated(FileEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get(ev);
            if (l != null) {
                l.fileDataCreated(ev);
            }
        }

        public void fileChanged(FileEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get(ev);
            if (l != null) {
                l.fileChanged(ev);
            }
        }

        public void fileDeleted(FileEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get(ev);
            if (l != null) {
                l.fileDeleted(ev);
            }
        }

        public void fileRenamed(FileRenameEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get(ev);
            if (l != null) {
                l.fileRenamed(ev);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent ev) {
            FileChangeListener l = (FileChangeListener)super.get(ev);
            if (l != null) {
                l.fileAttributeChanged(ev);
            }
        }

        protected String removeMethodName() {
            return "removeFileChangeListener";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class VetoableChange
    extends WeakListener
    implements VetoableChangeListener {
        static /* synthetic */ Class class$java$beans$VetoableChangeListener;

        public VetoableChange(VetoableChangeListener l) {
            super(class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = VetoableChange.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener, l);
        }

        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            VetoableChangeListener l = (VetoableChangeListener)super.get(ev);
            if (l != null) {
                l.vetoableChange(ev);
            }
        }

        protected String removeMethodName() {
            return "removeVetoableChangeListener";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class PropertyChange
    extends WeakListener
    implements PropertyChangeListener {
        static /* synthetic */ Class class$java$beans$PropertyChangeListener;

        public PropertyChange(PropertyChangeListener l) {
            super(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = PropertyChange.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
        }

        PropertyChange(Class clazz, PropertyChangeListener l) {
            super(clazz, l);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            PropertyChangeListener l = (PropertyChangeListener)super.get(ev);
            if (l != null) {
                l.propertyChange(ev);
            }
        }

        protected String removeMethodName() {
            return "removePropertyChangeListener";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

