/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public abstract class CallbackSystemAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final String PROP_ACTION_PERFORMER = "actionPerformer";
    private static final WeakSet notSurviving = new WeakSet(37);
    private static final WeakSet surviving = new WeakSet(37);
    private static final Object LISTENER = new Object();
    private static TopComponent.Registry registry;
    private static ExplorerManager explorerManager;
    private static FocusTracker ft;
    static final long serialVersionUID = -6305817805474624653L;

    protected void initialize() {
        super.initialize();
        this.updateEnabled();
        this.setSurviveFocusChange(false);
    }

    public ActionPerformer getActionPerformer() {
        return (ActionPerformer)this.getProperty(PROP_ACTION_PERFORMER);
    }

    public void setActionPerformer(ActionPerformer performer) {
        this.putProperty(PROP_ACTION_PERFORMER, performer);
        this.updateEnabled();
    }

    private void updateEnabled() {
        Action action = this.findGlobalContextAction();
        if (action != null) {
            this.setEnabled(action.isEnabled());
            Object object = LISTENER;
            synchronized (object) {
                ActionDelegateListener l = (ActionDelegateListener)this.getProperty(LISTENER);
                if (l == null) {
                    l = new ActionDelegateListener(this, action);
                    this.putProperty(LISTENER, l);
                } else {
                    l.attach(action);
                }
            }
        } else {
            if (this.getActionPerformer() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.clearListener();
        }
    }

    private void clearListener() {
        Object object = LISTENER;
        synchronized (object) {
            ActionDelegateListener l = (ActionDelegateListener)this.getProperty(LISTENER);
            if (l != null) {
                l.clear();
                this.putProperty(LISTENER, null);
            }
        }
    }

    public void actionPerformed(ActionEvent ev) {
        Action action = this.findGlobalContextAction();
        if (action != null) {
            action.actionPerformed(ev);
            return;
        }
        ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            ap.performAction(this);
            return;
        }
    }

    private Action findGlobalContextAction() {
        ActionMap map;
        TopComponent tc = TopComponent.getRegistry().getActivated();
        if (tc != null && (map = tc.getActionMap()) != null) {
            Object key = this.getActionMapKey();
            return map.get(key);
        }
        return null;
    }

    public void performAction() {
        ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            ap.performAction(this);
        }
    }

    public Object getActionMapKey() {
        return this.getClass().getName();
    }

    public boolean getSurviveFocusChange() {
        this.getProperty(null);
        return !notSurviving.contains(this.getClass());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    public void setSurviveFocusChange(boolean b) {
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            if (b) {
                notSurviving.remove(this.getClass());
                surviving.add(this.getClass());
            } else {
                notSurviving.add(this.getClass());
                surviving.remove(this.getClass());
            }
        }
    }

    static TopComponent.Registry getRegistry() {
        if (registry != null) {
            return registry;
        }
        try {
            Class<?> c = Class.forName("org.openide.windows.TopComponent$Registry");
            registry = (TopComponent.Registry)Lookup.getDefault().lookup(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (registry == null && ft == null) {
            CallbackSystemAction.startTrackingFocus();
        }
        if (registry != null) {
            CallbackSystemAction.stopTrackingFocus();
            registry.addPropertyChangeListener(new FocusTracker());
        }
        return registry;
    }

    static ExplorerManager getExplorerManager() {
        return explorerManager;
    }

    static void setExplorerManager(ExplorerManager e) {
        explorerManager = e;
    }

    private static void startTrackingFocus() {
        ft = new FocusTracker();
        Toolkit.getDefaultToolkit().addAWTEventListener(ft, 4L);
    }

    private static void stopTrackingFocus() {
        if (ft != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(ft);
            ft = null;
        }
    }

    private static ArrayList toInstances(Set s) {
        ArrayList<SharedClassObject> actions;
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            actions = new ArrayList<SharedClassObject>(s.size());
            Iterator it = s.iterator();
            while (it.hasNext()) {
                Class c = (Class)it.next();
                SharedClassObject a = SharedClassObject.findObject(c, false);
                if (a == null) continue;
                actions.add(a);
            }
        }
        return actions;
    }

    private static void clearActionPerformers() {
        CallbackSystemAction a;
        ArrayList actions = CallbackSystemAction.toInstances(notSurviving);
        Iterator it = ((AbstractList)actions).iterator();
        while (it.hasNext()) {
            a = (CallbackSystemAction)it.next();
            a.setActionPerformer(null);
        }
        actions = CallbackSystemAction.toInstances(surviving);
        it = ((AbstractList)actions).iterator();
        while (it.hasNext()) {
            a = (CallbackSystemAction)it.next();
            a.updateEnabled();
        }
    }

    static {
        CallbackSystemAction.getRegistry();
    }

    private static final class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar,
    PropertyChangeListener {
        private CallbackSystemAction delegate;
        private Lookup.Result result;
        private boolean enabled;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private PropertyChangeListener weakL;
        private Action last;
        static /* synthetic */ Class class$javax$swing$ActionMap;
        static /* synthetic */ Class class$org$openide$util$LookupListener;
        static /* synthetic */ Class class$org$openide$util$actions$CallableSystemAction;

        public DelegateAction(CallbackSystemAction a, Lookup actionContext) {
            this.delegate = a;
            this.weakL = WeakListener.propertyChange(this, null);
            this.enabled = a.getActionPerformer() != null;
            this.result = actionContext.lookup(new Lookup.Template(class$javax$swing$ActionMap == null ? (class$javax$swing$ActionMap = DelegateAction.class$("javax.swing.ActionMap")) : class$javax$swing$ActionMap));
            this.result.addLookupListener((LookupListener)WeakListener.create(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = DelegateAction.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, this, this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public void actionPerformed(ActionEvent e) {
            Action a = this.findAction();
            if (a != null) {
                a.actionPerformed(e);
            } else {
                Object value;
                Object source = e.getSource();
                if (source instanceof Component && SwingUtilities.getWindowAncestor((Component)source) instanceof Dialog && !Boolean.TRUE.equals(value = this.delegate.getValue("OpenIDE-Transmodal-Action"))) {
                    return;
                }
                this.delegate.actionPerformed(e);
            }
        }

        public boolean isEnabled() {
            Action a = this.findAction();
            if (a == null) {
                a = this.delegate;
            }
            if (a != this.last) {
                if (this.last != null) {
                    this.last.removePropertyChangeListener(this.weakL);
                }
                this.last = a;
                this.last.addPropertyChangeListener(this.weakL);
            }
            return a.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public void putValue(String key, Object o) {
        }

        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        public void setEnabled(boolean b) {
        }

        public void resultChanged(LookupEvent ev) {
            boolean newEnabled = this.isEnabled();
            if (newEnabled != this.enabled) {
                this.support.firePropertyChange("enabled", this.enabled, newEnabled);
                this.enabled = newEnabled;
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.resultChanged(null);
        }

        private Action findAction() {
            List c;
            Collection collection = c = this.result != null ? this.result.allInstances() : Collections.EMPTY_LIST;
            if (!c.isEmpty()) {
                Object key = this.delegate.getActionMapKey();
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    ActionMap map = (ActionMap)it.next();
                    Action action = map.get(key);
                    if (action == null) continue;
                    return action;
                }
            }
            return null;
        }

        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverriden(this.delegate, "getMenuPresenter")) {
                return this.delegate.getMenuPresenter();
            }
            return new Actions.MenuItem(this, true);
        }

        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverriden(this.delegate, "getPopupPresenter")) {
                return this.delegate.getPopupPresenter();
            }
            return new Actions.MenuItem(this, false);
        }

        public Component getToolbarPresenter() {
            if (this.isMethodOverriden(this.delegate, "getToolbarPresenter")) {
                return this.delegate.getToolbarPresenter();
            }
            return new Actions.ToolbarButton(this);
        }

        private boolean isMethodOverriden(CallableSystemAction d, String name) {
            try {
                Method m = d.getClass().getMethod(name, new Class[0]);
                return m.getDeclaringClass() != (class$org$openide$util$actions$CallableSystemAction == null ? (class$org$openide$util$actions$CallableSystemAction = DelegateAction.class$("org.openide.util.actions.CallableSystemAction")) : class$org$openide$util$actions$CallableSystemAction);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Error searching for method " + name + " in " + d);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class ActionDelegateListener
    implements PropertyChangeListener {
        private CallbackSystemAction action;
        private Action delegate;

        public ActionDelegateListener(CallbackSystemAction c, Action delegate) {
            this.action = c;
            this.delegate = delegate;
            delegate.addPropertyChangeListener(this);
        }

        public void clear() {
            Action a = this.delegate;
            if (a == null) {
                return;
            }
            this.delegate = null;
            a.removePropertyChangeListener(this);
        }

        public void attach(Action action) {
            if (this.delegate == action) {
                return;
            }
            if (this.delegate != null) {
                this.delegate.removePropertyChangeListener(this);
            }
            this.delegate = action;
            action.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object object = LISTENER;
            synchronized (object) {
                if (this.delegate == null) {
                    return;
                }
            }
            this.action.updateEnabled();
        }
    }

    private static class FocusTracker
    implements AWTEventListener,
    PropertyChangeListener {
        FocusTracker() {
        }

        public void eventDispatched(AWTEvent event) {
            FocusEvent fe;
            if (event instanceof FocusEvent && ((fe = (FocusEvent)event).getID() & 0x3EC) == 0) {
                return;
            }
            Object source = event.getSource();
            if (source instanceof Component) {
                Component c = (Component)source;
                while (c != null && !(c instanceof ExplorerManager.Provider)) {
                    c = c.getParent();
                }
                if (c instanceof ExplorerManager.Provider) {
                    CallbackSystemAction.setExplorerManager(((ExplorerManager.Provider)((Object)c)).getExplorerManager());
                }
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("activated".equals(ev.getPropertyName())) {
                CallbackSystemAction.clearActionPerformers();
            }
        }
    }
}

