/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector;

import com.codestreet.selector.ISelector;
import com.codestreet.selector.parser.IExpression;
import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.InvalidSelectorException;
import com.codestreet.selector.parser.Result;
import com.codestreet.selector.parser.SelectorParser;
import java.util.Collections;
import java.util.Map;

public class Selector
implements ISelector {
    private final IExpression root_;
    private final Map identifiers_;
    private final String selector_;

    public static Selector getInstance(String selector) throws InvalidSelectorException {
        return Selector.getInstance(selector, false);
    }

    public static Selector getInstance(String selector, boolean trace) throws InvalidSelectorException {
        if (selector == null) {
            throw new NullPointerException("NULL selector");
        }
        SelectorParser.SelectorParseState exp = SelectorParser.doParse(selector, trace);
        return new Selector(selector, exp.getRoot(), exp.getIdentifiers());
    }

    private Selector(String selector, IExpression root, Map identifiers) {
        this.selector_ = selector;
        this.root_ = root;
        this.identifiers_ = Collections.unmodifiableMap(identifiers);
    }

    public Result eval(Map identifiers) {
        return (Result)this.root_.eval(identifiers);
    }

    public Result eval(IValueProvider provider, Object corr) {
        return (Result)this.root_.eval(provider, corr);
    }

    public Map getIdentifiers() {
        return this.identifiers_;
    }

    public String getSelector() {
        return this.selector_;
    }

    public String toString() {
        return this.selector_;
    }
}

