/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.parser;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class BaseException
extends Exception {
    private Throwable previousCause = null;
    private String stackTraceString;

    public BaseException() {
    }

    public BaseException(String message) {
        super(message);
    }

    public BaseException(Throwable root) {
        if (root != null) {
            this.previousCause = root;
            this.stackTraceString = BaseException.generateStackTraceString(root);
        } else {
            this.previousCause = new Exception("ERROR: A null value for root was passed to the constructor of RBaseException");
            this.stackTraceString = BaseException.generateStackTraceString(this.previousCause);
        }
    }

    public BaseException(String msg, Throwable root) {
        super(msg);
        if (root != null) {
            this.previousCause = root;
            this.stackTraceString = BaseException.generateStackTraceString(root);
        } else {
            this.previousCause = new Exception("ERROR: A null value for root was passed to the constructor of RBaseException");
            this.stackTraceString = BaseException.generateStackTraceString(this.previousCause);
        }
    }

    public BaseException(String msg, Object[] inserts, Throwable root) {
        super(msg);
        if (root != null) {
            this.previousCause = root;
            this.stackTraceString = BaseException.generateStackTraceString(root);
        } else {
            this.previousCause = new Exception("ERROR: A null value for root was passed to the constructor of RBaseException");
            this.stackTraceString = BaseException.generateStackTraceString(this.previousCause);
        }
    }

    public BaseException(String msg, Object insert, Throwable root) {
        super(msg);
        if (root != null) {
            this.previousCause = root;
            this.stackTraceString = BaseException.generateStackTraceString(root);
        } else {
            this.previousCause = new Exception("ERROR: A null value for rootCause was passed to the constructor of RBaseException");
            this.stackTraceString = BaseException.generateStackTraceString(this.previousCause);
        }
    }

    public Throwable getRootCause() {
        return this.previousCause;
    }

    public String getStackTraceString() {
        if (this.previousCause == null) {
            return null;
        }
        StringBuffer traceBuffer = new StringBuffer();
        if (this.previousCause instanceof BaseException) {
            traceBuffer.append(((BaseException)this.previousCause).getStackTraceString());
            traceBuffer.append("-------- nested by:\n");
        }
        traceBuffer.append(this.stackTraceString);
        return traceBuffer.toString();
    }

    public String getMessage() {
        String baseMsg = super.getMessage();
        if (this.getRootCause() == null) {
            return baseMsg;
        }
        StringBuffer theMsg = new StringBuffer();
        String previousMsg = this.getRootCause().getMessage();
        if (baseMsg != null) {
            theMsg.append(baseMsg).append(": ").append(previousMsg);
        } else {
            theMsg.append(previousMsg);
        }
        return theMsg.toString();
    }

    public String toString() {
        StringBuffer theMsg = new StringBuffer(super.toString());
        if (this.getRootCause() != null) {
            theMsg.append("; \n\t---> nested ").append(this.getRootCause());
        }
        return theMsg.toString();
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.previousCause != null) {
            this.previousCause.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream inPrintStream) {
        super.printStackTrace(inPrintStream);
        if (this.previousCause != null) {
            this.previousCause.printStackTrace(inPrintStream);
        }
    }

    public static String generateStackTraceString(Throwable t) {
        StringWriter s = new StringWriter();
        t.printStackTrace(new PrintWriter(s));
        return s.toString();
    }
}

