/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.parser;

import com.codestreet.selector.parser.IExpression;
import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.Result;
import java.util.Map;

abstract class ConditionalOpImpl {
    public static final ConditionalOpImpl AND = new ConditionalOpImpl(" AND "){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Result bLhs = (Result)lhs.eval(identifiers);
            if (bLhs == Result.RESULT_FALSE) {
                return Result.RESULT_FALSE;
            }
            if (bLhs == Result.RESULT_UNKNOWN) {
                return Result.RESULT_UNKNOWN;
            }
            return (Result)rhs.eval(identifiers);
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Result bLhs = (Result)lhs.eval(provider, corr);
            if (bLhs == Result.RESULT_FALSE) {
                return Result.RESULT_FALSE;
            }
            if (bLhs == Result.RESULT_UNKNOWN) {
                return Result.RESULT_UNKNOWN;
            }
            return (Result)rhs.eval(provider, corr);
        }
    };
    public static final ConditionalOpImpl OR = new ConditionalOpImpl(" OR "){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Result bLhs = (Result)lhs.eval(identifiers);
            if (bLhs == Result.RESULT_TRUE) {
                return Result.RESULT_TRUE;
            }
            Result bRhs = (Result)rhs.eval(identifiers);
            if (bRhs == Result.RESULT_TRUE) {
                return Result.RESULT_TRUE;
            }
            if (bLhs == Result.RESULT_UNKNOWN || bRhs == Result.RESULT_UNKNOWN) {
                return Result.RESULT_UNKNOWN;
            }
            return Result.RESULT_FALSE;
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Result bLhs = (Result)lhs.eval(provider, corr);
            if (bLhs == Result.RESULT_TRUE) {
                return Result.RESULT_TRUE;
            }
            Result bRhs = (Result)rhs.eval(provider, corr);
            if (bRhs == Result.RESULT_TRUE) {
                return Result.RESULT_TRUE;
            }
            if (bLhs == Result.RESULT_UNKNOWN || bRhs == Result.RESULT_UNKNOWN) {
                return Result.RESULT_UNKNOWN;
            }
            return Result.RESULT_FALSE;
        }
    };
    public static final ConditionalOpImpl NOT = new ConditionalOpImpl(" NOT "){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Result bRhs = (Result)rhs.eval(identifiers);
            if (bRhs == Result.RESULT_TRUE) {
                return Result.RESULT_FALSE;
            }
            if (bRhs == Result.RESULT_FALSE) {
                return Result.RESULT_TRUE;
            }
            return Result.RESULT_UNKNOWN;
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Result bRhs = (Result)rhs.eval(provider, corr);
            if (bRhs == Result.RESULT_TRUE) {
                return Result.RESULT_FALSE;
            }
            if (bRhs == Result.RESULT_FALSE) {
                return Result.RESULT_TRUE;
            }
            return Result.RESULT_UNKNOWN;
        }
    };
    private final String operator_;

    private ConditionalOpImpl(String operator) {
        this.operator_ = operator;
    }

    public String toString() {
        return this.operator_;
    }

    public abstract Object eval(Map var1, IExpression var2, IExpression var3);

    public abstract Object eval(IValueProvider var1, Object var2, IExpression var3, IExpression var4);
}

