/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedRef;
import EDU.oswego.cs.dl.util.concurrent.WaitableInt;
import EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.Fraction;
import EDU.oswego.cs.dl.util.concurrent.misc.PCTestLoop;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;
import EDU.oswego.cs.dl.util.concurrent.misc.TestLoop;
import EDU.oswego.cs.dl.util.concurrent.misc.Threads;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class SynchronizationTimer {
    static final int[] nthreadsChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    static final int BLOCK_MODE = 0;
    static final int TIMEOUT_MODE = 1;
    static final int[] syncModes;
    static final int PRECISION = 10;
    final ThreadInfo[] threadInfo = new ThreadInfo[nthreadsChoices.length];
    static final int headerRows = 1;
    static final int classColumn = 0;
    static final int headerColumns = 1;
    final int tableRows = TestedClass.classes.length + 1;
    final int tableColumns = nthreadsChoices.length + 1;
    final JComponent[][] resultTable_ = new JComponent[this.tableRows][this.tableColumns];
    final SynchronizedInt nextClassIdx_ = new SynchronizedInt(0);
    final SynchronizedInt nextThreadIdx_ = new SynchronizedInt(0);
    ClockDaemon timeDaemon = new ClockDaemon();
    private final SynchronizedRef contention_ = new SynchronizedRef(null);
    private final SynchronizedInt loopsPerTest_ = new SynchronizedInt(0);
    private final SynchronizedBoolean echoToSystemOut = new SynchronizedBoolean(false);
    private final JButton startstop_ = new JButton("Start");
    private WaitableInt testNumber_ = new WaitableInt(1);
    private SynchronizedBoolean running_ = new SynchronizedBoolean(false);

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        syncModes = nArray;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Times per call in microseconds");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(new SynchronizationTimer().mainPanel());
        frame.pack();
        ((Component)frame).setVisible(true);
    }

    static String modeToString(int m) {
        String sms = m == 0 ? "block" : (m == 1 ? "timeout" : "No such mode");
        return sms;
    }

    static String biasToString(int b) {
        String sms = b < 0 ? "slower producer" : (b == 0 ? "balanced prod/cons rate" : (b > 0 ? "slower consumer" : "No such bias"));
        return sms;
    }

    static String p2ToString(int n) {
        String suf = "";
        if (n >= 1024) {
            suf = "K";
            if ((n /= 1024) >= 1024) {
                n /= 1024;
                suf = "M";
            }
        }
        return String.valueOf(n) + suf;
    }

    static String formatTime(long ns, boolean showDecimal) {
        long intpart = ns / 10L;
        long decpart = ns % 10L;
        if (!showDecimal) {
            if (decpart >= 5L) {
                ++intpart;
            }
            return Long.toString(intpart);
        }
        String sint = Long.toString(intpart);
        String sdec = Long.toString(decpart);
        if (decpart == 0L) {
            int z = 10;
            while (z > 10) {
                sdec = "0" + sdec;
                z /= 10;
            }
        }
        String ts = String.valueOf(sint) + "." + sdec;
        return ts;
    }

    boolean threadEnabled(int nthreads) {
        return this.threadInfo[nthreads].getEnabled();
    }

    JPanel resultPanel() {
        JPanel[] colPanel = new JPanel[this.tableColumns];
        int col = 0;
        while (col < this.tableColumns) {
            colPanel[col] = new JPanel();
            colPanel[col].setLayout(new GridLayout(this.tableRows, 1));
            if (col != 0) {
                colPanel[col].setBackground(Color.white);
            }
            ++col;
        }
        Color hdrbg = colPanel[0].getBackground();
        LineBorder border = new LineBorder(hdrbg);
        Font font = new Font("Dialog", 0, 12);
        Dimension labDim = new Dimension(40, 16);
        Dimension cbDim = new Dimension(154, 16);
        JLabel cornerLab = new JLabel(" Classes      \\      Threads");
        cornerLab.setMinimumSize(cbDim);
        cornerLab.setPreferredSize(cbDim);
        cornerLab.setFont(font);
        this.resultTable_[0][0] = cornerLab;
        colPanel[0].add(cornerLab);
        int col2 = 1;
        while (col2 < this.tableColumns) {
            final int nthreads = col2 - 1;
            JCheckBox tcb = new JCheckBox(this.threadInfo[nthreads].name, true);
            tcb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SynchronizationTimer.this.threadInfo[nthreads].toggleEnabled();
                }
            });
            tcb.setMinimumSize(labDim);
            tcb.setPreferredSize(labDim);
            tcb.setFont(font);
            tcb.setBackground(hdrbg);
            this.resultTable_[0][col2] = tcb;
            colPanel[col2].add(tcb);
            ++col2;
        }
        int row = 1;
        while (row < this.tableRows) {
            final int cls = row - 1;
            JCheckBox cb = new JCheckBox(TestedClass.classes[cls].name, true);
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TestedClass.classes[cls].toggleEnabled();
                }
            });
            this.resultTable_[row][0] = cb;
            cb.setMinimumSize(cbDim);
            cb.setPreferredSize(cbDim);
            cb.setFont(font);
            colPanel[0].add(cb);
            int col3 = 1;
            while (col3 < this.tableColumns) {
                int nthreads = col3 - 1;
                JLabel lab = new JLabel("");
                this.resultTable_[row][col3] = lab;
                lab.setMinimumSize(labDim);
                lab.setPreferredSize(labDim);
                lab.setBorder(border);
                lab.setFont(font);
                lab.setBackground(Color.white);
                lab.setForeground(Color.black);
                lab.setHorizontalAlignment(4);
                colPanel[col3].add(lab);
                ++col3;
            }
            ++row;
        }
        JPanel tblPanel = new JPanel();
        tblPanel.setLayout(new BoxLayout(tblPanel, 0));
        int col4 = 0;
        while (col4 < this.tableColumns) {
            tblPanel.add(colPanel[col4]);
            ++col4;
        }
        return tblPanel;
    }

    void setTime(final long ns, int clsIdx, int nthrIdx) {
        int row = clsIdx + 1;
        int col = nthrIdx + 1;
        final JLabel cell = (JLabel)this.resultTable_[row][col];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                cell.setText(SynchronizationTimer.formatTime(ns, true));
            }
        });
    }

    void clearTable() {
        int i = 1;
        while (i < this.tableRows) {
            int j = 1;
            while (j < this.tableColumns) {
                ((JLabel)this.resultTable_[i][j]).setText("");
                ++j;
            }
            ++i;
        }
    }

    void setChecks(boolean setting) {
        int i = 0;
        while (i < TestedClass.classes.length) {
            TestedClass.classes[i].setEnabled(new Boolean(setting));
            ((JCheckBox)this.resultTable_[i + 1][0]).setSelected(setting);
            ++i;
        }
    }

    public SynchronizationTimer() {
        int i = 0;
        while (i < this.threadInfo.length) {
            this.threadInfo[i] = new ThreadInfo(nthreadsChoices[i]);
            ++i;
        }
    }

    JPanel mainPanel() {
        new PrintStart();
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout(new GridLayout(5, 3));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3));
        this.startstop_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (SynchronizationTimer.this.running_.get()) {
                    SynchronizationTimer.this.cancel();
                } else {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries());
                    }
                    catch (InterruptedException ex) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        paramPanel.add(this.startstop_);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(1, 2));
        JButton continueButton = new JButton("Continue");
        continueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!SynchronizationTimer.this.running_.get()) {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries(SynchronizationTimer.this.nextClassIdx_.get(), SynchronizationTimer.this.nextThreadIdx_.get()));
                    }
                    catch (InterruptedException ex) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        p1.add(continueButton);
        JButton clearButton = new JButton("Clear cells");
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SynchronizationTimer.this.clearTable();
            }
        });
        p1.add(clearButton);
        paramPanel.add(p1);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(1, 2));
        JButton setButton = new JButton("All classes");
        setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SynchronizationTimer.this.setChecks(true);
            }
        });
        p3.add(setButton);
        JButton unsetButton = new JButton("No classes");
        unsetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SynchronizationTimer.this.setChecks(false);
            }
        });
        p3.add(unsetButton);
        paramPanel.add(p3);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        JCheckBox consoleBox = new JCheckBox("Console echo");
        consoleBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SynchronizationTimer.this.echoToSystemOut.complement();
            }
        });
        JLabel poolinfo = new JLabel("Active threads:      0");
        p2.add(poolinfo);
        p2.add(consoleBox);
        paramPanel.add(p2);
        paramPanel.add(this.contentionBox());
        paramPanel.add(this.itersBox());
        paramPanel.add(this.cloopBox());
        paramPanel.add(this.barrierBox());
        paramPanel.add(this.exchangeBox());
        paramPanel.add(this.biasBox());
        paramPanel.add(this.capacityBox());
        paramPanel.add(this.timeoutBox());
        paramPanel.add(this.syncModePanel());
        paramPanel.add(this.producerSyncModePanel());
        paramPanel.add(this.consumerSyncModePanel());
        this.startPoolStatus(poolinfo);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel tblPanel = this.resultPanel();
        mainPanel.add(tblPanel);
        mainPanel.add(paramPanel);
        return mainPanel;
    }

    JComboBox syncModePanel() {
        JComboBox<String> syncModeComboBox = new JComboBox<String>();
        int j = 0;
        while (j < syncModes.length) {
            String lab = "Locks: " + SynchronizationTimer.modeToString(syncModes[j]);
            syncModeComboBox.addItem(lab);
            ++j;
        }
        syncModeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.syncMode.set(syncModes[idx]);
            }
        });
        RNG.syncMode.set(syncModes[0]);
        syncModeComboBox.setSelectedIndex(0);
        return syncModeComboBox;
    }

    JComboBox producerSyncModePanel() {
        JComboBox<String> producerSyncModeComboBox = new JComboBox<String>();
        int j = 0;
        while (j < syncModes.length) {
            String lab = "Producers: " + SynchronizationTimer.modeToString(syncModes[j]);
            producerSyncModeComboBox.addItem(lab);
            ++j;
        }
        producerSyncModeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.producerMode.set(syncModes[idx]);
            }
        });
        RNG.producerMode.set(syncModes[0]);
        producerSyncModeComboBox.setSelectedIndex(0);
        return producerSyncModeComboBox;
    }

    JComboBox consumerSyncModePanel() {
        JComboBox<String> consumerSyncModeComboBox = new JComboBox<String>();
        int j = 0;
        while (j < syncModes.length) {
            String lab = "Consumers: " + SynchronizationTimer.modeToString(syncModes[j]);
            consumerSyncModeComboBox.addItem(lab);
            ++j;
        }
        consumerSyncModeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.consumerMode.set(syncModes[idx]);
            }
        });
        RNG.consumerMode.set(syncModes[0]);
        consumerSyncModeComboBox.setSelectedIndex(0);
        return consumerSyncModeComboBox;
    }

    JComboBox contentionBox() {
        final Fraction[] contentionChoices = new Fraction[]{new Fraction(0L, 1L), new Fraction(1L, 16L), new Fraction(1L, 8L), new Fraction(1L, 4L), new Fraction(1L, 2L), new Fraction(1L, 1L)};
        JComboBox<String> contentionComboBox = new JComboBox<String>();
        int j = 0;
        while (j < contentionChoices.length) {
            String lab = String.valueOf(contentionChoices[j].asDouble() * 100.0) + "% contention/sharing";
            contentionComboBox.addItem(lab);
            ++j;
        }
        contentionComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                SynchronizationTimer.this.contention_.set(contentionChoices[idx]);
            }
        });
        this.contention_.set(contentionChoices[3]);
        contentionComboBox.setSelectedIndex(3);
        return contentionComboBox;
    }

    JComboBox itersBox() {
        final int[] loopsPerTestChoices = new int[]{1, 16, 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> precComboBox = new JComboBox<String>();
        int j = 0;
        while (j < loopsPerTestChoices.length) {
            String lab = String.valueOf(SynchronizationTimer.p2ToString(loopsPerTestChoices[j])) + " calls per thread per test";
            precComboBox.addItem(lab);
            ++j;
        }
        precComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                SynchronizationTimer.this.loopsPerTest_.set(loopsPerTestChoices[idx]);
            }
        });
        this.loopsPerTest_.set(loopsPerTestChoices[8]);
        precComboBox.setSelectedIndex(8);
        return precComboBox;
    }

    JComboBox cloopBox() {
        final int[] computationsPerCallChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536};
        JComboBox<String> cloopComboBox = new JComboBox<String>();
        int j = 0;
        while (j < computationsPerCallChoices.length) {
            String lab = String.valueOf(SynchronizationTimer.p2ToString(computationsPerCallChoices[j])) + " computations per call";
            cloopComboBox.addItem(lab);
            ++j;
        }
        cloopComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.computeLoops.set(computationsPerCallChoices[idx]);
            }
        });
        RNG.computeLoops.set(computationsPerCallChoices[3]);
        cloopComboBox.setSelectedIndex(3);
        return cloopComboBox;
    }

    JComboBox barrierBox() {
        final int[] itersPerBarrierChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> barrierComboBox = new JComboBox<String>();
        int j = 0;
        while (j < itersPerBarrierChoices.length) {
            String lab = String.valueOf(SynchronizationTimer.p2ToString(itersPerBarrierChoices[j])) + " iterations per barrier";
            barrierComboBox.addItem(lab);
            ++j;
        }
        barrierComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.itersPerBarrier.set(itersPerBarrierChoices[idx]);
            }
        });
        RNG.itersPerBarrier.set(itersPerBarrierChoices[13]);
        barrierComboBox.setSelectedIndex(13);
        return barrierComboBox;
    }

    JComboBox exchangeBox() {
        final int[] exchangerChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
        JComboBox<String> exchComboBox = new JComboBox<String>();
        int j = 0;
        while (j < exchangerChoices.length) {
            String lab = String.valueOf(SynchronizationTimer.p2ToString(exchangerChoices[j])) + " max threads per barrier";
            exchComboBox.addItem(lab);
            ++j;
        }
        exchComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.exchangeParties.set(exchangerChoices[idx]);
            }
        });
        RNG.exchangeParties.set(exchangerChoices[1]);
        exchComboBox.setSelectedIndex(1);
        return exchComboBox;
    }

    JComboBox biasBox() {
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = 1;
        final int[] biasChoices = nArray;
        JComboBox<String> biasComboBox = new JComboBox<String>();
        int j = 0;
        while (j < biasChoices.length) {
            String lab = SynchronizationTimer.biasToString(biasChoices[j]);
            biasComboBox.addItem(lab);
            ++j;
        }
        biasComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.bias.set(biasChoices[idx]);
            }
        });
        RNG.bias.set(biasChoices[1]);
        biasComboBox.setSelectedIndex(1);
        return biasComboBox;
    }

    JComboBox capacityBox() {
        final int[] bufferCapacityChoices = new int[]{1, 4, 64, 256, 1024, 4096, 16384, 65536, 262144, 0x100000};
        JComboBox<String> bcapComboBox = new JComboBox<String>();
        int j = 0;
        while (j < bufferCapacityChoices.length) {
            String lab = String.valueOf(SynchronizationTimer.p2ToString(bufferCapacityChoices[j])) + " element bounded buffers";
            bcapComboBox.addItem(lab);
            ++j;
        }
        bcapComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                DefaultChannelCapacity.set(bufferCapacityChoices[idx]);
            }
        });
        DefaultChannelCapacity.set(bufferCapacityChoices[3]);
        bcapComboBox.setSelectedIndex(3);
        return bcapComboBox;
    }

    JComboBox timeoutBox() {
        long[] lArray = new long[7];
        lArray[1] = 1L;
        lArray[2] = 10L;
        lArray[3] = 100L;
        lArray[4] = 1000L;
        lArray[5] = 10000L;
        lArray[6] = 100000L;
        final long[] timeoutChoices = lArray;
        JComboBox<String> timeoutComboBox = new JComboBox<String>();
        int j = 0;
        while (j < timeoutChoices.length) {
            String lab = String.valueOf(timeoutChoices[j]) + " msec timeouts";
            timeoutComboBox.addItem(lab);
            ++j;
        }
        timeoutComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.timeout.set(timeoutChoices[idx]);
            }
        });
        RNG.timeout.set(timeoutChoices[3]);
        timeoutComboBox.setSelectedIndex(3);
        return timeoutComboBox;
    }

    void startPoolStatus(final JLabel status) {
        Runnable updater = new Runnable(){
            int lastps = 0;

            public void run() {
                int ps = Threads.activeThreads.get();
                if (this.lastps != ps) {
                    this.lastps = ps;
                    SwingUtilities.invokeLater(new Runnable(status, ps){
                        private final /* synthetic */ JLabel val$status;
                        private final /* synthetic */ int val$ps;
                        {
                            this.val$status = jLabel;
                            this.val$ps = n;
                        }

                        public void run() {
                            this.val$status.setText("Active threads: " + this.val$ps);
                        }
                    });
                }
            }
        };
        this.timeDaemon.executePeriodically(250L, updater, false);
    }

    private void runOneTest(Runnable tst) throws InterruptedException {
        int nt = this.testNumber_.get();
        Threads.pool.execute(tst);
        this.testNumber_.whenNotEqual(nt, null);
    }

    private void endOneTest() {
        this.testNumber_.increment();
    }

    void cancel() {
        Object object = RNG.constructionLock;
        synchronized (object) {
            try {
                Threads.pool.interruptAll();
            }
            catch (Exception ex) {
                System.out.println("\nException during cancel:\n" + ex);
                return;
            }
        }
    }

    void startTestSeries(Runnable tst) throws InterruptedException {
        this.running_.set(true);
        this.startstop_.setText("Stop");
        Threads.pool.execute(tst);
    }

    void endTestSeries() {
        this.running_.set(false);
        SwingUtilities.invokeLater(new PrintStart());
    }

    static class TestedClass {
        final String name;
        final Class cls;
        final boolean multipleOK;
        final boolean singleOK;
        final Class buffCls;
        Boolean enabled_ = new Boolean(true);
        static final TestedClass dummy;
        static final TestedClass[] classes;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;
        static /* synthetic */ Class class$6;
        static /* synthetic */ Class class$7;
        static /* synthetic */ Class class$8;
        static /* synthetic */ Class class$9;
        static /* synthetic */ Class class$10;
        static /* synthetic */ Class class$11;
        static /* synthetic */ Class class$12;
        static /* synthetic */ Class class$13;
        static /* synthetic */ Class class$14;
        static /* synthetic */ Class class$15;
        static /* synthetic */ Class class$16;
        static /* synthetic */ Class class$17;
        static /* synthetic */ Class class$18;
        static /* synthetic */ Class class$19;
        static /* synthetic */ Class class$20;
        static /* synthetic */ Class class$21;
        static /* synthetic */ Class class$22;
        static /* synthetic */ Class class$23;
        static /* synthetic */ Class class$24;
        static /* synthetic */ Class class$25;
        static /* synthetic */ Class class$26;
        static /* synthetic */ Class class$27;
        static /* synthetic */ Class class$28;
        static /* synthetic */ Class class$29;

        static {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            Class<?> clazz5;
            Class<?> clazz6;
            Class<?> clazz7;
            Class<?> clazz8;
            dummy = new TestedClass("", null, false, false);
            TestedClass[] testedClassArray = new TestedClass[29];
            Class<?> clazz9 = class$0;
            if (clazz9 == null) {
                try {
                    clazz9 = class$0 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.NoSynchRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[0] = new TestedClass("NoSynchronization", clazz9, false, true);
            Class<?> clazz10 = class$1;
            if (clazz10 == null) {
                try {
                    clazz10 = class$1 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.PublicSynchRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[1] = new TestedClass("PublicSynchronization", clazz10, true, true);
            Class<?> clazz11 = class$2;
            if (clazz11 == null) {
                try {
                    clazz11 = class$2 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.AllSynchRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[2] = new TestedClass("NestedSynchronization", clazz11, true, true);
            Class<?> clazz12 = class$3;
            if (clazz12 == null) {
                try {
                    clazz12 = class$3 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.SDelegatedRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[3] = new TestedClass("SDelegated", clazz12, true, true);
            Class<?> clazz13 = class$4;
            if (clazz13 == null) {
                try {
                    clazz13 = class$4 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.SynchLongRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[4] = new TestedClass("SynchLongUsingSet", clazz13, true, true);
            Class<?> clazz14 = class$5;
            if (clazz14 == null) {
                try {
                    clazz14 = class$5 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.AClongRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[5] = new TestedClass("SynchLongUsingCommit", clazz14, true, true);
            Class<?> clazz15 = class$6;
            if (clazz15 == null) {
                try {
                    clazz15 = class$6 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.SemRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[6] = new TestedClass("Semaphore", clazz15, true, true);
            Class<?> clazz16 = class$7;
            if (clazz16 == null) {
                try {
                    clazz16 = class$7 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.WpSemRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[7] = new TestedClass("WaiterPrefSemaphore", clazz16, true, true);
            Class<?> clazz17 = class$8;
            if (clazz17 == null) {
                try {
                    clazz17 = class$8 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.FifoRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[8] = new TestedClass("FIFOSemaphore", clazz17, true, true);
            Class<?> clazz18 = class$9;
            if (clazz18 == null) {
                try {
                    clazz18 = class$9 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.PrioritySemRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[9] = new TestedClass("PrioritySemaphore", clazz18, true, true);
            Class<?> clazz19 = class$10;
            if (clazz19 == null) {
                try {
                    clazz19 = class$10 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.MutexRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[10] = new TestedClass("Mutex", clazz19, true, true);
            Class<?> clazz20 = class$11;
            if (clazz20 == null) {
                try {
                    clazz20 = class$11 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.RlockRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[11] = new TestedClass("ReentrantLock", clazz20, true, true);
            Class<?> clazz21 = class$12;
            if (clazz21 == null) {
                try {
                    clazz21 = class$12 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.WpRWlockRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[12] = new TestedClass("WriterPrefRWLock", clazz21, true, true);
            Class<?> clazz22 = class$13;
            if (clazz22 == null) {
                try {
                    clazz22 = class$13 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ReaderPrefRWlockRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[13] = new TestedClass("ReaderPrefRWLock", clazz22, true, true);
            Class<?> clazz23 = class$14;
            if (clazz23 == null) {
                try {
                    clazz23 = class$14 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.FIFORWlockRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[14] = new TestedClass("FIFORWLock", clazz23, true, true);
            Class<?> clazz24 = class$15;
            if (clazz24 == null) {
                try {
                    clazz24 = class$15 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ReentrantRWlockRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[15] = new TestedClass("ReentrantRWL", clazz24, true, true);
            Class<?> clazz25 = class$16;
            if (clazz25 == null) {
                try {
                    clazz25 = class$16 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz8 = class$17) == null) {
                try {
                    clazz8 = class$17 = Class.forName("EDU.oswego.cs.dl.util.concurrent.LinkedQueue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[16] = new TestedClass("LinkedQueue", clazz25, true, true, clazz8);
            Class<?> clazz26 = class$16;
            if (clazz26 == null) {
                try {
                    clazz26 = class$16 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz7 = class$18) == null) {
                try {
                    clazz7 = class$18 = Class.forName("EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[17] = new TestedClass("WaitFreeQueue", clazz26, true, true, clazz7);
            Class<?> clazz27 = class$16;
            if (clazz27 == null) {
                try {
                    clazz27 = class$16 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz6 = class$19) == null) {
                try {
                    clazz6 = class$19 = Class.forName("EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[18] = new TestedClass("BoundedLinkedQueue", clazz27, true, true, clazz6);
            Class<?> clazz28 = class$16;
            if (clazz28 == null) {
                try {
                    clazz28 = class$16 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz5 = class$20) == null) {
                try {
                    clazz5 = class$20 = Class.forName("EDU.oswego.cs.dl.util.concurrent.BoundedBuffer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[19] = new TestedClass("BoundedBuffer", clazz28, true, true, clazz5);
            Class<?> clazz29 = class$16;
            if (clazz29 == null) {
                try {
                    clazz29 = class$16 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz4 = class$21) == null) {
                try {
                    clazz4 = class$21 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.CVBuffer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[20] = new TestedClass("CondVarBoundedBuffer", clazz29, true, true, clazz4);
            Class<?> clazz30 = class$16;
            if (clazz30 == null) {
                try {
                    clazz30 = class$16 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz3 = class$22) == null) {
                try {
                    clazz3 = class$22 = Class.forName("EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[21] = new TestedClass("BoundedPriorityQueue", clazz30, true, true, clazz3);
            Class<?> clazz31 = class$16;
            if (clazz31 == null) {
                try {
                    clazz31 = class$16 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz2 = class$23) == null) {
                try {
                    clazz2 = class$23 = Class.forName("EDU.oswego.cs.dl.util.concurrent.Slot");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[22] = new TestedClass("Slot", clazz31, true, true, clazz2);
            Class<?> clazz32 = class$16;
            if (clazz32 == null) {
                try {
                    clazz32 = class$16 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz = class$24) == null) {
                try {
                    clazz = class$24 = Class.forName("EDU.oswego.cs.dl.util.concurrent.SynchronousChannel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[23] = new TestedClass("SynchronousChannel", clazz32, true, false, clazz);
            Class<?> clazz33 = class$25;
            if (clazz33 == null) {
                try {
                    clazz33 = class$25 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.DirectExecutorRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[24] = new TestedClass("DirectExecutor", clazz33, true, true);
            Class<?> clazz34 = class$26;
            if (clazz34 == null) {
                try {
                    clazz34 = class$26 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.LockedSemRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[25] = new TestedClass("SemaphoreLckExecutor", clazz34, true, true);
            Class<?> clazz35 = class$27;
            if (clazz35 == null) {
                try {
                    clazz35 = class$27 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.QueuedExecutorRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[26] = new TestedClass("QueuedExecutor", clazz35, true, true);
            Class<?> clazz36 = class$28;
            if (clazz36 == null) {
                try {
                    clazz36 = class$28 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.ThreadedExecutorRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[27] = new TestedClass("ThreadedExecutor", clazz36, true, true);
            Class<?> clazz37 = class$29;
            if (clazz37 == null) {
                try {
                    clazz37 = class$29 = Class.forName("EDU.oswego.cs.dl.util.concurrent.misc.PooledExecutorRNG");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            testedClassArray[28] = new TestedClass("PooledExecutor", clazz37, true, true);
            classes = testedClassArray;
        }

        synchronized void setEnabled(Boolean b) {
            this.enabled_ = b;
        }

        synchronized Boolean getEnabled() {
            return this.enabled_;
        }

        synchronized void toggleEnabled() {
            boolean enabled = this.enabled_;
            this.enabled_ = new Boolean(!enabled);
        }

        synchronized boolean isEnabled(int nthreads, Fraction shared) {
            boolean enabled = this.enabled_;
            if (!enabled) {
                return false;
            }
            if (!this.singleOK && nthreads <= 1) {
                return false;
            }
            return this.multipleOK || nthreads <= 1 || shared.compareTo(0L) <= 0;
        }

        TestedClass(String n, Class c, boolean m, boolean sok) {
            this.name = n;
            this.cls = c;
            this.multipleOK = m;
            this.singleOK = sok;
            this.buffCls = null;
        }

        TestedClass(String n, Class c, boolean m, boolean sok, Class bc) {
            this.name = n;
            this.cls = c;
            this.multipleOK = m;
            this.singleOK = sok;
            this.buffCls = bc;
        }
    }

    static class ThreadInfo {
        final String name;
        final int number;
        Boolean enabled;

        ThreadInfo(int nthr) {
            this.number = nthr;
            this.name = SynchronizationTimer.p2ToString(nthr);
            this.enabled = new Boolean(true);
        }

        synchronized Boolean getEnabled() {
            return this.enabled;
        }

        synchronized void setEnabled(Boolean v) {
            this.enabled = v;
        }

        synchronized void toggleEnabled() {
            this.enabled = new Boolean(this.enabled == false);
        }
    }

    class PrintStart
    implements Runnable {
        PrintStart() {
        }

        public void run() {
            SynchronizationTimer.this.startstop_.setText("Start");
        }
    }

    class TestSeries
    implements Runnable {
        final int firstclass;
        final int firstnthreads;

        TestSeries() {
            this.firstclass = 0;
            this.firstnthreads = 0;
        }

        TestSeries(int firstc, int firstnt) {
            this.firstclass = firstc;
            this.firstnthreads = firstnt;
        }

        public void run() {
            block9: {
                Thread.currentThread().setPriority(5);
                try {
                    try {
                        int t = this.firstnthreads;
                        int c = this.firstclass;
                        if (t >= nthreadsChoices.length || c >= TestedClass.classes.length) break block9;
                        while (true) {
                            if (SynchronizationTimer.this.threadEnabled(t)) {
                                TestedClass entry = TestedClass.classes[c];
                                int nthreads = nthreadsChoices[t];
                                int iters = SynchronizationTimer.this.loopsPerTest_.get();
                                Fraction pshr = (Fraction)SynchronizationTimer.this.contention_.get();
                                if (entry.isEnabled(nthreads, pshr)) {
                                    SynchronizationTimer.this.runOneTest(new OneTest(c, t));
                                }
                            }
                            if (++c >= TestedClass.classes.length) {
                                c = 0;
                                if (++t >= nthreadsChoices.length) break;
                            }
                            SynchronizationTimer.this.nextClassIdx_.set(c);
                            SynchronizationTimer.this.nextThreadIdx_.set(t);
                        }
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    SynchronizationTimer.this.endTestSeries();
                    throw throwable;
                }
            }
            Object var7_10 = null;
            SynchronizationTimer.this.endTestSeries();
        }
    }

    static class BarrierTimer
    implements Runnable {
        private long startTime_ = 0L;
        private long endTime_ = 0L;

        BarrierTimer() {
        }

        public synchronized long getTime() {
            return this.endTime_ - this.startTime_;
        }

        public synchronized void run() {
            long now = System.currentTimeMillis();
            if (this.startTime_ == 0L) {
                this.startTime_ = now;
            } else {
                this.endTime_ = now;
            }
        }
    }

    class OneTest
    implements Runnable {
        final int clsIdx;
        final int nthreadsIdx;

        OneTest(int idx, int t) {
            this.clsIdx = idx;
            this.nthreadsIdx = t;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Color oldfg;
            JLabel cell;
            boolean wasInterrupted;
            block26: {
                block25: {
                    block24: {
                        boolean clear2;
                        block23: {
                            Thread.currentThread().setPriority(2);
                            wasInterrupted = false;
                            TestedClass entry = TestedClass.classes[this.clsIdx];
                            cell = (JLabel)SynchronizationTimer.this.resultTable_[this.clsIdx + 1][this.nthreadsIdx + 1];
                            oldfg = cell.getForeground();
                            try {
                                try {
                                    if (Thread.interrupted()) {
                                        Object var22_5 = null;
                                        clear2 = wasInterrupted;
                                        break block23;
                                    }
                                    if (!SynchronizationTimer.this.threadEnabled(this.nthreadsIdx)) {
                                        break block24;
                                    }
                                    int nthreads = nthreadsChoices[this.nthreadsIdx];
                                    int iters = SynchronizationTimer.this.loopsPerTest_.get();
                                    Fraction pshr = (Fraction)SynchronizationTimer.this.contention_.get();
                                    if (!entry.isEnabled(nthreads, pshr)) {
                                        break block25;
                                    }
                                    BarrierTimer timer = new BarrierTimer();
                                    CyclicBarrier barrier = new CyclicBarrier(nthreads + 1, timer);
                                    Class cls = entry.cls;
                                    Class chanCls = entry.buffCls;
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(cell){
                                            private final /* synthetic */ JLabel val$cell;
                                            {
                                                this.val$cell = jLabel;
                                            }

                                            public void run() {
                                                this.val$cell.setForeground(Color.blue);
                                                this.val$cell.setText("RUN");
                                                this.val$cell.repaint();
                                            }
                                        });
                                    }
                                    catch (InvocationTargetException ex) {
                                        ex.printStackTrace();
                                        System.exit(-1);
                                    }
                                    Object ex = RNG.constructionLock;
                                    synchronized (ex) {
                                        RNG.reset(nthreads);
                                        if (chanCls == null) {
                                            RNG shared = (RNG)cls.newInstance();
                                            int k = 0;
                                            while (k < nthreads) {
                                                RNG pri = (RNG)cls.newInstance();
                                                TestLoop l = new TestLoop(shared, pri, pshr, iters, barrier);
                                                Threads.pool.execute(l.testLoop());
                                                ++k;
                                            }
                                        } else {
                                            Channel shared = (Channel)chanCls.newInstance();
                                            if (nthreads == 1) {
                                                ChanRNG single = (ChanRNG)cls.newInstance();
                                                single.setSingle(true);
                                                PCTestLoop l = new PCTestLoop(single.getDelegate(), single, pshr, iters, barrier, shared, shared);
                                                Threads.pool.execute(l.testLoop(true));
                                            } else {
                                                if (nthreads % 2 != 0) {
                                                    throw new Error("Must have even number of threads!");
                                                }
                                                int npairs = nthreads / 2;
                                                int k = 0;
                                                while (k < npairs) {
                                                    ChanRNG t = (ChanRNG)cls.newInstance();
                                                    t.setSingle(false);
                                                    Channel chan = (Channel)chanCls.newInstance();
                                                    PCTestLoop l = new PCTestLoop(t.getDelegate(), t, pshr, iters, barrier, shared, chan);
                                                    Threads.pool.execute(l.testLoop(false));
                                                    Threads.pool.execute(l.testLoop(true));
                                                    ++k;
                                                }
                                            }
                                        }
                                        if (SynchronizationTimer.this.echoToSystemOut.get()) {
                                            System.out.print(String.valueOf(entry.name) + " " + nthreads + "T " + pshr + "S " + RNG.computeLoops.get() + "I " + RNG.syncMode.get() + "Lm " + RNG.timeout.get() + "TO " + RNG.producerMode.get() + "Pm " + RNG.consumerMode.get() + "Cm " + RNG.bias.get() + "B " + DefaultChannelCapacity.get() + "C " + RNG.exchangeParties.get() + "Xp " + RNG.itersPerBarrier.get() + "Ib : ");
                                        }
                                    }
                                    barrier.barrier();
                                    barrier.barrier();
                                    long tm = timer.getTime();
                                    long totalIters = nthreads * iters;
                                    double dns = (double)tm * 1000.0 * 10.0 / (double)totalIters;
                                    long ns = Math.round(dns);
                                    SynchronizationTimer.this.setTime(ns, this.clsIdx, this.nthreadsIdx);
                                    if (SynchronizationTimer.this.echoToSystemOut.get()) {
                                        System.out.println(SynchronizationTimer.formatTime(ns, true));
                                    }
                                    break block26;
                                }
                                catch (BrokenBarrierException ex) {
                                    wasInterrupted = true;
                                }
                                catch (InterruptedException ex) {
                                    wasInterrupted = true;
                                    Thread.currentThread().interrupt();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    System.out.println("Construction Exception?");
                                    System.exit(-1);
                                }
                                break block26;
                            }
                            catch (Throwable throwable) {
                                Object var22_8 = null;
                                boolean clear2 = wasInterrupted;
                                SwingUtilities.invokeLater(new Runnable(clear2, cell, oldfg){
                                    private final /* synthetic */ boolean val$clear;
                                    private final /* synthetic */ JLabel val$cell;
                                    private final /* synthetic */ Color val$oldfg;
                                    {
                                        this.val$clear = bl;
                                        this.val$cell = jLabel;
                                        this.val$oldfg = color;
                                    }

                                    public void run() {
                                        if (this.val$clear) {
                                            this.val$cell.setText("");
                                        }
                                        this.val$cell.setForeground(this.val$oldfg);
                                        this.val$cell.repaint();
                                    }
                                });
                                Thread.currentThread().setPriority(5);
                                SynchronizationTimer.this.endOneTest();
                                throw throwable;
                            }
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        Thread.currentThread().setPriority(5);
                        SynchronizationTimer.this.endOneTest();
                        return;
                    }
                    Object var22_6 = null;
                    boolean clear2 = wasInterrupted;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    Thread.currentThread().setPriority(5);
                    SynchronizationTimer.this.endOneTest();
                    return;
                }
                Object var22_7 = null;
                boolean clear2 = wasInterrupted;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                Thread.currentThread().setPriority(5);
                SynchronizationTimer.this.endOneTest();
                return;
            }
            Object var22_9 = null;
            boolean clear2 = wasInterrupted;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            Thread.currentThread().setPriority(5);
            SynchronizationTimer.this.endOneTest();
        }
    }
}

