/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.taskDemo;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

public class BufferTasks
extends FJTask {
    static int niters = 65536;
    static int[] pairs = new int[]{1, 2, 4, 8, 16, 32, 64};
    static int[] sizes = new int[]{1024, 64, 1};
    int callbackCount;
    Buffer buffer;

    public static void main(String[] args) {
        try {
            int procs;
            try {
                procs = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                System.out.println("Usage: java BufferTasks <threads>");
                return;
            }
            System.out.print("pairs:");
            int p = 0;
            while (p < pairs.length) {
                System.out.print("\t" + pairs[p]);
                ++p;
            }
            System.out.print("\n");
            FJTaskRunnerGroup g = new FJTaskRunnerGroup(procs);
            g.invoke(new BufferTasks());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        int s = 0;
        while (s < sizes.length) {
            System.out.println("cap: " + sizes[s]);
            int p = 0;
            while (p < pairs.length) {
                this.buffer = new Buffer(sizes[s]);
                int npairs = pairs[p];
                int iters = niters / npairs;
                long startTime = System.currentTimeMillis();
                this.setCallbackCount(npairs * 2);
                int k = 0;
                while (k < npairs) {
                    new Producer(iters).fork();
                    new Consumer(iters).fork();
                    ++k;
                }
                while (!this.checkDone()) {
                    FJTask.yield();
                }
                long now = System.currentTimeMillis();
                long time = now - startTime;
                long tpi = time * 1000L / (long)(npairs * niters);
                System.out.print("\t" + tpi);
                ++p;
            }
            System.out.print("\n");
            FJTask.getFJTaskRunnerGroup().stats();
            ++s;
        }
    }

    synchronized void notifyDone() {
        --this.callbackCount;
    }

    synchronized void setCallbackCount(int c) {
        this.callbackCount = c;
    }

    synchronized boolean checkDone() {
        return this.callbackCount == 0;
    }

    class Producer
    extends FJTask {
        final int iters;

        Producer(int n) {
            this.iters = n;
        }

        public void run() {
            int n = this.iters;
            while (n > 0) {
                if (!BufferTasks.this.buffer.offer(new Integer(n))) {
                    FJTask.yield();
                    new Producer(n).start();
                    return;
                }
                --n;
            }
            BufferTasks.this.notifyDone();
        }
    }

    class Consumer
    extends FJTask {
        final int iters;

        Consumer(int n) {
            this.iters = n;
        }

        public void run() {
            int n = this.iters;
            while (n > 0) {
                if (BufferTasks.this.buffer.poll() == null) {
                    FJTask.yield();
                    new Consumer(n).start();
                    return;
                }
                --n;
            }
            BufferTasks.this.notifyDone();
        }
    }

    static class Buffer {
        protected Object[] array_;
        protected int putPtr_ = 0;
        protected int takePtr_ = 0;
        final NonBlockingSemaphore putPermits;
        final NonBlockingSemaphore takePermits;

        public Buffer(int capacity) {
            this.putPermits = new NonBlockingSemaphore(capacity);
            this.takePermits = new NonBlockingSemaphore(0L);
            this.array_ = new Object[capacity];
        }

        public boolean offer(Object x) {
            if (!this.putPermits.attempt()) {
                return false;
            }
            Buffer buffer = this;
            synchronized (buffer) {
                this.array_[this.putPtr_] = x;
                if (++this.putPtr_ == this.array_.length) {
                    this.putPtr_ = 0;
                }
            }
            this.takePermits.release();
            return true;
        }

        public Object poll() {
            Object x;
            if (!this.takePermits.attempt()) {
                return null;
            }
            Buffer buffer = this;
            synchronized (buffer) {
                x = this.array_[this.takePtr_];
                this.array_[this.takePtr_] = null;
                if (++this.takePtr_ == this.array_.length) {
                    this.takePtr_ = 0;
                }
            }
            this.putPermits.release();
            return x;
        }
    }

    static class NonBlockingSemaphore {
        private long permits_;

        public NonBlockingSemaphore(long initialPermits) {
            this.permits_ = initialPermits;
        }

        public synchronized boolean attempt() {
            if (this.permits_ > 0L) {
                --this.permits_;
                return true;
            }
            return false;
        }

        public synchronized void release() {
            ++this.permits_;
        }
    }
}

