/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.taskDemo;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;
import java.util.Random;

public class LU {
    static final int BLOCK_SIZE = 16;
    static final boolean CHECK = false;

    public static void main(String[] args) {
        String usage = "Usage: java LU <threads> <matrix size (must be a power of two)> [runs] \n For example, try java LU 2 512";
        try {
            int n;
            int procs;
            int runs = 1;
            try {
                procs = Integer.parseInt(args[0]);
                n = Integer.parseInt(args[1]);
                if (args.length > 2) {
                    runs = Integer.parseInt(args[2]);
                }
            }
            catch (Exception e) {
                System.out.println("Usage: java LU <threads> <matrix size (must be a power of two)> [runs] \n For example, try java LU 2 512");
                return;
            }
            if ((n & n - 1) != 0) {
                System.out.println("Usage: java LU <threads> <matrix size (must be a power of two)> [runs] \n For example, try java LU 2 512");
                return;
            }
            int run = 0;
            while (run < runs) {
                double[][] m = new double[n][n];
                LU.randomInit(m, n);
                Object copy = null;
                Block M = new Block(m, 0, 0);
                FJTaskRunnerGroup g = new FJTaskRunnerGroup(procs);
                g.invoke(new LowerUpper(n, M));
                g.stats();
                g.interruptAll();
                ++run;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void randomInit(double[][] M, int n) {
        Random rng = new Random();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                M[i][j] = rng.nextDouble();
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < n) {
            double[] dArray = M[k];
            int n2 = k++;
            dArray[n2] = dArray[n2] * 10.0;
        }
    }

    static void check(double[][] LU2, double[][] M, int n) {
        double maxDiff = 0.0;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                double diff;
                double v = 0.0;
                int k = 0;
                while (k < i && k <= j) {
                    v += LU2[i][k] * LU2[k][j];
                    ++k;
                }
                if (k == i && k <= j) {
                    v += LU2[k][j];
                }
                if ((diff = M[i][j] - v) < 0.0) {
                    diff = -diff;
                }
                if (diff > 0.001) {
                    System.out.println("large diff at[" + i + "," + j + "]: " + M[i][j] + " vs " + v);
                }
                if (diff > maxDiff) {
                    maxDiff = diff;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Max difference = " + maxDiff);
    }

    static class Block {
        final double[][] m;
        final int loRow;
        final int loCol;

        Block(double[][] mat, int lr, int lc) {
            this.m = mat;
            this.loRow = lr;
            this.loCol = lc;
        }
    }

    static class Schur
    extends FJTask {
        final int size;
        final Block V;
        final Block W;
        final Block M;

        Schur(int size, Block V, Block W, Block M) {
            this.size = size;
            this.V = V;
            this.W = W;
            this.M = M;
        }

        void schur() {
            int j = 0;
            while (j < 16) {
                int i = 0;
                while (i < 16) {
                    double s = this.M.m[i + this.M.loRow][j + this.M.loCol];
                    int k = 0;
                    while (k < 16) {
                        s -= this.V.m[i + this.V.loRow][k + this.V.loCol] * this.W.m[k + this.W.loRow][j + this.W.loCol];
                        ++k;
                    }
                    this.M.m[i + this.M.loRow][j + this.M.loCol] = s;
                    ++i;
                }
                ++j;
            }
        }

        public void run() {
            if (this.size == 16) {
                this.schur();
            } else {
                int h = this.size / 2;
                Block M00 = new Block(this.M.m, this.M.loRow, this.M.loCol);
                Block M01 = new Block(this.M.m, this.M.loRow, this.M.loCol + h);
                Block M10 = new Block(this.M.m, this.M.loRow + h, this.M.loCol);
                Block M11 = new Block(this.M.m, this.M.loRow + h, this.M.loCol + h);
                Block V00 = new Block(this.V.m, this.V.loRow, this.V.loCol);
                Block V01 = new Block(this.V.m, this.V.loRow, this.V.loCol + h);
                Block V10 = new Block(this.V.m, this.V.loRow + h, this.V.loCol);
                Block V11 = new Block(this.V.m, this.V.loRow + h, this.V.loCol + h);
                Block W00 = new Block(this.W.m, this.W.loRow, this.W.loCol);
                Block W01 = new Block(this.W.m, this.W.loRow, this.W.loCol + h);
                Block W10 = new Block(this.W.m, this.W.loRow + h, this.W.loCol);
                Block W11 = new Block(this.W.m, this.W.loRow + h, this.W.loCol + h);
                FJTask.coInvoke(new FJTask[]{FJTask.seq(new Schur(h, V00, W00, M00), new Schur(h, V01, W10, M00)), FJTask.seq(new Schur(h, V00, W01, M01), new Schur(h, V01, W11, M01)), FJTask.seq(new Schur(h, V10, W00, M10), new Schur(h, V11, W10, M10)), FJTask.seq(new Schur(h, V10, W01, M11), new Schur(h, V11, W11, M11))});
            }
        }
    }

    static class Lower
    extends FJTask {
        final int size;
        final Block L;
        final Block M;

        Lower(int size, Block L, Block M) {
            this.size = size;
            this.L = L;
            this.M = M;
        }

        void lower() {
            int i = 1;
            while (i < 16) {
                int k = 0;
                while (k < i) {
                    double a = this.L.m[i + this.L.loRow][k + this.L.loCol];
                    double[] x = this.M.m[k + this.M.loRow];
                    double[] y = this.M.m[i + this.M.loRow];
                    int n = 16;
                    int p = n - 1;
                    while (p >= 0) {
                        int n2 = p + this.M.loCol;
                        y[n2] = y[n2] - a * x[p + this.M.loCol];
                        --p;
                    }
                    ++k;
                }
                ++i;
            }
        }

        public void run() {
            if (this.size == 16) {
                this.lower();
            } else {
                int h = this.size / 2;
                Block M00 = new Block(this.M.m, this.M.loRow, this.M.loCol);
                Block M01 = new Block(this.M.m, this.M.loRow, this.M.loCol + h);
                Block M10 = new Block(this.M.m, this.M.loRow + h, this.M.loCol);
                Block M11 = new Block(this.M.m, this.M.loRow + h, this.M.loCol + h);
                Block L00 = new Block(this.L.m, this.L.loRow, this.L.loCol);
                Block L01 = new Block(this.L.m, this.L.loRow, this.L.loCol + h);
                Block L10 = new Block(this.L.m, this.L.loRow + h, this.L.loCol);
                Block L11 = new Block(this.L.m, this.L.loRow + h, this.L.loCol + h);
                FJTask.coInvoke(new FJTask.Seq(new FJTask[]{new Lower(h, L00, M00), new Schur(h, L10, M00, M10), new Lower(h, L11, M10)}), new FJTask.Seq(new FJTask[]{new Lower(h, L00, M01), new Schur(h, L10, M01, M11), new Lower(h, L11, M11)}));
            }
        }
    }

    static class Upper
    extends FJTask {
        final int size;
        final Block U;
        final Block M;

        Upper(int size, Block U, Block M) {
            this.size = size;
            this.U = U;
            this.M = M;
        }

        void upper() {
            int i = 0;
            while (i < 16) {
                int k = 0;
                while (k < 16) {
                    double a;
                    this.M.m[i + this.M.loRow][k + this.M.loCol] = a = this.M.m[i + this.M.loRow][k + this.M.loCol] / this.U.m[k + this.U.loRow][k + this.U.loCol];
                    double[] x = this.U.m[k + this.U.loRow];
                    double[] y = this.M.m[i + this.M.loRow];
                    int n = 16 - k - 1;
                    int p = n - 1;
                    while (p >= 0) {
                        int n2 = p + k + 1 + this.M.loCol;
                        y[n2] = y[n2] - a * x[p + k + 1 + this.U.loCol];
                        --p;
                    }
                    ++k;
                }
                ++i;
            }
        }

        public void run() {
            if (this.size == 16) {
                this.upper();
            } else {
                int h = this.size / 2;
                Block M00 = new Block(this.M.m, this.M.loRow, this.M.loCol);
                Block M01 = new Block(this.M.m, this.M.loRow, this.M.loCol + h);
                Block M10 = new Block(this.M.m, this.M.loRow + h, this.M.loCol);
                Block M11 = new Block(this.M.m, this.M.loRow + h, this.M.loCol + h);
                Block U00 = new Block(this.U.m, this.U.loRow, this.U.loCol);
                Block U01 = new Block(this.U.m, this.U.loRow, this.U.loCol + h);
                Block U10 = new Block(this.U.m, this.U.loRow + h, this.U.loCol);
                Block U11 = new Block(this.U.m, this.U.loRow + h, this.U.loCol + h);
                FJTask.coInvoke(new FJTask.Seq(new FJTask[]{new Upper(h, U00, M00), new Schur(h, M00, U01, M01), new Upper(h, U11, M01)}), new FJTask.Seq(new FJTask[]{new Upper(h, U00, M10), new Schur(h, M10, U01, M11), new Upper(h, U11, M11)}));
            }
        }
    }

    static class LowerUpper
    extends FJTask {
        final int size;
        final Block M;

        LowerUpper(int size, Block M) {
            this.size = size;
            this.M = M;
        }

        void lu() {
            int k = 0;
            while (k < 16) {
                int i = k + 1;
                while (i < 16) {
                    double a;
                    double b = this.M.m[k + this.M.loRow][k + this.M.loCol];
                    this.M.m[i + this.M.loRow][k + this.M.loCol] = a = this.M.m[i + this.M.loRow][k + this.M.loCol] / b;
                    double[] x = this.M.m[k + this.M.loRow];
                    double[] y = this.M.m[i + this.M.loRow];
                    int n = 16 - k - 1;
                    int p = n - 1;
                    while (p >= 0) {
                        int n2 = k + 1 + p + this.M.loCol;
                        y[n2] = y[n2] - a * x[k + 1 + p + this.M.loCol];
                        --p;
                    }
                    ++i;
                }
                ++k;
            }
        }

        public void run() {
            if (this.size == 16) {
                this.lu();
            } else {
                int h = this.size / 2;
                Block M00 = new Block(this.M.m, this.M.loRow, this.M.loCol);
                Block M01 = new Block(this.M.m, this.M.loRow, this.M.loCol + h);
                Block M10 = new Block(this.M.m, this.M.loRow + h, this.M.loCol);
                Block M11 = new Block(this.M.m, this.M.loRow + h, this.M.loCol + h);
                FJTask.invoke(new LowerUpper(h, M00));
                FJTask.coInvoke(new Lower(h, M00, M01), new Upper(h, M00, M10));
                FJTask.invoke(new Schur(h, M10, M01, M11));
                FJTask.invoke(new LowerUpper(h, M11));
            }
        }
    }
}

