/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.taskDemo;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

public class MatrixMultiply {
    static final int DEFAULT_GRANULARITY = 16;
    static int granularity = 16;

    public static void main(String[] args) {
        String usage = "Usage: java MatrixMultiply <threads> <matrix size (must be a power of two)> [<granularity>] \n Size and granularity must be powers of two.\n For example, try java MatrixMultiply 2 512 16";
        try {
            int n;
            int procs;
            try {
                procs = Integer.parseInt(args[0]);
                n = Integer.parseInt(args[1]);
                if (args.length > 2) {
                    granularity = Integer.parseInt(args[2]);
                }
            }
            catch (Exception e) {
                System.out.println("Usage: java MatrixMultiply <threads> <matrix size (must be a power of two)> [<granularity>] \n Size and granularity must be powers of two.\n For example, try java MatrixMultiply 2 512 16");
                return;
            }
            if ((n & n - 1) != 0 || (granularity & granularity - 1) != 0 || granularity < 2) {
                System.out.println("Usage: java MatrixMultiply <threads> <matrix size (must be a power of two)> [<granularity>] \n Size and granularity must be powers of two.\n For example, try java MatrixMultiply 2 512 16");
                return;
            }
            float[][] a = new float[n][n];
            float[][] b = new float[n][n];
            float[][] c = new float[n][n];
            MatrixMultiply.init(a, b, n);
            FJTaskRunnerGroup g = new FJTaskRunnerGroup(procs);
            g.invoke(new Multiplier(a, 0, 0, b, 0, 0, c, 0, 0, n));
            g.stats();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void init(float[][] a, float[][] b, int n) {
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                a[i][j] = 1.0f;
                b[i][j] = 1.0f;
                ++j;
            }
            ++i;
        }
    }

    static void check(float[][] c, int n) {
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                if (c[i][j] != (float)n) {
                    throw new Error("Check Failed at [" + i + "][" + j + "]: " + c[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    static class Multiplier
    extends FJTask {
        final float[][] A;
        final int aRow;
        final int aCol;
        final float[][] B;
        final int bRow;
        final int bCol;
        final float[][] C;
        final int cRow;
        final int cCol;
        final int size;

        Multiplier(float[][] A, int aRow, int aCol, float[][] B, int bRow, int bCol, float[][] C, int cRow, int cCol, int size) {
            this.A = A;
            this.aRow = aRow;
            this.aCol = aCol;
            this.B = B;
            this.bRow = bRow;
            this.bCol = bCol;
            this.C = C;
            this.cRow = cRow;
            this.cCol = cCol;
            this.size = size;
        }

        public void run() {
            if (this.size <= granularity) {
                this.multiplyStride2();
            } else {
                int h = this.size / 2;
                FJTask.coInvoke(new FJTask[]{FJTask.seq(new Multiplier(this.A, this.aRow, this.aCol, this.B, this.bRow, this.bCol, this.C, this.cRow, this.cCol, h), new Multiplier(this.A, this.aRow, this.aCol + h, this.B, this.bRow + h, this.bCol, this.C, this.cRow, this.cCol, h)), FJTask.seq(new Multiplier(this.A, this.aRow, this.aCol, this.B, this.bRow, this.bCol + h, this.C, this.cRow, this.cCol + h, h), new Multiplier(this.A, this.aRow, this.aCol + h, this.B, this.bRow + h, this.bCol + h, this.C, this.cRow, this.cCol + h, h)), FJTask.seq(new Multiplier(this.A, this.aRow + h, this.aCol, this.B, this.bRow, this.bCol, this.C, this.cRow + h, this.cCol, h), new Multiplier(this.A, this.aRow + h, this.aCol + h, this.B, this.bRow + h, this.bCol, this.C, this.cRow + h, this.cCol, h)), FJTask.seq(new Multiplier(this.A, this.aRow + h, this.aCol, this.B, this.bRow, this.bCol + h, this.C, this.cRow + h, this.cCol + h, h), new Multiplier(this.A, this.aRow + h, this.aCol + h, this.B, this.bRow + h, this.bCol + h, this.C, this.cRow + h, this.cCol + h, h))});
            }
        }

        void multiplyStride2() {
            int j = 0;
            while (j < this.size) {
                int i = 0;
                while (i < this.size) {
                    float[] a0 = this.A[this.aRow + i];
                    float[] a1 = this.A[this.aRow + i + 1];
                    float s00 = 0.0f;
                    float s01 = 0.0f;
                    float s10 = 0.0f;
                    float s11 = 0.0f;
                    int k = 0;
                    while (k < this.size) {
                        float[] b0 = this.B[this.bRow + k];
                        s00 += a0[this.aCol + k] * b0[this.bCol + j];
                        s10 += a1[this.aCol + k] * b0[this.bCol + j];
                        s01 += a0[this.aCol + k] * b0[this.bCol + j + 1];
                        s11 += a1[this.aCol + k] * b0[this.bCol + j + 1];
                        float[] b1 = this.B[this.bRow + k + 1];
                        s00 += a0[this.aCol + k + 1] * b1[this.bCol + j];
                        s10 += a1[this.aCol + k + 1] * b1[this.bCol + j];
                        s01 += a0[this.aCol + k + 1] * b1[this.bCol + j + 1];
                        s11 += a1[this.aCol + k + 1] * b1[this.bCol + j + 1];
                        k += 2;
                    }
                    float[] fArray = this.C[this.cRow + i];
                    int n = this.cCol + j;
                    fArray[n] = fArray[n] + s00;
                    float[] fArray2 = this.C[this.cRow + i];
                    int n2 = this.cCol + j + 1;
                    fArray2[n2] = fArray2[n2] + s01;
                    float[] fArray3 = this.C[this.cRow + i + 1];
                    int n3 = this.cCol + j;
                    fArray3[n3] = fArray3[n3] + s10;
                    float[] fArray4 = this.C[this.cRow + i + 1];
                    int n4 = this.cCol + j + 1;
                    fArray4[n4] = fArray4[n4] + s11;
                    i += 2;
                }
                j += 2;
            }
        }
    }
}

