/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.adapter.emf.check;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.openarchitectureware.adapter.emf.check.CheckFileWithContext;
import org.openarchitectureware.adapter.emf.check.IssuesDiagnosticAdapter;
import org.openarchitectureware.adapter.emf.check.Log;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ExecutionContextImpl;
import org.openarchitectureware.expression.ResourceManager;
import org.openarchitectureware.expression.ResourceManagerDefaultImpl;
import org.openarchitectureware.expression.TypeSystemImpl;
import org.openarchitectureware.type.MetaModel;
import org.openarchitectureware.type.emf.EmfMetaModel;
import org.openarchitectureware.workflow.ConfigurationException;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.issues.IssuesImpl;
import org.openarchitectureware.xtend.ast.ExtensionFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckEValidatorAdapter
implements EValidator {
    private List<CheckFileWithContext> _checkFiles;
    private EValidator _nestedValidator;
    private EPackage _ePackage;
    private ResourceManager _externalResourceManager;

    public CheckEValidatorAdapter(EPackage ePackage) {
        this._ePackage = ePackage;
        this._checkFiles = new ArrayList<CheckFileWithContext>();
    }

    public CheckEValidatorAdapter(EPackage ePackage, EValidator existingValidator) {
        this(ePackage);
        if (existingValidator != null) {
            this._nestedValidator = existingValidator;
        }
    }

    public void addCheckFile(CheckFileWithContext checkFile) {
        this._checkFiles.add(checkFile);
    }

    public void addCheckFile(String checkFileName, boolean isReparseOnValidation) {
        CheckFileWithContext checkFileWithContext = new CheckFileWithContext(checkFileName);
        ExtensionFile parsedCheckFile = (ExtensionFile)new ResourceManagerDefaultImpl().loadResource(checkFileWithContext.getFileName(), "chk");
        if (parsedCheckFile == null) {
            throw new ConfigurationException("Cannot find check file " + checkFileName);
        }
        this._checkFiles.add(checkFileWithContext);
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List<EObject> allElements = Collections.singletonList(eObject);
        boolean isValid = this.runOawCheck(diagnostics, allElements);
        if (this._nestedValidator != null) {
            isValid &= this._nestedValidator.validate(eClass, eObject, diagnostics, context);
        }
        return isValid;
    }

    public boolean validate(EDataType dataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List<EDataType> allElements = Collections.singletonList(dataType);
        boolean isValid = this.runOawCheck(diagnostics, allElements);
        if (this._nestedValidator != null) {
            isValid &= this._nestedValidator.validate(dataType, value, diagnostics, context);
        }
        return isValid;
    }

    public void setExternalResourceManager(ResourceManager externalResourceManager) {
        this._externalResourceManager = externalResourceManager;
    }

    private ResourceManager getResourceManager() {
        if (this._externalResourceManager != null) {
            return this._externalResourceManager;
        }
        return new ResourceManagerDefaultImpl();
    }

    private ExecutionContext createExecutionContext(CheckFileWithContext checkFile, ResourceManager resourceManager) {
        HashSet<EPackage> allEPackages = new HashSet<EPackage>();
        allEPackages.add(this._ePackage);
        for (String nsURI : checkFile.getImportedEPackageNsUris()) {
            try {
                EPackage importedEPackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
                if (importedEPackage == null) continue;
                allEPackages.add(importedEPackage);
            }
            catch (Exception exc) {
                Log.logError(exc);
            }
        }
        TypeSystemImpl typeSystem = new TypeSystemImpl();
        typeSystem.registerMetaModel((MetaModel)new EmfMetaModel(allEPackages){
            private EPackage[] _allEPackages;
            {
                this._allEPackages = set.toArray(new EPackage[set.size()]);
            }

            protected EPackage[] allPackages() {
                return this._allEPackages;
            }
        });
        ExecutionContextImpl executionContext = new ExecutionContextImpl(resourceManager, typeSystem, null);
        return executionContext;
    }

    private boolean runOawCheck(DiagnosticChain diagnostics, List<?> allElements) {
        boolean isValid = true;
        for (CheckFileWithContext checkFile : this._checkFiles) {
            IssuesImpl issues = new IssuesImpl();
            ResourceManager resourceManager = this.getResourceManager();
            ExtensionFile parsedCheckFile = (ExtensionFile)resourceManager.loadResource(checkFile.getFileName(), "chk");
            ExecutionContext executionContext = this.createExecutionContext(checkFile, resourceManager);
            this.runOawCheck(parsedCheckFile, allElements, diagnostics, executionContext);
            isValid &= issues.hasErrors();
        }
        return isValid;
    }

    private Issues runOawCheck(ExtensionFile parsedCheckFile, List<?> allElements, DiagnosticChain diagnostics, ExecutionContext executionContext) {
        IssuesImpl issues = new IssuesImpl();
        parsedCheckFile.check(executionContext, allElements, (Issues)issues, false);
        IssuesDiagnosticAdapter.addDiagnosticFromIssues(diagnostics, (Issues)issues);
        return issues;
    }
}

