/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.adapter.emf.check;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.openarchitectureware.adapter.emf.check.CheckEValidatorAdapter;
import org.openarchitectureware.adapter.emf.check.CheckFileWithContext;
import org.openarchitectureware.adapter.emf.check.Log;

public class CheckRegistry {
    private static final String EXTENSION_POINT_ID = "org.openarchitectureware.adapter.emf.check.checks";
    private static final String NS_URI_ATTR_ID = "nsURI";
    private static final String CHECK_FILE_ATTR_ID = "checkFile";
    private static final String CHECK_FILE_PATH_ATTR_ID = "path";
    private static final String OVERRIDE_ATTR_ID = "override";
    private static final String REFERENCED_META_MODEL = "referencedMetaModel";
    private static CheckRegistry INSTANCE;

    private CheckRegistry() {
        this.registerExtensions();
    }

    public static CheckRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CheckRegistry();
        }
        return INSTANCE;
    }

    private void registerExtensions() {
        try {
            IConfigurationElement[] metaModels;
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_ID);
            IConfigurationElement[] iConfigurationElementArray = metaModels = extensionPoint.getConfigurationElements();
            int n = metaModels.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement metaModel = iConfigurationElementArray[n2];
                try {
                    IConfigurationElement[] checkFiles;
                    EValidator validator;
                    String nsURI = metaModel.getAttribute(NS_URI_ATTR_ID);
                    EPackage ePackage = this.findEPackage(nsURI);
                    String override = metaModel.getAttribute(OVERRIDE_ATTR_ID);
                    CheckEValidatorAdapter oawValidator = "true".equals(override) ? new CheckEValidatorAdapter(ePackage) : ((validator = EValidator.Registry.INSTANCE.getEValidator(ePackage)) instanceof CheckEValidatorAdapter ? (CheckEValidatorAdapter)validator : new CheckEValidatorAdapter(ePackage, validator));
                    IConfigurationElement[] iConfigurationElementArray2 = checkFiles = metaModel.getChildren(CHECK_FILE_ATTR_ID);
                    int n3 = checkFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement checkFile = iConfigurationElementArray2[n4];
                        try {
                            String checkFileName = checkFile.getAttribute(CHECK_FILE_PATH_ATTR_ID);
                            CheckFileWithContext registeredCheckFile = new CheckFileWithContext(checkFileName);
                            IConfigurationElement[] iConfigurationElementArray3 = checkFile.getChildren(REFERENCED_META_MODEL);
                            int n5 = iConfigurationElementArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement referencedMetaModel = iConfigurationElementArray3[n6];
                                String refNsURI = referencedMetaModel.getAttribute(NS_URI_ATTR_ID);
                                registeredCheckFile.addImportedEPackageNsUri(refNsURI);
                                ++n6;
                            }
                            oawValidator.addCheckFile(registeredCheckFile);
                        }
                        catch (Exception exc) {
                            Log.logError(exc);
                        }
                        ++n4;
                    }
                    EValidator.Registry.INSTANCE.put((Object)ePackage, (Object)oawValidator);
                }
                catch (Exception exc) {
                    Log.logError(exc);
                }
                ++n2;
            }
        }
        catch (Exception exc) {
            Log.logError(exc);
        }
    }

    private EPackage findEPackage(String nsURI) {
        Object registeredEPackageDescriptor = EPackage.Registry.INSTANCE.get((Object)nsURI);
        if (registeredEPackageDescriptor instanceof EPackage) {
            return (EPackage)registeredEPackageDescriptor;
        }
        if (registeredEPackageDescriptor instanceof EPackage.Descriptor) {
            return ((EPackage.Descriptor)registeredEPackageDescriptor).getEPackage();
        }
        throw new IllegalArgumentException("Wrong type in Ecore.Registry");
    }
}

