/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.openarchitectureware.BuildJob;
import org.openarchitectureware.EmfToolsPlugin;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.internal.EmfToolsLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectAnalyzer
extends Job {
    private IJavaProject project;
    private ResourceSet rs;
    private Map<IStorage, Resource> mapping;
    private Map<String, EPackage> packages;

    public ProjectAnalyzer(IJavaProject project) {
        super("Analyzing accessible EMF metamodels for project " + project.getProject().getProject().getName());
        this.project = project;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (EmfToolsPlugin.trace) {
            System.out.println("Analyzing EMF metamodels for project " + this.project.getProject().getProject().getName());
        }
        this.rs = new ResourceSetImpl();
        this.mapping = new HashMap<IStorage, Resource>();
        this.packages = new HashMap<String, EPackage>();
        this.loadMetamodelsForProject(this.project, this.rs, monitor);
        if (OawPlugin.getOawModelManager().findProject((IResource)this.project.getProject()) != null) {
            new BuildJob(this.project.getProject()).schedule();
        }
        return Status.OK_STATUS;
    }

    private void loadMetamodelsForProject(IJavaProject javaProject, final ResourceSet rs, IProgressMonitor monitor) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                block22: {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (!root.isArchive() && !root.isExternal()) {
                        IResource rootResource = root.getUnderlyingResource();
                        if (rootResource != null) {
                            try {
                                rootResource.accept(new IResourceVisitor(){

                                    public boolean visit(IResource resource) throws CoreException {
                                        if (resource instanceof IFile && "ecore".equals(((IFile)resource).getFileExtension())) {
                                            ProjectAnalyzer.this.loadModelFromStorage(rs, (IStorage)((IFile)resource));
                                        }
                                        return true;
                                    }
                                });
                            }
                            catch (CoreException e) {
                                EmfToolsLog.logError(e);
                            }
                        }
                    } else if (root.getPath().toString().contains("jre/lib")) {
                        if (EmfToolsPlugin.trace) {
                            System.out.println("Skipping " + root.getPath().toString());
                        }
                    } else {
                        boolean closeRoot = false;
                        try {
                            try {
                                if (!root.isOpen()) {
                                    root.open(monitor);
                                    closeRoot = true;
                                }
                                this.processExternalResources(root.getNonJavaResources(), "ecore");
                                IJavaElement[] iJavaElementArray = root.getChildren();
                                int n3 = iJavaElementArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IJavaElement element = iJavaElementArray[n4];
                                    if (element instanceof IPackageFragment) {
                                        IPackageFragment fragment = (IPackageFragment)element;
                                        this.processExternalResources(fragment.getNonJavaResources(), "ecore");
                                    }
                                    ++n4;
                                }
                            }
                            catch (CoreException e) {
                                EmfToolsLog.logError(e);
                                if (closeRoot) {
                                    root.close();
                                }
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            if (closeRoot) {
                                root.close();
                            }
                            throw throwable;
                        }
                        if (closeRoot) {
                            root.close();
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            EmfToolsLog.logError(e);
        }
    }

    private void processExternalResources(Object[] resources, String extension) throws JavaModelException {
        Object[] objectArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            char dot;
            String name;
            IJarEntryResource entry;
            Object resource = objectArray[n2];
            if (resource instanceof IJarEntryResource && (entry = (IJarEntryResource)resource).isFile() && (name = entry.getName()).endsWith(extension) && name.length() > extension.length() + 1 && (dot = name.charAt(name.length() - extension.length() - 1)) == '.') {
                this.loadModelFromStorage(this.rs, (IStorage)entry);
            }
            ++n2;
        }
    }

    private void loadModelFromStorage(ResourceSet rs, IStorage storage) {
        Resource r;
        URI uri = URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
        if (EmfToolsPlugin.trace) {
            System.out.println("Loading EMF metamodel " + storage.getFullPath().toString());
        }
        if ((r = rs.createResource(uri)).isLoaded() && !r.isModified()) {
            return;
        }
        try {
            r.load(storage.getContents(), Collections.EMPTY_MAP);
            this.mapping.put(storage, r);
            Collection packages = EcoreUtil.getObjectsByType((Collection)r.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
            for (EPackage pack : packages) {
                this.registerPackage(storage, pack);
            }
        }
        catch (IOException e) {
            EmfToolsLog.logError(e);
        }
        catch (CoreException e) {
            EmfToolsLog.logError(e);
        }
    }

    private void registerPackage(IStorage storage, EPackage pack) {
        if (this.packages.containsKey(pack.getNsURI())) {
            if (EmfToolsPlugin.trace) {
                System.out.println("Did not register '" + pack.getName() + "' from " + storage.getFullPath() + " because an EPackage with the same nsURI has already been registered.");
            }
        } else {
            this.packages.put(pack.getNsURI(), pack);
        }
        for (EPackage p : pack.getESubpackages()) {
            this.registerPackage(storage, p);
        }
    }

    public Map<String, EPackage> getNamedEPackageMap() {
        if (this.packages == null) {
            this.run((IProgressMonitor)new NullProgressMonitor());
        }
        return Collections.unmodifiableMap(this.packages);
    }
}

