/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.openarchitectureware.actions.AbstractCoreModelTransformerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAnnotationsAction
extends AbstractCoreModelTransformerAction {
    @Override
    public void transform(Resource r) {
        TreeIterator iter = r.getAllContents();
        while (iter.hasNext()) {
            EObject object = (EObject)iter.next();
            if (!(object instanceof EOperation)) continue;
            EOperation op = (EOperation)object;
            EAnnotation anno = op.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
            if (anno == null) {
                anno = EcorePackage.eINSTANCE.getEcoreFactory().createEAnnotation();
                anno.setSource("http://www.eclipse.org/emf/2002/GenModel");
            }
            String body = this.getBody(op);
            anno.getDetails().put((Object)"body", (Object)body);
            op.getEAnnotations().add((Object)anno);
        }
    }

    private String getBody(EOperation op) {
        StringBuffer buff = new StringBuffer();
        List<EClass> allClasses = this.getSubClasses(op.getEContainingClass());
        this.sortByHierarchy(allClasses);
        for (EClass class1 : allClasses) {
            buff.append("if (this instanceof ").append(class1.getName()).append("Impl) { ");
            this.delegationCallForClass(op, class1, buff);
            buff.append("} else ");
        }
        buff.append("{");
        this.delegationCallForClass(op, op.getEContainingClass(), buff);
        buff.append("}");
        return buff.toString();
    }

    private void delegationCallForClass(EOperation op, EClass class1, StringBuffer buff) {
        if (op.getEType() != null) {
            buff.append("return ");
        }
        buff.append(this.getExtensionClassName(op)).append(".");
        buff.append(op.getName());
        buff.append("((").append(class1.getName()).append("Impl) this");
        EList params = op.getEParameters();
        for (EParameter element : params) {
            buff.append(", ");
            buff.append(element.getName());
        }
        buff.append(");");
    }

    private void sortByHierarchy(List<EClass> allClasses) {
        Collections.sort(allClasses, new Comparator<EClass>(){

            @Override
            public int compare(EClass o1, EClass o2) {
                if (o1.getEAllSuperTypes().contains((Object)o2)) {
                    return -1;
                }
                if (o2.getEAllSuperTypes().contains((Object)o1)) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private List<EClass> getSubClasses(EClass containingClass) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)containingClass, (boolean)true);
        TreeIterator contents = EcoreUtil.getAllProperContents((EObject)rootContainer, (boolean)false);
        while (contents.hasNext()) {
            EObject o = (EObject)contents.next();
            if (!(o instanceof EClass) || !((EClass)o).getEAllSuperTypes().contains((Object)containingClass)) continue;
            result.add((EClass)o);
        }
        return result;
    }

    private String getExtensionClassName(EOperation op) {
        return this.toFirstUpper(String.valueOf(op.getEContainingClass().getEPackage().getName()) + "Util");
    }

    private String toFirstUpper(String name) {
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }
}

