/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mwe.emf;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mwe.emf.AbstractEmfWorkflowComponent;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.WorkflowInterruptedException;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

public class Reader
extends AbstractEmfWorkflowComponent {
    private static final String COMPONENT_NAME = "EMF Reader";
    private boolean makeEPackagesGlobal = true;
    private boolean firstElementOnly = true;

    public void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ctx.set(this.getModelSlot(), Reader.load(this.resourceSet, this.uri, this.firstElementOnly));
        if (this.makeEPackagesGlobal) {
            for (String k : this.resourceSet.getPackageRegistry().keySet()) {
                EPackage.Registry.INSTANCE.put((Object)k, this.resourceSet.getPackageRegistry().get((Object)k));
            }
        }
    }

    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.uri == null) {
            issues.addError("URI not set");
        }
    }

    public static Object load(ResourceSet resourceSet, String uri, boolean firstElementOnly) {
        Resource res = resourceSet.getResource(URI.createURI((String)uri), true);
        if (res == null) {
            throw new WorkflowInterruptedException("Couldn't find resource under " + uri);
        }
        try {
            if (!res.isLoaded()) {
                res.load(Collections.EMPTY_MAP);
            }
        }
        catch (IOException e) {
            throw new WorkflowInterruptedException("Couldn't find resource under " + uri + " : " + e.getMessage());
        }
        EList result = res.getContents();
        if (firstElementOnly) {
            if (result.isEmpty()) {
                return null;
            }
            return result.iterator().next();
        }
        return result;
    }

    public void setFirstElementOnly(boolean firstElementOnly) {
        this.firstElementOnly = firstElementOnly;
    }

    public void setMakeEPackagesGlobal(boolean makeEPackagesGlobal) {
        this.makeEPackagesGlobal = makeEPackagesGlobal;
    }

    public String getLogMessage() {
        return "Loading model from " + this.uri;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

