/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.emf.check;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.WorkflowInterruptedException;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EMFChecker
extends AbstractWorkflowComponent {
    private String modelSlot;
    private final Map<Class<?>, Method> cache = new HashMap();
    private Issues issues;
    private boolean abortOnError;

    public final void setModelSlot(String slot) {
        this.modelSlot = slot;
    }

    public final void checkConfiguration(Issues issues) {
        if (this.modelSlot == null) {
            issues.addError((WorkflowComponent)this, "no model slot specified.", (Object)this);
        }
    }

    public final void setAbortOnError(boolean abort) {
        this.abortOnError = abort;
    }

    public final void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.issues = issues;
        Object model = ctx.get(this.modelSlot);
        if (model == null) {
            issues.addError((WorkflowComponent)this, "nothing found in slot '" + this.modelSlot + "'", (Object)this);
            return;
        }
        Iterator allElements = null;
        if (model instanceof EList) {
            allElements = (Iterator)EcoreUtil.getAllContents((Collection)Collections.singleton(((EList)model).get(0)));
        } else if (model instanceof EObject) {
            allElements = (Iterator)EcoreUtil.getAllContents((Collection)Collections.singleton(model));
        } else {
            issues.addError((WorkflowComponent)this, "content of slot '" + this.modelSlot + "' is neither an EObject nor an EList.", (Object)this);
        }
        while (allElements.hasNext()) {
            EObject e = (EObject)allElements.next();
            Class<?> cls = e.getClass();
            Method m = this.getCheckMethodFor(cls);
            if (m == null) continue;
            this.invokeCheckMethod(m, e);
        }
        if (this.abortOnError && issues.hasErrors()) {
            throw new WorkflowInterruptedException("Errors found during validation.");
        }
    }

    protected final Issues getIssues() {
        return this.issues;
    }

    private Method getCheckMethodFor(Class<?> cls) {
        if (this.cache.containsKey(cls)) {
            return this.cache.get(cls);
        }
        Class<?> currentClass = cls;
        while (currentClass != null) {
            Method m = this.tryToFindMethod(currentClass);
            if (m != null) {
                this.cache.put(cls, m);
                return m;
            }
            int i = 0;
            while (i < currentClass.getInterfaces().length) {
                Class<?> interfaceClass = currentClass.getInterfaces()[i];
                m = this.tryToFindMethod(interfaceClass);
                if (m != null) {
                    this.cache.put(cls, m);
                    return m;
                }
                ++i;
            }
            currentClass = currentClass.getSuperclass();
        }
        return null;
    }

    private Method tryToFindMethod(Class<?> cls) {
        try {
            return ((Object)((Object)this)).getClass().getMethod("check", cls);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    private void invokeCheckMethod(Method m, EObject e) {
        try {
            m.invoke((Object)this, e);
        }
        catch (InvocationTargetException ite) {
            this.issues.addError((WorkflowComponent)this, "cannot invoker check( " + e.getClass() + " ), internal error: " + ite.getCause().getMessage(), (Object)ite.getCause());
        }
        catch (Exception ex) {
            this.issues.addError((WorkflowComponent)this, "cannot invoker check( " + e.getClass() + " ): " + ex.getMessage(), (Object)ex);
        }
    }
}

