/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.check;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.workflow.ConfigurationException;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.xtend.ast.ExtensionFile;
import org.openarchitectureware.xtend.parser.ParseFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckFacade {
    public static final void checkAll(String checkFile, Collection<?> toCheck, ExecutionContext ctx, Issues issues) {
        CheckFacade.checkAll(checkFile, toCheck, ctx, issues, false);
    }

    public static final void checkAll(String checkFile, InputStream in, Collection<?> toCheck, ExecutionContext ctx, Issues issues) {
        CheckFacade.checkAll(checkFile, in, toCheck, ctx, issues, false);
    }

    public static final void checkAll(String checkFile, InputStream in, Collection<?> toCheck, ExecutionContext ctx, Issues issues, boolean warnIfNothingChecked) {
        if (in == null) {
            throw new ConfigurationException("Couldn't find check file :'" + checkFile + "'");
        }
        ExtensionFile file = ParseFacade.file(new InputStreamReader(in), checkFile);
        file.check(ctx, toCheck, issues, warnIfNothingChecked);
    }

    public static final void checkAll(String checkFile, Collection<?> toCheck, ExecutionContext ctx, Issues issues, boolean warnIfNothingChecked) {
        ExtensionFile file = (ExtensionFile)ctx.getResourceManager().loadResource(checkFile, "chk");
        if (file != null) {
            file.check(ctx, toCheck, issues, warnIfNothingChecked);
        } else {
            issues.addError("Could not load Check file '" + checkFile + "'.");
        }
    }
}

