/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.expression.Callback;
import org.openarchitectureware.expression.EvaluationException;
import org.openarchitectureware.expression.ExceptionHandler;
import org.openarchitectureware.expression.ExceptionRaisingNullEvaluationHandler;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ExecutionContextImpl;
import org.openarchitectureware.expression.ExpressionFacade;
import org.openarchitectureware.expression.NullEvaluationHandler;
import org.openarchitectureware.expression.ResourceManager;
import org.openarchitectureware.expression.ResourceManagerDefaultImpl;
import org.openarchitectureware.expression.TypeSystemImpl;
import org.openarchitectureware.expression.Variable;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.type.MetaModel;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.WorkflowInterruptedException;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent2;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;
import org.openarchitectureware.workflow.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpressionsUsingWorkflowComponent
extends AbstractWorkflowComponent2 {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final List<MetaModel> metaModels = new ArrayList<MetaModel>();
    private List<GlobalVarDef> globalVarDefs = new ArrayList<GlobalVarDef>();
    protected Callback callback;
    private List<Debug> debugExpressions = new ArrayList<Debug>();
    private boolean dumpContext = false;
    protected boolean exceptionsOnNullEvaluation = false;
    protected ExceptionHandler exceptionHandler = null;
    private ResourceManager resourceManager;

    public void addMetaModel(MetaModel metaModel) {
        assert (metaModel != null);
        this.metaModels.add(metaModel);
    }

    public void addGlobalVarDef(GlobalVarDef def) {
        this.globalVarDefs.add(def);
    }

    protected Map<String, Variable> getGlobalVars(WorkflowContext ctx) {
        HashMap<String, Variable> result = new HashMap<String, Variable>();
        ExecutionContextImpl ec = new ExecutionContextImpl();
        String[] stringArray = ctx.getSlotNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String slot = stringArray[n2];
            ec = (ExecutionContextImpl)ec.cloneWithVariable(new Variable(slot, ctx.get(slot)));
            ++n2;
        }
        for (MetaModel mm : this.metaModels) {
            ec.registerMetaModel(mm);
        }
        ExpressionFacade ef = new ExpressionFacade(ec);
        for (GlobalVarDef def : this.globalVarDefs) {
            Object value = ef.evaluate(def.getValue());
            result.put(def.getName(), new Variable(def.getName(), value));
        }
        return result;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    protected ExecutionContextImpl getExecutionContext(WorkflowContext ctx) {
        ExecutionContextImpl executionContext = new ExecutionContextImpl(this.getResourceManager(), null, new TypeSystemImpl(), new HashMap<String, Variable>(), this.getGlobalVars(ctx), null, this.exceptionHandler, null, this.getNullEvaluationHandler(), null, this.callback);
        for (MetaModel mm : this.metaModels) {
            executionContext.registerMetaModel(mm);
        }
        return executionContext;
    }

    public NullEvaluationHandler getNullEvaluationHandler() {
        if (this.exceptionsOnNullEvaluation) {
            return new ExceptionRaisingNullEvaluationHandler();
        }
        return null;
    }

    protected void checkConfigurationInternal(Issues issues) {
        if (this.metaModels.isEmpty()) {
            issues.addWarning("no metamodels specified (use 'metaModel' property)!");
        }
    }

    public void addDebug(Debug expr) {
        this.debugExpressions.add(expr);
    }

    public void setDumpContext(boolean dumpContext) {
        this.dumpContext = dumpContext;
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, final Issues issues) {
        try {
            if (this.exceptionHandler == null) {
                this.exceptionHandler = new ExceptionHandler(){

                    @Override
                    public void handleRuntimeException(RuntimeException ex, SyntaxElement element, ExecutionContext ctx, Map<String, Object> additionalContextInfo) {
                        issues.addError((WorkflowComponent)AbstractExpressionsUsingWorkflowComponent.this, ex.getMessage(), (Object)element);
                        throw ex;
                    }
                };
            }
            this.invokeInternal2(ctx, monitor, issues);
        }
        catch (EvaluationException e) {
            this.log.error((Object)("Error in Component" + (this.getId() == null ? " " : " " + this.getId()) + " of type " + ((Object)((Object)this)).getClass().getName() + ": \n\t" + this.toString(e, this.debugExpressions)));
            throw new WorkflowInterruptedException((Throwable)e);
        }
    }

    public String toString(EvaluationException ex, List<Debug> debugEntries) {
        StringBuffer result = new StringBuffer("EvaluationException : " + ex.getMessage() + "\n");
        int widest = 0;
        for (Pair<SyntaxElement, ExecutionContext> ele : ex.getOawStackTrace()) {
            int temp = EvaluationException.getLocationString((SyntaxElement)ele.getFirst()).length();
            if (temp <= widest) continue;
            widest = temp;
        }
        String indent = "";
        int l = 0;
        while (l < widest + 7) {
            indent = String.valueOf(indent) + " ";
            ++l;
        }
        int i = 0;
        int x = ex.getOawStackTrace().size();
        while (i < x) {
            Pair<SyntaxElement, ExecutionContext> ele = ex.getOawStackTrace().get(i);
            StringBuffer msg = new StringBuffer(EvaluationException.getLocationString((SyntaxElement)ele.getFirst()));
            int j = msg.length();
            while (j < widest) {
                msg.append(" ");
                ++j;
            }
            if (debugEntries.size() > i && debugEntries.get(i).getExpression() != null) {
                Debug d = debugEntries.get(i);
                try {
                    msg.append(" -- debug '").append(d.getExpression()).append("' = ");
                    msg.append(new ExpressionFacade((ExecutionContext)ele.getSecond()).evaluate("let x = " + d.getExpression() + " : x!=null ? x.toString() : 'null'"));
                }
                catch (Exception e) {
                    msg.append("Exception : ").append(e.getMessage());
                }
                msg.append("\n");
            }
            if (this.dumpContext || debugEntries.size() > i && debugEntries.get(i).isDumpContext()) {
                ExpressionFacade f = new ExpressionFacade((ExecutionContext)ele.getSecond());
                msg.append(" -- context dump : ");
                Iterator<String> iter = ((ExecutionContext)ele.getSecond()).getVisibleVariables().keySet().iterator();
                while (iter.hasNext()) {
                    String v = iter.next();
                    msg.append(v).append(" = ").append(f.evaluate(String.valueOf(v) + "!=null?" + v + ".toString():'null'"));
                    if (!iter.hasNext()) continue;
                    msg.append(", \n");
                }
                msg.append("\n");
            }
            String[] evals = msg.toString().split("\n");
            int j2 = 0;
            while (j2 < evals.length) {
                String string = evals[j2];
                result.append(string);
                if (j2 + 1 < evals.length) {
                    result.append("\n").append(indent);
                }
                ++j2;
            }
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    protected void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
    }

    public void setExceptionsOnNullEvaluation(boolean exceptionsOnNullEvaluation) {
        this.exceptionsOnNullEvaluation = exceptionsOnNullEvaluation;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManagerDefaultImpl();
        }
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public static class Debug {
        private String expression;
        private boolean dumpContext = false;

        public void setDumpContext(boolean dumpContext) {
            this.dumpContext = dumpContext;
        }

        public boolean isDumpContext() {
            return this.dumpContext;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }
    }

    public static class GlobalVarDef {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

