/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression;

import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.workflow.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationException
extends RuntimeException {
    private static final long serialVersionUID = 3781834199930386623L;
    private List<Pair<SyntaxElement, ExecutionContext>> oawStackTrace = new Stack<Pair<SyntaxElement, ExecutionContext>>();
    public static final Pattern P = Pattern.compile("([\\w::]+)\\.(\\w+)\\[(\\d+),(\\d+)\\]");

    public EvaluationException(String msg, SyntaxElement element, ExecutionContext ctx) {
        super(msg);
        this.addStackElement(element, ctx);
    }

    public EvaluationException(Throwable ex, SyntaxElement element, ExecutionContext ctx) {
        super(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage(), ex);
        this.addStackElement(element, ctx);
    }

    public void addStackElement(SyntaxElement ele, ExecutionContext ctx) {
        this.oawStackTrace.add((Pair<SyntaxElement, ExecutionContext>)new Pair((Object)ele, (Object)ctx));
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("EvaluationException : " + this.getMessage() + "\n");
        for (Pair<SyntaxElement, ExecutionContext> ele : this.oawStackTrace) {
            result.append(EvaluationException.getLocationString((SyntaxElement)ele.getFirst())).append("\n");
        }
        return result.toString();
    }

    public List<Pair<SyntaxElement, ExecutionContext>> getOawStackTrace() {
        return this.oawStackTrace;
    }

    static String getLocationString(SyntaxElement element) {
        StringBuffer b = new StringBuffer("\t");
        if (element != null) {
            if (element.getFileName() != null) {
                b.append(element.getFileName().replaceAll("/", "::"));
            }
            b.append("[" + element.getStart() + "," + (element.getEnd() - element.getStart()) + "] on line " + element.getLine() + " '" + element + "'");
        } else {
            b.append("Internal error : element was null");
        }
        return b.toString();
    }

    public static String getOawNamespace(String oawId) {
        Matcher m = P.matcher(oawId);
        m.find();
        return m.group(1);
    }

    public static String getOawExtension(String oawId) {
        Matcher m = P.matcher(oawId);
        m.find();
        return m.group(2);
    }

    public static Integer getOffSet(String oawId) {
        Matcher m = P.matcher(oawId);
        m.find();
        return Integer.valueOf(m.group(3));
    }

    public static Integer getLength(String oawId) {
        Matcher m = P.matcher(oawId);
        m.find();
        return Integer.valueOf(m.group(4));
    }
}

