/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.expression.Resource;
import org.openarchitectureware.expression.ResourceManager;
import org.openarchitectureware.expression.ResourceParser;
import org.openarchitectureware.util.internal.icu.CharsetDetector;
import org.openarchitectureware.util.internal.icu.CharsetMatch;
import org.openarchitectureware.workflow.util.ResourceLoaderFactory;
import org.openarchitectureware.xtend.XtendResourceParser;

public class ResourceManagerDefaultImpl
implements ResourceManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private String fileEncoding = null;
    private final Map<String, Resource> resources = new HashMap<String, Resource>();
    protected Map<String, ResourceParser> registeredParsers = new HashMap<String, ResourceParser>();

    public ResourceManagerDefaultImpl() {
        XtendResourceParser xtendResourceParser = new XtendResourceParser();
        this.registeredParsers.put("ext", xtendResourceParser);
        this.registeredParsers.put("chk", xtendResourceParser);
    }

    public Resource loadResource(String fullyQualifiedName, String extension) {
        String resourceName = String.valueOf(fullyQualifiedName.replace("::", "/")) + "." + extension;
        if (this.resources.containsKey(resourceName)) {
            return this.resources.get(resourceName);
        }
        InputStream in = ResourceLoaderFactory.createResourceLoader().getResourceAsStream(resourceName);
        if (in == null) {
            return null;
        }
        Reader reader = this.createReader(in);
        ResourceParser parser = this.registeredParsers.get(extension);
        if (parser == null) {
            throw new RuntimeException("No Parser registered for extension '" + extension + "'! Known extensions are '" + this.registeredParsers.keySet() + "'");
        }
        Resource res = parser.parse(reader, resourceName);
        res.setFullyQualifiedName(fullyQualifiedName);
        this.resources.put(resourceName, res);
        return res;
    }

    protected Reader createReader(InputStream in) {
        InputStreamReader reader = null;
        if (this.fileEncoding != null) {
            try {
                reader = new InputStreamReader(in, this.fileEncoding);
            }
            catch (UnsupportedEncodingException e) {
                this.log.error((Object)"Unsupported encoding falling back to default...", (Throwable)e);
                reader = new InputStreamReader(in);
            }
        } else {
            Charset encoding = null;
            BufferedInputStream is = new BufferedInputStream(in);
            try {
                is.mark(65);
                byte[] buf = new byte[64];
                is.read(buf);
                is.reset();
                int i = 0;
                while (i < buf.length) {
                    if (buf[i] == -57) {
                        encoding = Charset.forName("MacRoman");
                        break;
                    }
                    ++i;
                }
                if (encoding == null) {
                    CharsetDetector det = new CharsetDetector();
                    det.setText(buf);
                    CharsetMatch match = det.detect();
                    if (match != null) {
                        encoding = Charset.forName(match.getName());
                    }
                }
                if (encoding != null) {
                    reader = new InputStreamReader((InputStream)is, encoding);
                } else {
                    this.log.warn((Object)"Failed autodetecting encoding. Falling back to default...");
                    reader = new InputStreamReader(is);
                }
            }
            catch (IOException e) {
                this.log.warn((Object)"Failed autodetecting encoding. Falling back to default...", (Throwable)e);
                reader = new InputStreamReader(in);
            }
        }
        return reader;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public void registerParser(String extension, ResourceParser parser) {
        this.registeredParsers.put(extension, parser);
    }
}

