/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.codeassist.ProposalFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionImportProposalComputer {
    private static final Pattern p = Pattern.compile("extension\\s+([\\w\\:]*)\\z", 2);

    protected Pattern getPattern() {
        return p;
    }

    public List<Object> computeProposals(String part, ExecutionContext ctx, ProposalFactory factory, Set<String> extensionFileNames) {
        String prefix = this.computePrefix(part);
        ArrayList<Object> result = new ArrayList<Object>();
        if (prefix == null) {
            return result;
        }
        for (String s : extensionFileNames) {
            if (!s.startsWith(prefix)) continue;
            result.add(factory.createExtensionImportProposal(s, s, prefix, s.length(), 0));
        }
        return result;
    }

    protected String computePrefix(String part) {
        Matcher m = this.getPattern().matcher(part);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String test__computePrefix(String part) {
        return this.computePrefix(part);
    }
}

