/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.type;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.expression.TypeSystem;
import org.openarchitectureware.type.Callable;
import org.openarchitectureware.type.Feature;
import org.openarchitectureware.type.Operation;
import org.openarchitectureware.type.Property;
import org.openarchitectureware.type.StaticProperty;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.type.baseimpl.PolymorphicResolver;
import org.openarchitectureware.workflow.util.Cache;
import org.openarchitectureware.workflow.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeImpl
implements Type {
    private static final Log log = LogFactory.getLog(AbstractTypeImpl.class);
    private final TypeSystem typeSystem;
    private String _name;
    private Set<Callable> allFeatures = null;
    private final Cache<String, Property> propertyCache = new Cache<String, Property>(){

        protected Property createNew(String name) {
            return PolymorphicResolver.getProperty(AbstractTypeImpl.this.getAllFeatures(), name, AbstractTypeImpl.this);
        }
    };
    private final Cache<Pair<String, List<Type>>, Operation> operationsCache = new Cache<Pair<String, List<Type>>, Operation>(){

        protected Operation createNew(Pair<String, List<Type>> arg0) {
            return PolymorphicResolver.getOperation(AbstractTypeImpl.this.getAllFeatures(), (String)arg0.getFirst(), AbstractTypeImpl.this, (List)arg0.getSecond());
        }
    };
    private Set<? extends Type> superTypes = null;

    public AbstractTypeImpl(TypeSystem typeSystem, String name) {
        this.typeSystem = typeSystem;
        this._name = name;
    }

    @Override
    public final TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    public abstract Feature[] getContributedFeatures();

    public final Set<Callable> getAllFeatures() {
        if (this.allFeatures == null) {
            this.allFeatures = new HashSet<Callable>();
            this.allFeatures.addAll((Collection<Callable>)Arrays.asList(this.getContributedFeatures()));
            Set<? extends Type> superTypes = this.getSuperTypes();
            for (Type type : superTypes) {
                if (type != null) {
                    this.allFeatures.addAll(type.getAllFeatures());
                    continue;
                }
                log.error((Object)("A supertype of " + this.getName() + " is null!"));
            }
        }
        return this.allFeatures;
    }

    @Override
    public StaticProperty getStaticProperty(String name) {
        return PolymorphicResolver.getStaticProperty(this.getAllFeatures(), name, this);
    }

    @Override
    public Property getProperty(String name) {
        return (Property)this.propertyCache.get((Object)name);
    }

    @Override
    public Callable getFeature(String name, Type[] parameterTypes) {
        Property property = null;
        if (parameterTypes == null || parameterTypes.length == 0) {
            property = this.getProperty(name);
        }
        Operation operation = this.getOperation(name, parameterTypes);
        if (property != null && operation != null) {
            if (property.getOwner().equals(operation.getOwner())) {
                throw new RuntimeException();
            }
            if (property.getOwner().isAssignableFrom(operation.getOwner())) {
                return operation;
            }
            return property;
        }
        if (property != null) {
            return property;
        }
        return operation;
    }

    @Override
    public Operation getOperation(String name, Type[] parameterTypes) {
        return (Operation)this.operationsCache.get((Object)new Pair((Object)name, Arrays.asList(parameterTypes != null ? parameterTypes : new Type[]{})));
    }

    @Override
    public Set<? extends StaticProperty> getAllStaticProperties() {
        return PolymorphicResolver.select(this.getAllFeatures(), StaticProperty.class);
    }

    @Override
    public Set<? extends Property> getAllProperties() {
        return PolymorphicResolver.select(this.getAllFeatures(), Property.class);
    }

    @Override
    public Set<? extends Operation> getAllOperations() {
        return PolymorphicResolver.select(this.getAllFeatures(), Operation.class);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Type) {
            return this.getName().equals(((Type)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public final boolean isAssignableFrom(Type t) {
        if (t == null) {
            return false;
        }
        if (this.equals(t)) {
            return true;
        }
        if (t.equals(this.getTypeSystem().getVoidType())) {
            return true;
        }
        return this.internalIsAssignableFrom(t);
    }

    protected boolean internalIsAssignableFrom(Type t) {
        Set<? extends Type> superTypes = t.getSuperTypes();
        for (Type type : superTypes) {
            if (!this.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object convert(Object src, Class<?> targetType) {
        if (src == null) {
            return null;
        }
        if (targetType.isInstance(src)) {
            return src;
        }
        throw new IllegalArgumentException(String.valueOf(this.getName()) + " is not responsible for java type " + targetType.getName());
    }

    @Override
    public String getDocumentation() {
        return "";
    }

    @Override
    public Set<? extends Type> getSuperTypes() {
        if (this.superTypes == null) {
            this.superTypes = this.internalGetSuperTypes();
        }
        return this.superTypes;
    }

    protected Set<? extends Type> internalGetSuperTypes() {
        return Collections.singleton(this.getTypeSystem().getObjectType());
    }

    @Override
    public boolean isAbstract() {
        return false;
    }
}

