/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.type.baseimpl.types;

import java.util.Collections;
import java.util.Set;
import org.openarchitectureware.expression.TypeSystem;
import org.openarchitectureware.type.Feature;
import org.openarchitectureware.type.Operation;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.type.baseimpl.OperationImpl;
import org.openarchitectureware.type.baseimpl.PropertyImpl;
import org.openarchitectureware.type.baseimpl.types.BuiltinBaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeImpl
extends BuiltinBaseType
implements Type {
    public ObjectTypeImpl(TypeSystem ts, String name) {
        super(ts, name);
    }

    @Override
    public Feature[] getContributedFeatures() {
        return new Feature[]{new OperationImpl(this, "==", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return new Boolean(target == params[0]);
                }
                return new Boolean(target.equals(params[0]));
            }
        }, new OperationImpl(this, "!=", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return new Boolean(target != params[0]);
                }
                return new Boolean(!target.equals(params[0]));
            }
        }, new OperationImpl(this, ">", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                return new Boolean(((Comparable)target).compareTo(params[0]) > 0);
            }
        }, new OperationImpl(this, ">=", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return params[0] == null ? Boolean.TRUE : Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                return new Boolean(((Comparable)target).compareTo(params[0]) >= 0);
            }
        }, new OperationImpl(this, "<", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                return new Boolean(((Comparable)target).compareTo(params[0]) < 0);
            }
        }, new OperationImpl(this, "<=", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return params[0] == null ? Boolean.TRUE : Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                return new Boolean(((Comparable)target).compareTo(params[0]) <= 0);
            }
        }, new PropertyImpl(this, "metaType", this.getTypeSystem().getTypeType()){

            public String getDocumentation() {
                return "returns this object's meta type.";
            }

            public Object get(Object target) {
                return ObjectTypeImpl.this.getTypeSystem().getType(target);
            }
        }, new OperationImpl(this, "toString", this.getTypeSystem().getStringType(), new Type[0]){

            public String getDocumentation() {
                return "returns the String representation of this object. (Calling Java's toString() method)";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return target != null ? target.toString() : "null";
            }
        }, new OperationImpl(this, "compareTo", this.getTypeSystem().getIntegerType(), new Type[]{this}){

            public String getDocumentation() {
                return "Compares this object with the specified object for order.  Returns a negative integer, zero, or a positive integer as this object is less than, equal to, or greater than the specified object.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return params[0] == null ? new Long(0L) : new Long(-1L);
                }
                if (params[0] == null) {
                    return new Long(1L);
                }
                if (target instanceof Comparable) {
                    return new Long(((Comparable)target).compareTo(params[0]));
                }
                TypeSystem ts = ObjectTypeImpl.this.getTypeSystem();
                Operation op = ts.findOperation("toString", target, null);
                String s1 = (String)op.evaluate(target, null);
                op = ts.findOperation("toString", params[0], null);
                String s2 = (String)op.evaluate(params[0], null);
                return new Long(s1.compareTo(s2));
            }
        }};
    }

    @Override
    public boolean isInstance(Object o) {
        return true;
    }

    @Override
    public Object newInstance() {
        return new Object();
    }

    public Set<Type> getSuperTypes() {
        return Collections.EMPTY_SET;
    }
}

