/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.type.impl.java;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.openarchitectureware.type.Property;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.type.baseimpl.PropertyImpl;

public class JavaPropertyImpl
extends PropertyImpl
implements Property {
    private Method readMethod;
    private Method writeMethod;

    public JavaPropertyImpl(Type owner, String name, Type returnType, Method readMethod, Method writeMethod) {
        super(owner, name, returnType);
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    public Object get(Object target) {
        try {
            Object resultRaw = this.readMethod.invoke(target, null);
            if (resultRaw != null && resultRaw.getClass().isArray()) {
                return Arrays.asList((Object[])resultRaw);
            }
            return resultRaw;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void set(Object target, Object newValue) {
        if (this.writeMethod == null) {
            throw new UnsupportedOperationException("Property " + this.getName() + " is not writable!");
        }
        try {
            this.writeMethod.invoke(target, newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

