/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.openarchitectureware.util.internal.icu.CharsetDetector;
import org.openarchitectureware.util.internal.icu.CharsetMatch;

public class EncodingDetector {
    public static Charset detectEncoding(BufferedInputStream in) throws IOException {
        in.mark(65);
        byte[] buf = new byte[64];
        in.read(buf);
        in.reset();
        return EncodingDetector.detectEncoding(buf);
    }

    public static Charset detectEncoding(byte[] sample) {
        Charset encoding = null;
        int i = 0;
        while (i < sample.length) {
            if (sample[i] == -57) {
                encoding = Charset.forName("MacRoman");
                break;
            }
            ++i;
        }
        if (encoding == null) {
            CharsetDetector det = new CharsetDetector();
            det.setText(sample);
            CharsetMatch match = det.detect();
            encoding = match != null ? Charset.forName(match.getName()) : Charset.forName(System.getProperty("file.encoding"));
        }
        return encoding;
    }
}

