/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.openarchitectureware.workflow.util.Triplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileCollector {
    private static final ThreadLocal<ProfileCollector> _instance = new ThreadLocal<ProfileCollector>(){

        @Override
        protected ProfileCollector initialValue() {
            return new ProfileCollector(null);
        }
    };
    private PrintWriter _out;
    private final Stack<Triplet<String, Long, Long>> _contextStack = new Stack();
    private final Map<String, ProfileEntry> _profile = new HashMap<String, ProfileEntry>();

    private ProfileCollector() {
    }

    public static ProfileCollector getInstance() {
        return _instance.get();
    }

    public void setDetailedLoggingWriter(OutputStream out) {
        try {
            this._out = new PrintWriter(new OutputStreamWriter(out, "utf-8"));
            this._out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this._out.println("<oaw-profile>");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public void finish() {
        if (this._out != null) {
            this._out.println("</oaw-profile>");
            this._out.flush();
            this._out = null;
        }
    }

    public Collection<ProfileEntry> getProfile() {
        return this._profile.values();
    }

    public void enter(String context) {
        this._contextStack.push((Triplet<String, Long, Long>)new Triplet((Object)context, (Object)System.currentTimeMillis(), (Object)0L));
        if (this._out != null) {
            this._out.println("<call context=\"" + context + "\">");
        }
    }

    public void leave() {
        Triplet<String, Long, Long> entry = this._contextStack.pop();
        long duration = System.currentTimeMillis() - (Long)entry.getSecond();
        long timeInChildren = (Long)entry.getThird();
        if (!this._contextStack.isEmpty()) {
            Triplet<String, Long, Long> parent = this._contextStack.peek();
            parent.setThird((Object)((Long)parent.getThird() + duration));
        }
        if (this._profile.containsKey(entry.getFirst())) {
            this._profile.get(entry.getFirst()).registerCall(duration, duration - timeInChildren);
        } else {
            this._profile.put((String)entry.getFirst(), new ProfileEntry((String)entry.getFirst(), duration, duration - timeInChildren));
        }
        if (this._out != null) {
            this._out.println("<duration millis=\"" + duration + "\"/>");
            this._out.println("</call>");
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("context\tnum\ttotal\tnet\tmin\tnet\tmax\tnet\n");
        for (ProfileEntry e : this._profile.values()) {
            result.append(String.valueOf(e.getContextName()) + "\t" + e.getNumCalls() + "\t" + e.getTotalTimeGross() + "\t" + e.getTotalTimeNet() + "\t" + e.getMinTimeGross() + "\t" + e.getMinTimeNet() + "\t" + e.getMaxTimeGross() + "\t" + e.getMaxTimeNet() + "\n");
        }
        return result.toString();
    }

    /* synthetic */ ProfileCollector(ProfileCollector profileCollector) {
        this();
    }

    public static class ProfileEntry {
        private final String _contextName;
        private int _numCalls = 1;
        private long _totalTimeGross;
        private long _totalTimeNet;
        private long _minTimeGross;
        private long _minTimeNet;
        private long _maxTimeGross;
        private long _maxTimeNet;

        public ProfileEntry(String contextName, long grossDuration, long netDuration) {
            this._contextName = contextName;
            this._totalTimeGross += grossDuration;
            this._totalTimeNet += netDuration;
            this._minTimeGross = grossDuration;
            this._maxTimeGross = grossDuration;
            this._minTimeNet = netDuration;
            this._maxTimeNet = netDuration;
        }

        public void registerCall(long grossDuration, long netDuration) {
            ++this._numCalls;
            this._totalTimeGross += grossDuration;
            this._totalTimeNet += netDuration;
            if (grossDuration < this._minTimeGross) {
                this._minTimeGross = grossDuration;
            }
            if (grossDuration > this._maxTimeGross) {
                this._maxTimeGross = grossDuration;
            }
            if (netDuration < this._minTimeNet) {
                this._minTimeNet = netDuration;
            }
            if (netDuration > this._maxTimeNet) {
                this._maxTimeNet = netDuration;
            }
        }

        public String getContextName() {
            return this._contextName;
        }

        public long getMaxTimeGross() {
            return this._maxTimeGross;
        }

        public long getMaxTimeNet() {
            return this._maxTimeNet;
        }

        public long getMinTimeGross() {
            return this._minTimeGross;
        }

        public long getMinTimeNet() {
            return this._minTimeNet;
        }

        public int getNumCalls() {
            return this._numCalls;
        }

        public long getTotalTimeGross() {
            return this._totalTimeGross;
        }

        public long getTotalTimeNet() {
            return this._totalTimeNet;
        }
    }
}

