/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xtend;

import java.util.ArrayList;
import java.util.List;
import org.openarchitectureware.expression.AbstractExpressionsUsingWorkflowAdvice;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.xtend.XtendComponent;

public class XtendAdvice
extends AbstractExpressionsUsingWorkflowAdvice {
    private static final String COMPONENT_NAME = "Xtend Advice";
    private List<String> extensionAdvices = new ArrayList<String>();

    public void addExtensionAdvice(String extensionAdvice) {
        this.extensionAdvices.add(extensionAdvice);
    }

    public void weave(WorkflowComponent c, Issues issues) {
        super.weave(c, issues);
        if (!(c instanceof XtendComponent)) {
            issues.addError((WorkflowComponent)this, "advice target is not an XtendComponent.");
        } else {
            XtendComponent xc = (XtendComponent)c;
            for (String advice : this.extensionAdvices) {
                xc.addExtensionAdvice(advice);
            }
        }
    }

    public String getLogMessage() {
        return "extensionAdvices: " + this.buildList(this.extensionAdvices);
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

