/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xtend.types;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openarchitectureware.expression.TypeSystem;
import org.openarchitectureware.type.MetaModel;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.xtend.types.AdviceContextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendMetaModel
implements MetaModel {
    private final Map<String, Type> types = new HashMap<String, Type>();
    private TypeSystem ts = null;

    public XtendMetaModel(TypeSystem ts) {
        this.setTypeSystem(ts);
        AdviceContextType t = new AdviceContextType(ts);
        this.types.put(t.getName(), t);
    }

    @Override
    public Set<? extends Type> getKnownTypes() {
        return new HashSet<Type>(this.types.values());
    }

    public String getName() {
        return "xtend";
    }

    @Override
    public Type getType(Object obj) {
        Type bestMatch = null;
        for (Type type : this.getKnownTypes()) {
            if (!type.isInstance(obj) || bestMatch != null && !bestMatch.isAssignableFrom(type)) continue;
            bestMatch = type;
        }
        return bestMatch;
    }

    @Override
    public Type getTypeForName(String typeName) {
        return this.types.get(typeName);
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    @Override
    public void setTypeSystem(TypeSystem typeSystem) {
        this.ts = typeSystem;
    }

    @Override
    public Set<String> getNamespaces() {
        return new HashSet<String>();
    }
}

