/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.util.stdlib;

import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.WorkflowInterruptedException;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent2;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

public class ExtIssueReporter
extends AbstractWorkflowComponent2 {
    private static final String ERROR_CONFIGURE = "You must run the org.openarchitectureware.util.stdlib.ExtIssueReporter component before using the issue reporting utilities.";
    private static final String COMPONENT_NAME = "External Issue Reporter";
    static ThreadLocal<Issues> tl = new ThreadLocal();

    protected void checkConfigurationInternal(Issues arg0) {
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor mon, Issues issues) {
        tl.set(issues);
    }

    public String getLogMessage() {
        return "setting up issue logging from within .ext and .xpt files";
    }

    public static String reportError(String message) {
        ExtIssueReporter.getIssues().addError(message);
        return message;
    }

    private static Issues getIssues() {
        Issues issues = tl.get();
        if (issues == null) {
            throw new WorkflowInterruptedException(ERROR_CONFIGURE);
        }
        return issues;
    }

    public static String reportWarning(String message) {
        ExtIssueReporter.getIssues().addWarning(message);
        return message;
    }

    public static String reportError(String qfn, String message) {
        if (tl.get() == null) {
            System.err.println(ERROR_CONFIGURE);
        }
        ExtIssueReporter.getIssues().addError("[" + qfn + "] " + message);
        return message;
    }

    public static String reportWarning(String qfn, String message) {
        if (tl.get() == null) {
            System.err.println(ERROR_CONFIGURE);
        }
        ExtIssueReporter.getIssues().addWarning("[" + qfn + "] " + message);
        return message;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

