/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.util.stdlib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.openarchitectureware.util.stdlib.DynamicEcoreHelper;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent2;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

public class SlotListAdder
extends AbstractWorkflowComponent2 {
    private static final String COMPONENT_NAME = "Slot List Adder";
    private String modelSlot;
    private String listSlot;
    private Set<String> nameSet = new HashSet<String>();
    private boolean uniqueNames;

    public void setListSlot(String listSlot) {
        this.listSlot = listSlot;
    }

    public void setModelSlot(String modelSlot) {
        this.modelSlot = modelSlot;
    }

    public void setUniqueNames(boolean uniqueNames) {
        this.uniqueNames = uniqueNames;
    }

    protected void checkConfigurationInternal(Issues issues) {
        if (this.modelSlot == null) {
            issues.addError((WorkflowComponent)this, "no modelSlot specified.");
        }
        if (this.listSlot == null) {
            issues.addError((WorkflowComponent)this, "no listSlot specified.");
        }
    }

    public String getLogMessage() {
        return "adding contents of slot '" + this.modelSlot + "' to the list of stuff in '" + this.listSlot + "'";
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor mon, Issues issues) {
        ArrayList listContent = ctx.get(this.listSlot);
        if (listContent == null) {
            issues.addWarning("'" + this.listSlot + "' is empty, creating a new list.", (Object)this);
            listContent = new ArrayList();
            ctx.set(this.listSlot, listContent);
        }
        if (!(listContent instanceof Collection)) {
            issues.addError("contents of '" + this.listSlot + "' slot is not a collection, but rather a '" + this.listSlot.getClass().getName() + "'", (Object)this);
            return;
        }
        Object modelContent = ctx.get(this.modelSlot);
        if (modelContent == null) {
            issues.addWarning("'" + this.modelSlot + "' is empty; not adding anything to the '" + this.listSlot + "' slot.", (Object)this);
            return;
        }
        if (this.uniqueNames) {
            EObject eo = (EObject)modelContent;
            DynamicEcoreHelper h = new DynamicEcoreHelper(eo);
            String name = h.getName(eo);
            if (!this.nameSet.contains(name)) {
                ((Collection)listContent).add(modelContent);
                this.nameSet.add(name);
            }
        } else {
            ((Collection)listContent).add(modelContent);
        }
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

