/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.util.stdlib.tracing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.openarchitectureware.util.stdlib.tracing.M2MTraceElement;
import org.openarchitectureware.util.stdlib.tracing.MapList;
import org.openarchitectureware.util.stdlib.tracing.TraceElement;

public class TraceStore {
    private List traces = new ArrayList();
    private MapList tracesBySource = new MapList();
    private MapList tracesByTarget = new MapList();

    public void add(TraceElement t) {
        this.traces.add(t);
        for (EObject source : t.getSources()) {
            this.tracesBySource.add(source, t);
        }
        if (t instanceof M2MTraceElement) {
            M2MTraceElement m2m = (M2MTraceElement)t;
            for (EObject target : m2m.getTargets()) {
                this.tracesByTarget.add(target, t);
            }
        }
    }

    public void clear() {
        this.traces = new ArrayList();
        this.tracesBySource = new MapList();
        this.tracesByTarget = new MapList();
    }

    public List getTraces(Object from, String kind) {
        return this.filter(this.tracesBySource.get(from), kind);
    }

    public List getTraces(Object from) {
        return this.tracesBySource.get(from);
    }

    private List filter(List list, String kind) {
        ArrayList<TraceElement> res = new ArrayList<TraceElement>();
        for (TraceElement element : list) {
            if (!(element instanceof M2MTraceElement) || !((M2MTraceElement)element).getKind().equals(kind)) continue;
            res.add(element);
        }
        return res;
    }

    public Collection getAllTraces() {
        return this.traces;
    }

    public Set getTraceSources() {
        return this.tracesBySource.getKeys();
    }
}

