/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openarchitectureware.compiler.helpers.TemplateContext;
import org.openarchitectureware.expression.Resource;
import org.openarchitectureware.xpand2.ast.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilableApp {
    private final Map<String, Object> _compilationUnits = new HashMap<String, Object>();
    private final String _fileEncoding;

    public CompilableApp(String fileEncoding) {
        this._fileEncoding = fileEncoding;
    }

    public void registerCompilationUnit(String name, Object rootNode) {
        ((Resource)rootNode).setFullyQualifiedName(name);
        if (rootNode instanceof Template) {
            this._compilationUnits.put(name, new TemplateContext((Template)rootNode, this._fileEncoding));
        } else {
            this._compilationUnits.put(name, rootNode);
        }
    }

    public String getPackageName(String cuName) {
        return cuName.substring(0, cuName.lastIndexOf(46));
    }

    public String getSimpleName(String cuName) {
        return cuName.substring(cuName.lastIndexOf(46) + 1);
    }

    public Set<String> getCompilationUnits() {
        return this._compilationUnits.keySet();
    }

    public Object getCompilationUnit(String name) {
        return this._compilationUnits.get(name);
    }
}

