/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.openarchitectureware.compiler.helpers.CompilableApp;
import org.openarchitectureware.compiler.helpers.TemplateIncludesVisitor;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent2;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;
import org.openarchitectureware.workflow.util.ResourceLoader;
import org.openarchitectureware.workflow.util.ResourceLoaderFactory;
import org.openarchitectureware.workflow.util.ResourceLoaderImpl;
import org.openarchitectureware.xpand2.ast.Template;
import org.openarchitectureware.xpand2.parser.XpandParseFacade;
import org.openarchitectureware.xtend.XtendResourceParser;
import org.openarchitectureware.xtend.ast.ExtensionFile;
import org.openarchitectureware.xtend.ast.ImportStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnitInstantiator
extends AbstractWorkflowComponent2 {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String EXTENSION_EXT = ".ext";
    public static final String TEMPLATE_EXT = ".xpt";
    private static final String COMPONENT_NAME = "Compilation Unit Instantiator";
    private final Collection<String> _sourceNames = new HashSet<String>();
    private final List<String> _classpath = new ArrayList<String>();
    private String _sourceEncoding;
    private String _outputSlot;

    public void addSourceName(String filename) {
        this._sourceNames.add(filename);
    }

    public void addResourceRoot(String cpElement) {
        this._classpath.add(cpElement);
    }

    public void setOutputSlot(String outputSlot) {
        this._outputSlot = outputSlot;
    }

    public void setSourceEncoding(String encoding) {
        this._sourceEncoding = encoding;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    protected void checkConfigurationInternal(Issues issues) {
        if (this._sourceNames.isEmpty()) {
            issues.addError("extensionFilename must be set");
        }
        if (this._outputSlot == null) {
            issues.addError("outputSlot must be set");
        }
    }

    private void println(String s, int indent) {
        System.err.print("                                                                ".substring(0, 2 * indent));
        System.err.println(s);
    }

    private InputStream readResource(String name) throws MalformedURLException {
        if (this._classpath.isEmpty()) {
            return ((Object)((Object)this)).getClass().getResourceAsStream(name);
        }
        URL[] urls = new URL[this._classpath.size()];
        int i = 0;
        while (i < this._classpath.size()) {
            String urlRaw = "file:" + this._classpath.get(i);
            if (!urlRaw.endsWith("/")) {
                urlRaw = String.valueOf(urlRaw) + "/";
            }
            urls[i] = new URL(urlRaw);
            System.err.println(String.valueOf(name) + ": " + urlRaw);
            ++i;
        }
        URLClassLoader urlCl = new URLClassLoader(urls);
        System.err.println(urlCl);
        ResourceLoaderFactory.setCurrentThreadResourceLoader((ResourceLoader)new ResourceLoaderImpl((ClassLoader)urlCl));
        return urlCl.getResourceAsStream(name);
    }

    private Reader getResourceReader(String name) throws MalformedURLException, UnsupportedEncodingException {
        InputStream is = this.readResource(name);
        if (is == null) {
            return null;
        }
        if (this._sourceEncoding == null) {
            return new InputStreamReader(is);
        }
        return new InputStreamReader(is, this._sourceEncoding);
    }

    private void parseResource(CompilableApp theApp, String nameWithoutExtension) throws IOException {
        if (theApp.getCompilationUnits().contains(nameWithoutExtension)) {
            return;
        }
        if (this.getResourceReader(String.valueOf(nameWithoutExtension) + EXTENSION_EXT) != null) {
            this.parseExtension(theApp, nameWithoutExtension);
        } else {
            this.parseTemplate(theApp, nameWithoutExtension);
        }
    }

    private void parseExtension(CompilableApp theApp, String nameWithoutExtension) throws IOException {
        XtendResourceParser parser = new XtendResourceParser();
        ExtensionFile r = (ExtensionFile)parser.parse(this.getResourceReader(String.valueOf(nameWithoutExtension) + EXTENSION_EXT), String.valueOf(nameWithoutExtension) + EXTENSION_EXT);
        theApp.registerCompilationUnit(nameWithoutExtension, r);
        for (ImportStatement imp : r.getExtImports()) {
            String importedExtension = imp.getImportedId().getValue().replace('.', '/');
            this.parseResource(theApp, importedExtension);
        }
    }

    private void parseTemplate(CompilableApp theApp, String nameWithoutExtension) throws IOException {
        String fileName = String.valueOf(nameWithoutExtension) + TEMPLATE_EXT;
        Reader r = this.getResourceReader(fileName);
        if (r == null) {
            throw new IllegalArgumentException("resource not found: " + fileName);
        }
        Template template = XpandParseFacade.file(r, fileName);
        theApp.registerCompilationUnit(nameWithoutExtension, template);
        for (String referenced : new TemplateIncludesVisitor(template).getReferencedTemplateFqns()) {
            this.parseResource(theApp, referenced);
        }
    }

    private void addResourcesRecursively(Collection<String> resolvedSourceNames, File cpRoot, File includeRoot) {
        if (!includeRoot.getAbsolutePath().startsWith(cpRoot.getAbsolutePath())) {
            throw new IllegalArgumentException("'" + includeRoot.getAbsolutePath() + "' is not a subdirectory of '" + cpRoot.getAbsolutePath() + "'.");
        }
        File[] fileArray = includeRoot.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.addResourcesRecursively(resolvedSourceNames, cpRoot, f);
            } else if (f.getName().endsWith(TEMPLATE_EXT) || f.getName().endsWith(EXTENSION_EXT)) {
                int prefixlength = cpRoot.getAbsolutePath().length();
                String filename = includeRoot.getAbsolutePath().substring(prefixlength);
                if (filename.startsWith(FILE_SEPARATOR)) {
                    filename = filename.substring(FILE_SEPARATOR.length());
                }
                filename = filename.substring(0, filename.length() - EXTENSION_EXT.length());
                filename = filename.replace(FILE_SEPARATOR, "/");
                resolvedSourceNames.add(filename);
            }
            ++n2;
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        try {
            HashSet<String> resolvedSourceNames = new HashSet<String>();
            for (String rawSourceName : this._sourceNames) {
                boolean isFolder = false;
                for (String root : this._classpath) {
                    File fileFolder = new File(root, rawSourceName);
                    if (!fileFolder.isDirectory()) continue;
                    this.addResourcesRecursively(resolvedSourceNames, new File(root), fileFolder);
                    isFolder = true;
                }
                if (isFolder) continue;
                resolvedSourceNames.add(rawSourceName);
            }
            CompilableApp result = new CompilableApp(this._sourceEncoding);
            for (String filename : resolvedSourceNames) {
                this.parseResource(result, filename);
            }
            ctx.set(this._outputSlot, (Object)result);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }
}

