/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.helpers;

import java.util.List;
import org.openarchitectureware.xpand2.ast.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateContext {
    private final Template _template;
    private String _packagePrefix;
    private final String _fileEncoding;
    private List<String> _importedNs = null;

    public TemplateContext(Template template, String fileEncoding) {
        this._template = template;
        this._fileEncoding = fileEncoding;
    }

    public void setPackagePrefix(String packagePrefix) {
        this._packagePrefix = packagePrefix;
    }

    public Template getTemplate() {
        return this._template;
    }

    public String getFileEncoding() {
        return this._fileEncoding;
    }

    public List<String> getImportedNs() {
        if (this._importedNs == null) {
            this._importedNs = this._template.getImportedNamespacesAsList();
        }
        return this._importedNs;
    }

    public String getPackagePrefix() {
        return this._packagePrefix;
    }

    public String getFqnWithoutPackagePrefix() {
        return this._template.getFullyQualifiedName();
    }

    public String getFqnWithPackagePrefix() {
        return String.valueOf(this._packagePrefix) + "." + this._template.getFullyQualifiedName();
    }
}

