/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.helpers;

import java.util.ArrayList;
import java.util.List;
import org.openarchitectureware.compiler.helpers.TemplateContext;
import org.openarchitectureware.workflow.util.ResourceLoader;
import org.openarchitectureware.workflow.util.ResourceLoaderFactory;
import org.openarchitectureware.xpand2.ast.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateHelper {
    public static String templateClassName(String definition, TemplateContext tctx) {
        System.err.println("**********************************************************");
        int indDef = definition.lastIndexOf("::");
        if (indDef == -1) {
            return tctx.getFqnWithPackagePrefix();
        }
        String fqn = TemplateHelper.getTemplateFqn(definition = definition.substring(0, indDef), tctx.getTemplate());
        if (fqn == null) {
            throw new IllegalArgumentException("no template found for definition '" + definition + "'");
        }
        return String.valueOf(tctx.getPackagePrefix()) + "." + fqn.replace("/", ".");
    }

    public static String getTemplateFqn(String templateName, Template curTemplate) {
        ResourceLoader rl = ResourceLoaderFactory.createResourceLoader();
        for (String candidate : TemplateHelper.getCandidateFqns(templateName, curTemplate)) {
            if (rl.getResourceAsStream(String.valueOf(candidate) + ".xpt") == null) continue;
            return candidate;
        }
        return null;
    }

    public static List<String> getCandidateFqns(String name, Template curTemplate) {
        ArrayList<String> result = new ArrayList<String>();
        name = name.replace("::", "/");
        result.add(name);
        if (curTemplate.getFullyQualifiedName().contains("/")) {
            String prefix = curTemplate.getFullyQualifiedName();
            prefix = prefix.substring(0, prefix.lastIndexOf(47));
            result.add(String.valueOf(prefix) + "/" + name);
        }
        ArrayList<String> importedNsWithSlash = new ArrayList<String>();
        String[] stringArray = curTemplate.getImportedNamespaces();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ns = stringArray[n2];
            importedNsWithSlash.add(ns.replace("::", "/"));
            ++n2;
        }
        for (String ns : importedNsWithSlash) {
            result.add(String.valueOf(ns) + "/" + name);
        }
        System.err.println("candidates: " + result);
        return result;
    }

    public static String definitionName(String definition) {
        int index = definition.lastIndexOf("::");
        if (index == -1) {
            return definition;
        }
        return definition.substring(index + "::".length());
    }
}

