/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.helpers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ExecutionContextImpl;
import org.openarchitectureware.expression.TypeSystemImpl;
import org.openarchitectureware.expression.Variable;
import org.openarchitectureware.expression.ast.DeclaredParameter;
import org.openarchitectureware.type.MetaModel;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.type.impl.java.JavaMetaModel;
import org.openarchitectureware.type.impl.java.JavaTypeStrategy;
import org.openarchitectureware.type.impl.java.beans.JavaBeansStrategy;
import org.openarchitectureware.xtend.ast.ExpressionExtensionStatement;
import org.openarchitectureware.xtend.ast.ExtensionFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHelper {
    public static Type getExtensionType(ExtensionFile extFile, ExpressionExtensionStatement extension) {
        if (extension.getReturnTypeIdentifier() != null) {
            return TypeHelper.getTypeForIdentifier(extFile.getImportedNamespacesAsList(), extension.getReturnTypeIdentifier().getValue());
        }
        TypeSystemImpl typeSystem = new TypeSystemImpl();
        typeSystem.registerMetaModel((MetaModel)new JavaMetaModel("mm", (JavaTypeStrategy)new JavaBeansStrategy()));
        ExecutionContextImpl ctx = new ExecutionContextImpl(typeSystem);
        for (DeclaredParameter p : extension.getFormalParameters()) {
            Type t = TypeHelper.getTypeForIdentifier(extFile.getImportedNamespacesAsList(), p.getType().getValue());
            ctx = ctx.cloneWithVariable(new Variable(p.getName().getValue(), (Object)t));
        }
        Type result = extension.getExpression().analyze((ExecutionContext)ctx, new HashSet());
        if (result == null) {
            return typeSystem.getObjectType();
        }
        if ("Void".equals(result.getName())) {
            return typeSystem.getObjectType();
        }
        return result;
    }

    public static Type getTypeForIdentifier(List<String> importedNs, String typeIdentifier) {
        TypeSystemImpl typeSystem = new TypeSystemImpl();
        typeSystem.registerMetaModel((MetaModel)new JavaMetaModel("mm", (JavaTypeStrategy)new JavaBeansStrategy()));
        return typeSystem.getTypeForName(typeIdentifier, importedNs.toArray(new String[0]));
    }

    public static Collection<String> withAddedVarName(Collection<String> varNames, String newVarName) {
        HashSet<String> result = new HashSet<String>(varNames);
        result.add(newVarName);
        return result;
    }

    public static Object dump(Object o) {
        if (o == null) {
            System.err.println("<null>");
        } else {
            System.err.println(o + ": " + o.getClass().getName());
        }
        return o;
    }
}

