/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openarchitectureware.compiler.runtime.BuiltinCallable;
import org.openarchitectureware.compiler.runtime.Callable;
import org.openarchitectureware.compiler.runtime.CompiledExecutionContext;
import org.openarchitectureware.compiler.runtime.ExtensionCallable;
import org.openarchitectureware.compiler.runtime.MethodCallable;
import org.openarchitectureware.compiler.runtime.util.EfficientLazyString;
import org.openarchitectureware.compiler.runtime.util.PolymorphicResolver;
import org.openarchitectureware.workflow.util.DoubleKeyCache;
import org.openarchitectureware.workflow.util.Pair;
import org.openarchitectureware.workflow.util.TripleKeyCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicExpressions {
    private final TripleKeyCache<String, Integer, Class<?>, List<Callable>> _callables = new TripleKeyCache<String, Integer, Class<?>, List<Callable>>(){

        protected List<Callable> createNew(String name, Integer numParams, Class<?> firstType) {
            ArrayList<Callable> result = new ArrayList<Callable>();
            String escapedName = "_" + name;
            List<Pair<Method, Boolean>> resultRaw = BasicExpressions.this.getMethodMapping().get(new Pair((Object)escapedName, (Object)numParams));
            if (resultRaw != null) {
                for (Pair<Method, Boolean> pair : resultRaw) {
                    result.add(new ExtensionCallable((Method)pair.getFirst(), (Boolean)pair.getSecond()));
                }
            }
            if (firstType != null) {
                Method[] methodArray = firstType.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.getName().equals(name) && method.getParameterTypes().length == numParams - 1) {
                        result.add(new MethodCallable(method));
                    }
                    ++n2;
                }
            }
            BasicExpressions.this.addObjectBuiltins(result, name, numParams);
            if (String.class.equals(firstType)) {
                BasicExpressions.this.addStringBuiltins(result, name, numParams);
            } else if (Long.class.equals(firstType)) {
                BasicExpressions.this.addIntBuiltins(result, name, numParams);
            } else if (firstType != null && Collection.class.isAssignableFrom(firstType)) {
                BasicExpressions.this.addCollectionBuiltins(result, name, numParams);
                if (List.class.isAssignableFrom(firstType)) {
                    BasicExpressions.this.addListBuiltins(result, name, numParams);
                }
            }
            System.err.println(String.valueOf(name) + " for " + (firstType != null ? firstType.getName() : "") + ": " + result);
            return result;
        }
    };
    private final TripleKeyCache<Class, String, Integer, List<Callable>> _definitions = new TripleKeyCache<Class, String, Integer, List<Callable>>(){

        protected List<Callable> createNew(Class templateClass, String defName, Integer numParamsInclTarget) {
            ArrayList<Callable> result = new ArrayList<Callable>();
            Method[] methodArray = templateClass.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method mtd = methodArray[n2];
                if (defName.equals(mtd.getName()) && EfficientLazyString.class.equals(mtd.getReturnType()) && mtd.getParameterTypes().length == numParamsInclTarget) {
                    result.add(new ExtensionCallable(mtd, false));
                }
                ++n2;
            }
            return result;
        }
    };
    private final TripleKeyCache<Class, String, Class[], Callable> _theDefinition = new TripleKeyCache<Class, String, Class[], Callable>(){

        protected Callable createNew(Class templateClass, String defName, Class[] paramTypesInclTarget) {
            List candidates = (List)BasicExpressions.this._definitions.get((Object)templateClass, (Object)defName, (Object)paramTypesInclTarget.length);
            return new PolymorphicResolver().getMethod(defName, (List<Callable>)candidates, paramTypesInclTarget);
        }
    };
    private final TripleKeyCache<String, Class, Class<?>[], Callable> _extensionsWithTarget = new TripleKeyCache<String, Class, Class<?>[], Callable>(){

        protected Callable createNew(String name, Class cls, Class<?>[] paramTypes) {
            Class[] actualParamTypes = new Class[paramTypes.length + 1];
            actualParamTypes[0] = cls;
            System.arraycopy(paramTypes, 0, actualParamTypes, 1, paramTypes.length);
            List candidates = BasicExpressions.this.getCallables(name, actualParamTypes.length, cls);
            return new PolymorphicResolver().getMethod(name, (List<Callable>)candidates, actualParamTypes);
        }
    };
    private final DoubleKeyCache<String, Class<?>[], Callable> _extensionsWithoutTarget = new DoubleKeyCache<String, Class<?>[], Callable>(){

        protected Callable createNew(String name, Class<?>[] paramTypes) {
            List candidates = BasicExpressions.this.getCallables(name, paramTypes.length, paramTypes.length > 0 ? paramTypes[0] : null);
            return new PolymorphicResolver().getMethod(name, (List<Callable>)candidates, paramTypes);
        }
    };
    private final DoubleKeyCache<Class, String, Method> _getterCache = new DoubleKeyCache<Class, String, Method>(){

        protected Method createNew(Class cls, String name) {
            String upperName = BasicExpressions.this.firstUpper(name);
            Method getMtd = (Method)BasicExpressions.this._getterMethodCache.get((Object)cls, (Object)("get" + upperName));
            if (getMtd != null) {
                return getMtd;
            }
            Method isMtd = (Method)BasicExpressions.this._getterMethodCache.get((Object)cls, (Object)("is" + upperName));
            if (isMtd != null && (Boolean.class.equals(isMtd.getReturnType()) || Boolean.TYPE.equals(isMtd.getReturnType()))) {
                return isMtd;
            }
            Method classicMtd = (Method)BasicExpressions.this._getterMethodCache.get((Object)cls, (Object)upperName);
            if (classicMtd == null) {
                throw new IllegalArgumentException("class " + cls.getName() + " has no feature " + name);
            }
            return classicMtd;
        }
    };
    private final DoubleKeyCache<Class, String, Method> _getterMethodCache = new DoubleKeyCache<Class, String, Method>(){

        protected Method createNew(Class cls, String name) {
            Method result;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            try {
                                result = cls.getMethod(name, null);
                                if (!Void.TYPE.equals(result.getReturnType())) break block6;
                                return null;
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }
                        if ((result.getModifiers() & 1) != 0) break block7;
                        return null;
                    }
                    if ((result.getModifiers() & 8) == 0) break block8;
                    return null;
                }
                if ((result.getModifiers() & 0x400) == 0) break block9;
                return null;
            }
            return result;
        }
    };

    private List<Callable> getCallables(String name, int numParams, Class<?> firstType) {
        return (List)this._callables.get((Object)name, (Object)numParams, firstType);
    }

    private void addListBuiltins(List<Callable> callables, String name, int numParams) {
        switch (numParams) {
            case 1: {
                if ("first".equals(name)) {
                    callables.add(new BuiltinCallable(name, new Class[]{List.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            return ((List)first).get(0);
                        }
                    });
                    break;
                }
                if ("last".equals(name)) {
                    callables.add(new BuiltinCallable(name, new Class[]{List.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            List l = (List)first;
                            return l.get(l.size() - 1);
                        }
                    });
                    break;
                }
                if ("withoutFirst".equals(name)) {
                    callables.add(new BuiltinCallable(name, new Class[]{List.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            ArrayList result = new ArrayList((List)first);
                            result.remove(0);
                            return result;
                        }
                    });
                    break;
                }
                if ("withoutLast".equals(name)) {
                    callables.add(new BuiltinCallable(name, new Class[]{List.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            ArrayList result = new ArrayList((List)first);
                            result.remove(result.size() - 1);
                            return result;
                        }
                    });
                    break;
                }
                if (!"reverse".equals(name)) break;
                callables.add(new BuiltinCallable(name, new Class[]{List.class}){

                    public Object invoke(Object first, Object[] params) throws Throwable {
                        ArrayList result = new ArrayList((List)first);
                        Collections.reverse(result);
                        return result;
                    }
                });
                break;
            }
            case 2: {
                if (!"get".equals(name)) break;
                callables.add(new BuiltinCallable(name, new Class[]{List.class, Long.class}){

                    public Object invoke(Object first, Object[] params) throws Throwable {
                        return ((List)first).get(((Number)params[0]).intValue());
                    }
                });
            }
        }
    }

    private void addCollectionBuiltins(List<Callable> callables, String name, int numParams) {
        switch (numParams) {
            case 1: {
                if ("toList".equals(name)) {
                    callables.add(new BuiltinCallable(name, new Class[]{Collection.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            return new ArrayList((Collection)first);
                        }
                    });
                    break;
                }
                if ("toSet".equals(name)) {
                    callables.add(new BuiltinCallable(name, new Class[]{Collection.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            return new HashSet((Collection)first);
                        }
                    });
                    break;
                }
                if (!"flatten".equals(name)) break;
                callables.add(new BuiltinCallable(name, new Class[]{Collection.class}){

                    @Override
                    public Object invoke(Object first, Object[] params) throws Throwable {
                        return this.flattenRec((Collection)first);
                    }

                    private List<Object> flattenRec(Collection col) {
                        ArrayList<Object> result = new ArrayList<Object>();
                        for (Object element : col) {
                            if (element instanceof Collection) {
                                result.addAll(this.flattenRec((Collection)element));
                                continue;
                            }
                            result.add(element);
                        }
                        return result;
                    }
                });
                break;
            }
            case 2: {
                if ("toString".equals(name)) {
                    callables.add(new BuiltinCallable(name, new Class[]{Collection.class, String.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            StringBuilder result = new StringBuilder();
                            boolean firstEl = true;
                            for (Object o : (Collection)first) {
                                if (!firstEl) {
                                    result.append(params[0]);
                                }
                                firstEl = false;
                                result.append(o);
                            }
                            return result.toString();
                        }
                    });
                    break;
                }
                if ("add".equals(name)) {
                    this.removeCallable(callables, name);
                    callables.add(new BuiltinCallable(name, new Class[]{Collection.class, Object.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            ((Collection)first).add(params[0]);
                            return first;
                        }
                    });
                    break;
                }
                if ("addAll".equals(name)) {
                    this.removeCallable(callables, name);
                    callables.add(new BuiltinCallable(name, new Class[]{Collection.class, Collection.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            ((Collection)first).addAll((Collection)params[0]);
                            return first;
                        }
                    });
                    break;
                }
                if ("remove".equals(name)) {
                    this.removeCallable(callables, name);
                    callables.add(new BuiltinCallable(name, new Class[]{Collection.class, Object.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            ((Collection)first).remove(params[0]);
                            return first;
                        }
                    });
                    break;
                }
                if ("removeAll".equals(name)) {
                    this.removeCallable(callables, name);
                    callables.add(new BuiltinCallable(name, new Class[]{Collection.class, Collection.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            ((Collection)first).removeAll((Collection)params[0]);
                            return first;
                        }
                    });
                    break;
                }
                if ("union".equals(name)) {
                    callables.add(new BuiltinCallable(name, new Class[]{Collection.class, Collection.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            HashSet result = new HashSet((Collection)first);
                            result.addAll((Collection)params[0]);
                            return result;
                        }
                    });
                    break;
                }
                if ("without".equals(name)) {
                    callables.add(new BuiltinCallable(name, new Class[]{Collection.class, Collection.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            HashSet result = new HashSet((Collection)first);
                            result.removeAll((Collection)params[0]);
                            return result;
                        }
                    });
                    break;
                }
                if (!"intersect".equals(name)) break;
                callables.add(new BuiltinCallable(name, new Class[]{Collection.class, Collection.class}){

                    public Object invoke(Object first, Object[] params) throws Throwable {
                        HashSet result = new HashSet((Collection)first);
                        result.retainAll((Collection)params[0]);
                        return result;
                    }
                });
            }
        }
    }

    private void addObjectBuiltins(List<Callable> callables, String name, int numParams) {
        switch (numParams) {
            case 1: {
                if (!"toString".equals(name)) break;
                this.removeCallable(callables, name);
                callables.add(new BuiltinCallable(name, new Class[]{Object.class}){

                    public Object invoke(Object first, Object[] params) throws Throwable {
                        if (first == null) {
                            return "null";
                        }
                        return first.toString();
                    }
                });
                break;
            }
            case 2: {
                if (!"compareTo".equals(name)) break;
                this.removeCallable(callables, name);
                callables.add(new BuiltinCallable(name, new Class[]{Object.class, Object.class}){

                    public Object invoke(Object first, Object[] params) throws Throwable {
                        if (first == null) {
                            return params[0] == null ? new Long(0L) : new Long(-1L);
                        }
                        if (params[0] == null) {
                            return new Long(1L);
                        }
                        if (first instanceof Comparable) {
                            return new Long(((Comparable)first).compareTo(params[0]));
                        }
                        return new Long(first.toString().compareTo(params[0].toString()));
                    }
                });
            }
        }
    }

    private void removeCallable(List<Callable> callables, String name) {
        int ind;
        do {
            ind = -1;
            int i = 0;
            while (i < callables.size()) {
                Callable c = callables.get(i);
                if (name.equals(c.getName())) {
                    ind = i;
                    break;
                }
                ++i;
            }
            if (ind < 0) continue;
            callables.remove(ind);
        } while (ind != -1);
    }

    private void addIntBuiltins(List<Callable> callables, String name, int numParams) {
        switch (numParams) {
            case 2: {
                if (!"upTo".equals(name)) break;
                callables.add(new BuiltinCallable("upTo", new Class[]{Number.class, Number.class}){

                    public Object invoke(Object first, Object[] params) throws Throwable {
                        Number n1 = (Number)first;
                        Number n2 = (Number)params[0];
                        ArrayList<Long> result = new ArrayList<Long>();
                        long l = n1.longValue();
                        while (l <= n2.longValue()) {
                            result.add(l);
                            ++l;
                        }
                        return result;
                    }
                });
                break;
            }
            case 3: {
                if (!"upTo".equals(name)) break;
                callables.add(new BuiltinCallable("upTo", new Class[]{Number.class, Number.class, Number.class}){

                    public Object invoke(Object first, Object[] params) throws Throwable {
                        Number n1 = (Number)first;
                        Number n2 = (Number)params[0];
                        Number n3 = (Number)params[1];
                        ArrayList<Long> result = new ArrayList<Long>();
                        long l = n1.longValue();
                        while (l <= n2.longValue()) {
                            result.add(l);
                            l += n3.longValue();
                        }
                        return result;
                    }
                });
            }
        }
    }

    private void addStringBuiltins(List<Callable> callables, String name, int numParams) {
        switch (numParams) {
            case 1: {
                if ("toFirstUpper".equals(name)) {
                    callables.add(new BuiltinCallable("toFirstUpper", new Class[]{String.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            String s = (String)first;
                            if (s.length() == 0) {
                                return "";
                            }
                            if (s.length() == 1) {
                                return s.toUpperCase();
                            }
                            return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
                        }
                    });
                }
                if ("toFirstLower".equals(name)) {
                    callables.add(new BuiltinCallable("toFirstLower", new Class[]{String.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            String s = (String)first;
                            if (s.length() == 0) {
                                return "";
                            }
                            if (s.length() == 1) {
                                return s.toLowerCase();
                            }
                            return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
                        }
                    });
                }
                if ("toCharList".equals(name)) {
                    callables.add(new BuiltinCallable("toCharList", new Class[]{String.class}){

                        public Object invoke(Object first, Object[] params) throws Throwable {
                            String s = (String)first;
                            ArrayList<String> result = new ArrayList<String>();
                            int i = 0;
                            while (i < s.length()) {
                                result.add("" + s.charAt(i));
                                ++i;
                            }
                            return result;
                        }
                    });
                }
                if (!"asInteger".equals(name)) break;
                callables.add(new BuiltinCallable("asInteger", new Class[]{String.class}){

                    public Object invoke(Object first, Object[] params) throws Throwable {
                        try {
                            return Long.parseLong((String)first);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                });
                break;
            }
            case 2: {
                if (!"split".equals(name)) break;
                this.removeCallable(callables, "split");
                callables.add(new BuiltinCallable("split", new Class[]{String.class, String.class}){

                    public Object invoke(Object first, Object[] params) throws Throwable {
                        return Arrays.asList(((String)first).split((String)params[0]));
                    }
                });
                break;
            }
            case 3: {
                if (!"subString".equals(name)) break;
                callables.add(new BuiltinCallable("subString", new Class[]{String.class, Number.class, Number.class}){

                    public Object invoke(Object first, Object[] params) throws Throwable {
                        Number n1 = (Number)params[0];
                        Number n2 = (Number)params[1];
                        return ((String)first).substring(n1.intValue(), n2.intValue());
                    }
                });
            }
        }
    }

    protected Map<Pair<String, Integer>, List<Pair<Method, Boolean>>> getMethodMapping() {
        return new HashMap<Pair<String, Integer>, List<Pair<Method, Boolean>>>();
    }

    protected void registerExtensionMethod(Map<Pair<String, Integer>, List<Pair<Method, Boolean>>> cache, Class cls, String name, boolean isCached, Class ... paramTypes) {
        try {
            Method mtd = cls.getDeclaredMethod(name, paramTypes);
            mtd.setAccessible(true);
            Pair key = new Pair((Object)name, (Object)paramTypes.length);
            List<Pair<Method, Boolean>> value = cache.get(key);
            if (value == null) {
                value = new ArrayList<Pair<Method, Boolean>>();
                cache.put((Pair<String, Integer>)key, value);
            }
            value.add((Pair<Method, Boolean>)new Pair((Object)mtd, (Object)isCached));
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private boolean isReal(Object o) {
        return o instanceof Float || o instanceof Double;
    }

    protected Object __chain__(Object first, Object second) {
        return second;
    }

    protected Object __create__(Class cls) throws Exception {
        Constructor ctor = cls.getConstructor(null);
        ctor.setAccessible(true);
        return ctor.newInstance(new Object[0]);
    }

    protected Object __definitionCall__(Class templateClass, String defName, Object target, Object ... params) throws Throwable {
        Object[] allParams = new Object[params.length + 1];
        allParams[0] = target;
        System.arraycopy(params, 0, allParams, 1, params.length);
        Class[] paramTypes = this.paramTypesForParams(allParams);
        Callable callable = (Callable)this._theDefinition.get((Object)templateClass, (Object)defName, (Object)paramTypes);
        return callable.invoke(allParams);
    }

    private Class[] paramTypesForParams(Object ... params) {
        Class[] result = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            result[i] = params[i] == null ? Void.TYPE : params[i].getClass();
            ++i;
        }
        return result;
    }

    protected Object __operationCall__(boolean hasTarget, boolean hasThis, Object o, Object __this, String name, Object ... params) throws Throwable {
        Callable extensionMethod;
        Class[] paramTypes;
        block11: {
            paramTypes = this.paramTypesForParams(params);
            if (!hasTarget) {
                extensionMethod = (Callable)this._extensionsWithoutTarget.get((Object)name, (Object)paramTypes);
                if (extensionMethod != null) {
                    return extensionMethod.invoke(params);
                }
                if (!hasThis) {
                    throw new IllegalArgumentException("no extension " + name + " found for parameter types " + this.paramTypeNames(paramTypes));
                }
                o = __this;
            }
            if (o != null) break block11;
            if ("compareTo".equals(name) && params != null && params.length == 1) {
                return params[0] == null ? 0L : -1L;
            }
            return null;
        }
        try {
            extensionMethod = (Callable)this._extensionsWithTarget.get((Object)name, o.getClass(), (Object)paramTypes);
            if (extensionMethod != null) {
                return extensionMethod.invoke(o, params);
            }
            if (o instanceof Collection) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object el : (Collection)o) {
                    Callable extensionMethod2 = (Callable)this._extensionsWithTarget.get((Object)name, el.getClass(), (Object)paramTypes);
                    if (extensionMethod2 == null) {
                        throw new IllegalArgumentException("no extension " + name + " found for parameter types " + this.paramTypeNames(paramTypes) + ".");
                    }
                    result.add(extensionMethod2.invoke(el, params));
                }
                return result;
            }
            throw new IllegalArgumentException("no extension " + name + " found for parameter types " + this.paramTypeNames(paramTypes) + ".");
        }
        catch (InvocationTargetException exc) {
            throw exc.getCause();
        }
    }

    private List<String> paramTypeNames(Class[] paramTypes) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < paramTypes.length) {
            result.add(paramTypes[i].getName());
            ++i;
        }
        return result;
    }

    protected Object __feature__(Object o, String name) throws Throwable {
        if (o instanceof Collection) {
            if ("size".equals(name)) {
                if (o instanceof Collection) {
                    return new Long(((Collection)o).size());
                }
            } else if ("isEmpty".equals(name) && o instanceof Collection) {
                return ((Collection)o).isEmpty();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object el : (Collection)o) {
                result.add(this.__featureInternal__(el, name));
            }
            return result;
        }
        return this.__featureInternal__(o, name);
    }

    private Object __featureInternal__(Object o, String name) throws Throwable {
        if (o == null) {
            return null;
        }
        Class<?> cls = o.getClass();
        if ("length".equals(name)) {
            if (String.class.equals(cls)) {
                return ((String)o).length();
            }
        } else if ("metaType".equals(name)) {
            return CompiledExecutionContext.getInstance().getTypeSystem().getType(o);
        }
        Method getter = (Method)this._getterCache.get(cls, (Object)name);
        try {
            return getter.invoke(o, null);
        }
        catch (InvocationTargetException exc) {
            throw exc.getCause();
        }
    }

    private String firstUpper(String s) {
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    protected Boolean __less__(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (this.isReal(o1) || this.isReal(o2)) {
                if (((Number)o1).doubleValue() < ((Number)o2).doubleValue()) {
                    return true;
                }
                return false;
            }
            if (((Number)o1).longValue() < ((Number)o2).longValue()) {
                return true;
            }
            return false;
        }
        if (((Comparable)o1).compareTo(o2) < 0) {
            return true;
        }
        return false;
    }

    protected Boolean __lessOrEquals__(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            if (o1 == o2) {
                return true;
            }
            return false;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (this.isReal(o1) || this.isReal(o2)) {
                if (((Number)o1).doubleValue() <= ((Number)o2).doubleValue()) {
                    return true;
                }
                return false;
            }
            if (((Number)o1).longValue() <= ((Number)o2).longValue()) {
                return true;
            }
            return false;
        }
        if (((Comparable)o1).compareTo(o2) <= 0) {
            return true;
        }
        return false;
    }

    protected Boolean __greater__(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (this.isReal(o1) || this.isReal(o2)) {
                if (((Number)o1).doubleValue() > ((Number)o2).doubleValue()) {
                    return true;
                }
                return false;
            }
            if (((Number)o1).longValue() > ((Number)o2).longValue()) {
                return true;
            }
            return false;
        }
        if (((Comparable)o1).compareTo(o2) > 0) {
            return true;
        }
        return false;
    }

    protected Boolean __greaterOrEquals__(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            if (o1 == o2) {
                return true;
            }
            return false;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (this.isReal(o1) || this.isReal(o2)) {
                if (((Number)o1).doubleValue() >= ((Number)o2).doubleValue()) {
                    return true;
                }
                return false;
            }
            if (((Number)o1).longValue() >= ((Number)o2).longValue()) {
                return true;
            }
            return false;
        }
        if (((Comparable)o1).compareTo(o2) >= 0) {
            return true;
        }
        return false;
    }

    protected Boolean __equals__(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (this.isReal(o1) || this.isReal(o2)) {
                if (((Number)o1).doubleValue() == ((Number)o2).doubleValue()) {
                    return true;
                }
                return false;
            }
            if (((Number)o1).longValue() == ((Number)o2).longValue()) {
                return true;
            }
            return false;
        }
        return o1.equals(o2);
    }

    protected Boolean __notEquals__(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 != null) {
                return true;
            }
            return false;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (this.isReal(o1) || this.isReal(o2)) {
                if (((Number)o1).doubleValue() != ((Number)o2).doubleValue()) {
                    return true;
                }
                return false;
            }
            if (((Number)o1).longValue() != ((Number)o2).longValue()) {
                return true;
            }
            return false;
        }
        return !o1.equals(o2);
    }

    protected Object __plus__(Object o1, Object o2) {
        if (o1 instanceof String) {
            return String.valueOf((String)o1) + o2;
        }
        if (o1 == null || o2 == null) {
            return null;
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (this.isReal(o1) || this.isReal(o2)) {
            return n1.doubleValue() + n2.doubleValue();
        }
        return n1.longValue() + n2.longValue();
    }

    protected Object __minus__(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return null;
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (this.isReal(o1) || this.isReal(o2)) {
            return n1.doubleValue() - n2.doubleValue();
        }
        return n1.longValue() - n2.longValue();
    }

    protected Object __mult__(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return null;
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (this.isReal(o1) || this.isReal(o2)) {
            return n1.doubleValue() * n2.doubleValue();
        }
        return n1.longValue() * n2.longValue();
    }

    protected Object __div__(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return null;
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (this.isReal(o1) || this.isReal(o2)) {
            return n1.doubleValue() / n2.doubleValue();
        }
        return n1.longValue() / n2.longValue();
    }

    protected List __collect__(Object coll, Closure1 closure) throws Throwable {
        if (coll == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object el : (Collection)coll) {
            result.add(closure.exec(el));
        }
        return result;
    }

    protected List __sortBy__(Object coll, final Closure1 closure) throws Throwable {
        if (coll == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        result.addAll((Collection)coll);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Object b;
                Object a;
                block8: {
                    block7: {
                        block6: {
                            try {
                                a = closure.exec(o1);
                                b = closure.exec(o2);
                                if (a != b) break block6;
                                return 0;
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (a != null) break block7;
                        return -1;
                    }
                    if (b != null) break block8;
                    return 1;
                }
                if (a instanceof Comparable) {
                    return ((Comparable)a).compareTo(b);
                }
                return a.toString().compareTo(b.toString());
            }
        });
        return result;
    }

    protected List __select__(Object coll, Closure1 closure) throws Throwable {
        if (coll == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (Object el : (Collection)coll) {
            if (!Boolean.TRUE.equals(closure.exec(el))) continue;
            result.add(el);
        }
        return result;
    }

    protected Object __selectFirst__(Object coll, Closure1 closure) throws Throwable {
        if (coll == null) {
            return null;
        }
        for (Object el : (Collection)coll) {
            if (!Boolean.TRUE.equals(closure.exec(el))) continue;
            return el;
        }
        return null;
    }

    protected List __reject__(Object coll, Closure1 closure) throws Throwable {
        if (coll == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (Object el : (Collection)coll) {
            if (Boolean.TRUE.equals(closure.exec(el))) continue;
            result.add(el);
        }
        return result;
    }

    protected Boolean __exists__(Object coll, Closure1 closure) throws Throwable {
        if (coll == null) {
            return null;
        }
        for (Object el : (Collection)coll) {
            if (!Boolean.TRUE.equals(closure.exec(el))) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Boolean __notExists__(Object coll, Closure1 closure) throws Throwable {
        if (coll == null) {
            return null;
        }
        for (Object el : (Collection)coll) {
            if (!Boolean.TRUE.equals(closure.exec(el))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean __forAll__(Object coll, Closure1 closure) throws Throwable {
        if (coll == null) {
            return null;
        }
        for (Object el : (Collection)coll) {
            if (Boolean.TRUE.equals(closure.exec(el))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected List __typeSelect__(Object coll, Class type) throws Throwable {
        if (coll == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (Object el : (Collection)coll) {
            if (!type.isInstance(el)) continue;
            result.add(el);
        }
        return result;
    }

    protected List __typeSelectInt__(Object coll) throws Throwable {
        if (coll == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (Object el : (Collection)coll) {
            if (!(el instanceof Number) || this.isReal(el)) continue;
            result.add(el);
        }
        return result;
    }

    protected List __typeSelectReal__(Object coll) throws Throwable {
        if (coll == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (Object el : (Collection)coll) {
            if (!(el instanceof Number)) continue;
            result.add(el);
        }
        return result;
    }

    protected static interface Closure {
        public Object exec() throws Throwable;
    }

    protected static interface Closure1 {
        public Object exec(Object var1) throws Throwable;
    }
}

