/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.runtime;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openarchitectureware.expression.TypeSystem;
import org.openarchitectureware.workflow.util.Pair;
import org.openarchitectureware.xpand2.output.Outlet;
import org.openarchitectureware.xpand2.pr.ProtectedRegionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledExecutionContext {
    private static final ThreadLocal<CompiledExecutionContext> _theInstance = new ThreadLocal<CompiledExecutionContext>(){

        @Override
        protected CompiledExecutionContext initialValue() {
            return new CompiledExecutionContext(null);
        }
    };
    private final Map<String, Object> _globalVars = new HashMap<String, Object>();
    private final Map<Pair<Method, List<Object>>, Object> _cachedResults = new HashMap<Pair<Method, List<Object>>, Object>();
    private final Map<String, Outlet> _outlets = new HashMap<String, Outlet>();
    private ProtectedRegionResolver _prResolver;
    private TypeSystem _typeSystem;

    private CompiledExecutionContext() {
    }

    public static CompiledExecutionContext getInstance() {
        return _theInstance.get();
    }

    public void reInit() {
        this._globalVars.clear();
        this._cachedResults.clear();
        this._outlets.clear();
        this._prResolver = null;
        this._typeSystem = null;
    }

    public void setGlobalVar(String name, Object value) {
        this._globalVars.put(name, value);
    }

    public Object getGlobalVar(String name) {
        return this._globalVars.get(name);
    }

    public Map<String, Object> getGlobalVars() {
        return Collections.unmodifiableMap(this._globalVars);
    }

    private Pair<Method, List<Object>> createKey(Method mtd, Object[] params) {
        return new Pair((Object)mtd, Arrays.asList(params));
    }

    public boolean hasCachedValue(Method mtd, Object[] params) {
        return this._cachedResults.containsKey(this.createKey(mtd, params));
    }

    public Object getCachedValue(Method mtd, Object[] params) {
        return this._cachedResults.get(this.createKey(mtd, params));
    }

    public void storeCachedValue(Method mtd, Object[] params, Object result) {
        this._cachedResults.put(this.createKey(mtd, params), result);
    }

    public ProtectedRegionResolver getProtectedRegionResolver() {
        return this._prResolver;
    }

    public void setProtectedRegionResolver(ProtectedRegionResolver resolver) {
        this._prResolver = resolver;
    }

    public Map<String, Outlet> getAllOutlets() {
        return this._outlets;
    }

    public void registerOutlet(String name, Outlet outlet) {
        this._outlets.put(name, outlet);
    }

    public Outlet getOutlet(String name) {
        return this._outlets.get(name);
    }

    public void setTypeSystem(TypeSystem typeSystem) {
        this._typeSystem = typeSystem;
    }

    public TypeSystem getTypeSystem() {
        return this._typeSystem;
    }

    /* synthetic */ CompiledExecutionContext(CompiledExecutionContext compiledExecutionContext) {
        this();
    }
}

