/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openarchitectureware.compiler.runtime.Callable;
import org.openarchitectureware.compiler.runtime.CompiledExecutionContext;

public class ExtensionCallable
implements Callable {
    private final Method _mtd;
    private final boolean _isCached;

    public ExtensionCallable(Method mtd, boolean isCached) {
        this._mtd = mtd;
        this._isCached = isCached;
    }

    public String getName() {
        return this._mtd.getName();
    }

    public Class[] getParamTypes() {
        return this._mtd.getParameterTypes();
    }

    public Object invoke(Object[] params) throws Throwable {
        CompiledExecutionContext ctx = CompiledExecutionContext.getInstance();
        if (this._isCached && ctx.hasCachedValue(this._mtd, params)) {
            return ctx.getCachedValue(this._mtd, params);
        }
        Object o = this._mtd.getDeclaringClass().newInstance();
        try {
            Object result = this._mtd.invoke(o, params);
            if (this._isCached) {
                ctx.storeCachedValue(this._mtd, params, result);
            }
            return result;
        }
        catch (InvocationTargetException exc) {
            throw exc.getCause();
        }
    }

    public Object invoke(Object first, Object[] params) throws Throwable {
        Object[] actualParams = new Object[params.length + 1];
        actualParams[0] = first;
        System.arraycopy(params, 0, actualParams, 1, params.length);
        return this.invoke(actualParams);
    }
}

