/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.runtime.util;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class EfficientLazyString
implements CharSequence {
    private boolean _isDirty = false;
    private String _asString = "";
    private final List<Object> _contents = new ArrayList<Object>();

    public void append(Object o) {
        if (o != null) {
            this._isDirty = true;
            this._contents.add(o);
        }
    }

    public void appendWithNoNl(Object o) {
        String trimmedOld = EfficientLazyString.removeWSAfterLastNewline(this.toString());
        String toBeAppended = EfficientLazyString.trimUntilNewline(o == null ? "" : o.toString());
        this._contents.clear();
        this._contents.add(trimmedOld);
        this._contents.add(toBeAppended);
        this._isDirty = true;
    }

    private static String removeWSAfterLastNewline(String s) {
        int i = s.length();
        while (i > 0) {
            char c = s.charAt(i - 1);
            if (!Character.isWhitespace(c)) {
                return s;
            }
            if (EfficientLazyString.isNewLine(c)) {
                return s.substring(0, i);
            }
            --i;
        }
        return s;
    }

    private static boolean isNewLine(char c) {
        return c == '\n' || c == '\r';
    }

    private static String trimUntilNewline(String bytes) {
        int i = 0;
        boolean wsOnly = true;
        while (i < bytes.length() && wsOnly) {
            char c = bytes.charAt(i);
            wsOnly = Character.isWhitespace(c);
            if (wsOnly && EfficientLazyString.isNewLine(c)) {
                if (c == '\r' && i + 1 < bytes.length() && bytes.charAt(i + 1) == '\n') {
                    ++i;
                }
                return bytes.substring(i + 1);
            }
            ++i;
        }
        return bytes;
    }

    public void writeTo(Writer w) throws IOException {
        if (this._isDirty) {
            for (Object o : this._contents) {
                if (o instanceof EfficientLazyString) {
                    ((EfficientLazyString)o).writeTo(w);
                    continue;
                }
                w.write(o.toString());
            }
        } else {
            w.write(this._asString);
        }
    }

    public String toString() {
        if (this._isDirty) {
            StringBuilder result = new StringBuilder(32768);
            for (Object o : this._contents) {
                result.append(o);
            }
            this._asString = result.toString();
        }
        return this._asString;
    }

    public boolean equals(Object obj) {
        throw new IllegalArgumentException("EfficientLazyString can not be compared directly - compare string representations");
    }

    public int hashCode() {
        throw new IllegalArgumentException("EfficientLazyString can not be compared directly - compare string representations");
    }

    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    public int length() {
        return this.toString().length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }
}

