/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.expression.Callback;
import org.openarchitectureware.expression.ExceptionHandler;
import org.openarchitectureware.expression.ExecutionContextImpl;
import org.openarchitectureware.expression.NullEvaluationHandler;
import org.openarchitectureware.expression.Resource;
import org.openarchitectureware.expression.ResourceManager;
import org.openarchitectureware.expression.ResourceParser;
import org.openarchitectureware.expression.TypeSystem;
import org.openarchitectureware.expression.TypeSystemImpl;
import org.openarchitectureware.expression.Variable;
import org.openarchitectureware.type.Operation;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.type.baseimpl.PolymorphicResolver;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;
import org.openarchitectureware.xpand2.NoSuchTemplateException;
import org.openarchitectureware.xpand2.XpandExecutionContext;
import org.openarchitectureware.xpand2.XpandUtil;
import org.openarchitectureware.xpand2.model.AdvicedDefinition;
import org.openarchitectureware.xpand2.model.XpandAdvice;
import org.openarchitectureware.xpand2.model.XpandDefinition;
import org.openarchitectureware.xpand2.model.XpandResource;
import org.openarchitectureware.xpand2.output.Output;
import org.openarchitectureware.xpand2.parser.XpandParseFacade;
import org.openarchitectureware.xpand2.pr.ProtectedRegionResolver;
import org.openarchitectureware.xpand2.type.XpandTypesMetaModel;
import org.openarchitectureware.xtend.ast.Around;
import org.openarchitectureware.xtend.ast.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandExecutionContextImpl
extends ExecutionContextImpl
implements XpandExecutionContext {
    private final Log log = LogFactory.getLog(this.getClass());
    protected final Output output;
    protected final ProtectedRegionResolver protectedRegionResolver;
    private List<XpandAdvice> registeredAdvices = new ArrayList<XpandAdvice>();

    public XpandExecutionContextImpl(Output output, ProtectedRegionResolver prs) {
        this(output, prs, null, null, null);
    }

    public XpandExecutionContextImpl(Output output, ProtectedRegionResolver prs, Map<String, Variable> globalVars, ExceptionHandler exceptionHandler, NullEvaluationHandler nullEvaluationHandler) {
        this(new TypeSystemImpl(), output, prs, globalVars, exceptionHandler, nullEvaluationHandler);
    }

    protected XpandExecutionContextImpl(TypeSystemImpl ts, Output output, ProtectedRegionResolver prs, Map<String, Variable> globalVars, ExceptionHandler exceptionHandler, NullEvaluationHandler nullEvaluationHandler) {
        super(ts, globalVars);
        this.registerMetaModel(new XpandTypesMetaModel((TypeSystem)this));
        this.registerParser(this.resourceManager);
        this.output = output;
        this.protectedRegionResolver = prs;
        this.exceptionHandler = exceptionHandler;
        this.nullEvaluationHandler = nullEvaluationHandler;
    }

    private void registerParser(ResourceManager resourceManager) {
        resourceManager.registerParser("xpt", new ResourceParser(){

            public Resource parse(Reader in, String fileName) {
                return XpandParseFacade.file(in, fileName);
            }
        });
    }

    protected XpandExecutionContextImpl(ResourceManager resourceManager, Resource currentResource, TypeSystemImpl typeSystem, Map<String, Variable> vars, Map<String, Variable> globalVars, Output output, ProtectedRegionResolver protectedRegionResolver, ProgressMonitor monitor, ExceptionHandler exceptionHandler, List<Around> advices, NullEvaluationHandler nullEvaluationHandler, Map<Resource, Set<Extension>> allExtensionsPerResource, Callback callback) {
        super(resourceManager, currentResource, typeSystem, vars, globalVars, monitor, exceptionHandler, advices, nullEvaluationHandler, allExtensionsPerResource, callback);
        this.registerMetaModel(new XpandTypesMetaModel((TypeSystem)this));
        this.output = output;
        this.protectedRegionResolver = protectedRegionResolver;
        this.exceptionHandler = exceptionHandler;
    }

    public XpandExecutionContextImpl cloneContext() {
        XpandExecutionContextImpl result = new XpandExecutionContextImpl(this.resourceManager, this.currentResource(), this.typeSystem, this.getVisibleVariables(), this.getGlobalVariables(), this.output, this.protectedRegionResolver, this.getMonitor(), this.exceptionHandler, this.registeredExtensionAdvices, this.nullEvaluationHandler, this.allExtensionsPerResource, this.callback);
        result.registeredAdvices.addAll(this.registeredAdvices);
        return result;
    }

    @Override
    public List<XpandDefinition> getAllDefinitions() {
        XpandResource tpl = null;
        tpl = (XpandResource)this.currentResource();
        if (tpl == null) {
            return null;
        }
        XpandDefinition[] localDefinitions = tpl.getDefinitions();
        ArrayList<XpandDefinition> advicedDefinitions = new ArrayList<XpandDefinition>(localDefinitions.length);
        int i = 0;
        while (i < localDefinitions.length) {
            XpandDefinition xpandDefinition = localDefinitions[i];
            int x = this.registeredAdvices.size() - 1;
            while (x >= 0) {
                XpandAdvice adv = this.registeredAdvices.get(x);
                if (adv.matches(xpandDefinition, this)) {
                    xpandDefinition = new AdvicedDefinition(adv, xpandDefinition);
                }
                --x;
            }
            advicedDefinitions.add(xpandDefinition);
            ++i;
        }
        return advicedDefinitions;
    }

    @Override
    public XpandDefinition findDefinition(String name, Type target, Type[] paramTypes) {
        XpandResource tpl = null;
        tpl = name.indexOf("::") != -1 ? this.findTemplate(XpandUtil.withoutLastSegment(name)) : (XpandResource)this.currentResource();
        if (tpl == null) {
            return null;
        }
        XpandExecutionContext ctx = (XpandExecutionContext)this.cloneWithResource(tpl);
        XpandDefinition def = this.findDefinition(tpl.getDefinitions(), name, target, paramTypes, ctx);
        int x = this.registeredAdvices.size() - 1;
        while (x >= 0) {
            XpandAdvice adv = this.registeredAdvices.get(x);
            if (adv.matches(def, this)) {
                def = new AdvicedDefinition(adv, def);
            }
            --x;
        }
        return def;
    }

    public void registerAdvices(String fullyQualifiedName) {
        XpandResource tpl = this.findTemplate(fullyQualifiedName);
        if (tpl == null) {
            throw new NoSuchTemplateException(fullyQualifiedName);
        }
        XpandAdvice[] as = tpl.getAdvices();
        int i = 0;
        while (i < as.length) {
            XpandAdvice advice = as[i];
            if (this.registeredAdvices.contains(advice)) {
                this.log.warn((Object)("advice " + advice.toString() + " allready registered!"));
            } else {
                this.registeredAdvices.add(advice);
            }
            ++i;
        }
    }

    @Override
    public ProtectedRegionResolver getProtectedRegionResolver() {
        return this.protectedRegionResolver;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public XpandResource findTemplate(String templateName) {
        return this.findTemplate(templateName, this.getImportedNamespaces());
    }

    public XpandResource findTemplate(String templateName, String[] importedNs) {
        List possibleNames = this.typeSystem.getPossibleNames(templateName, importedNs);
        for (String element : possibleNames) {
            XpandResource tpl = (XpandResource)this.resourceManager.loadResource(element, "xpt");
            if (tpl == null) continue;
            return tpl;
        }
        return null;
    }

    private XpandDefinition findDefinition(XpandDefinition[] definitions, String name, Type target, Type[] paramTypes, XpandExecutionContext ctx) {
        if (paramTypes == null) {
            paramTypes = new Type[]{};
        }
        HashSet<DefinitionOperationAdapter> features = new HashSet<DefinitionOperationAdapter>();
        int i = 0;
        while (i < definitions.length) {
            XpandDefinition def = definitions[i];
            if (def.getParams().length == paramTypes.length) {
                ArrayList<Type> defsParamTypes = new ArrayList<Type>();
                Type t = null;
                boolean complete = true;
                int j = 0;
                while (j < paramTypes.length && complete) {
                    t = ctx.getTypeForName(def.getParams()[j].getType().getValue());
                    if (t == null) {
                        complete = false;
                    }
                    defsParamTypes.add(t);
                    ++j;
                }
                t = ctx.getTypeForName(def.getTargetType());
                if (t == null) {
                    complete = false;
                }
                if (complete) {
                    features.add(new DefinitionOperationAdapter(def, def.getName(), t, defsParamTypes));
                }
            }
            ++i;
        }
        DefinitionOperationAdapter defAdapter = (DefinitionOperationAdapter)PolymorphicResolver.getOperation(features, (String)XpandUtil.getLastSegment(name), (Type)target, Arrays.asList(paramTypes));
        if (defAdapter != null) {
            return defAdapter.def;
        }
        return null;
    }

    public void setFileEncoding(String fileEncoding) {
        this.resourceManager.setFileEncoding(fileEncoding);
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.registerParser(resourceManager);
        this.resourceManager = resourceManager;
    }

    public void setCallBack(Callback callback) {
        this.callback = callback;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefinitionOperationAdapter
    implements Operation {
        private String name;
        private Type owner;
        private List<Type> paramTypes;
        public XpandDefinition def;

        public DefinitionOperationAdapter(XpandDefinition def, String name, Type owner, List<Type> paramTypes) {
            this.name = name;
            this.owner = owner;
            this.paramTypes = paramTypes;
            this.def = def;
        }

        public String getName() {
            return this.name;
        }

        public Type getReturnType() {
            throw new UnsupportedOperationException();
        }

        public Type getOwner() {
            return this.owner;
        }

        public List<Type> getParameterTypes() {
            return this.paramTypes;
        }

        public Object evaluate(Object target, Object[] params) {
            throw new UnsupportedOperationException();
        }

        public String getDocumentation() {
            return "Xpand definition " + this.getName() + " adapted in an Operation";
        }

        public Type getReturnType(Type targetType, Type[] paramTpes) {
            return this.getReturnType();
        }
    }
}

