/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.ast;

import java.util.Set;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.EvaluationException;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.xpand2.XpandExecutionContext;
import org.openarchitectureware.xpand2.ast.Statement;
import org.openarchitectureware.xpand2.ast.StatementWithBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfStatement
extends StatementWithBody {
    private Expression condition;
    private IfStatement upperIf;
    private IfStatement elseIf;

    public IfStatement(Expression condition, Statement[] body) {
        super(body);
        this.condition = condition;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public IfStatement getElseIf() {
        return this.elseIf;
    }

    public void setElseIf(IfStatement elseIf) {
        this.elseIf = elseIf;
        elseIf.setUpperIf(this);
    }

    private void setUpperIf(IfStatement upperIf) {
        this.upperIf = upperIf;
    }

    public boolean isElseIf() {
        return this.upperIf != null && this.elseIf != null;
    }

    public boolean isElse() {
        return this.upperIf != null && this.elseIf == null;
    }

    @Override
    public void analyzeInternal(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type conType;
        if (this.condition != null && (conType = this.getCondition().analyze((ExecutionContext)ctx, issues)) != null && !ctx.getBooleanType().isAssignableFrom(conType)) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Boolean expected!", (SyntaxElement)this.getCondition()));
        }
        int i = 0;
        while (i < this.body.length) {
            this.body[i].analyze(ctx, issues);
            ++i;
        }
        if (this.getElseIf() != null) {
            this.getElseIf().analyze(ctx, issues);
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        block6: {
            block4: {
                block5: {
                    if (this.condition == null) break block4;
                    Object result = this.getCondition().evaluate((ExecutionContext)ctx);
                    if (result == null) {
                        throw new EvaluationException("Nullevaluation!", (SyntaxElement)this.getCondition(), (ExecutionContext)ctx);
                    }
                    if (!(result instanceof Boolean)) {
                        throw new EvaluationException("Boolean expected!", (SyntaxElement)this.getCondition(), (ExecutionContext)ctx);
                    }
                    if (!((Boolean)result).booleanValue()) break block5;
                    int i = 0;
                    while (i < this.body.length) {
                        this.body[i].evaluate(ctx);
                        ++i;
                    }
                    break block6;
                }
                if (this.getElseIf() == null) break block6;
                this.getElseIf().evaluate(ctx);
                break block6;
            }
            int i = 0;
            while (i < this.body.length) {
                this.body[i].evaluate(ctx);
                ++i;
            }
        }
    }
}

