/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.ast;

import java.util.Set;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.Variable;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.Identifier;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.xpand2.XpandExecutionContext;
import org.openarchitectureware.xpand2.ast.Statement;
import org.openarchitectureware.xpand2.ast.StatementWithBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetStatement
extends StatementWithBody {
    private Identifier varName;
    private Expression varValue;

    public LetStatement(Identifier varName, Expression value, Statement[] body) {
        super(body);
        this.varName = varName;
        this.varValue = value;
    }

    public Identifier getVarName() {
        return this.varName;
    }

    public Expression getVarValue() {
        return this.varValue;
    }

    @Override
    public void analyzeInternal(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type t = this.getVarValue().analyze((ExecutionContext)ctx, issues);
        if (t == null) {
            t = ctx.getObjectType();
        }
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.getVarName().getValue(), (Object)t));
        int i = 0;
        while (i < this.body.length) {
            this.body[i].analyze(ctx, issues);
            ++i;
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.getVarName().getValue(), this.getVarValue().evaluate((ExecutionContext)ctx)));
        int i = 0;
        while (i < this.body.length) {
            this.body[i].evaluate(ctx);
            ++i;
        }
    }
}

