/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.ast;

import java.util.Set;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;
import org.openarchitectureware.xpand2.XpandExecutionContext;
import org.openarchitectureware.xpand2.ast.AbstractDefinition;
import org.openarchitectureware.xpand2.ast.XpandAnalyzable;
import org.openarchitectureware.xpand2.ast.XpandEvaluatable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Statement
extends SyntaxElement
implements XpandAnalyzable,
XpandEvaluatable {
    protected AbstractDefinition containingDefinition;

    @Override
    public final void evaluate(XpandExecutionContext ctx) {
        try {
            ProgressMonitor monitor = ctx.getMonitor();
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            try {
                if (ctx.getCallback() != null) {
                    ctx.getCallback().pre((SyntaxElement)this, (ExecutionContext)ctx);
                }
                ctx.getOutput().pushStatement(this, ctx);
                ctx.preTask(this);
                this.evaluateInternal(ctx);
                ctx.postTask(this);
                ctx.getOutput().popStatement();
            }
            catch (RuntimeException exc) {
                ctx.handleRuntimeException(exc, this, null);
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(null);
            }
        }
    }

    @Override
    public final void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            try {
                if (ctx.getCallback() != null) {
                    ctx.getCallback().pre((SyntaxElement)this, (ExecutionContext)ctx);
                }
                this.analyzeInternal(ctx, issues);
            }
            catch (RuntimeException ex) {
                String message = ex.getMessage();
                if (message == null) {
                    throw ex;
                }
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, ex.getMessage(), (SyntaxElement)this));
                if (ctx.getCallback() != null) {
                    ctx.getCallback().post(null);
                }
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(null);
            }
        }
    }

    protected abstract void evaluateInternal(XpandExecutionContext var1);

    protected abstract void analyzeInternal(XpandExecutionContext var1, Set<AnalysationIssue> var2);

    public AbstractDefinition getContainingDefinition() {
        return this.containingDefinition;
    }

    public void setContainingDefinition(AbstractDefinition definition) {
        this.containingDefinition = definition;
    }
}

