/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.xpand2.XpandExecutionContext;
import org.openarchitectureware.xpand2.XpandUtil;
import org.openarchitectureware.xpand2.ast.AbstractDefinition;
import org.openarchitectureware.xpand2.ast.Advice;
import org.openarchitectureware.xpand2.ast.Definition;
import org.openarchitectureware.xpand2.ast.ImportDeclaration;
import org.openarchitectureware.xpand2.model.XpandAdvice;
import org.openarchitectureware.xpand2.model.XpandDefinition;
import org.openarchitectureware.xpand2.model.XpandResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template
extends SyntaxElement
implements XpandResource {
    private ImportDeclaration[] imports;
    private Definition[] definitions;
    private String fullyQualifiedName;
    private ImportDeclaration[] extensions;
    private Advice[] advices;
    private String[] commonPrefixes = null;
    String[] importedExtensions = null;

    public ImportDeclaration[] getExtensions() {
        return this.extensions;
    }

    public List<String> getImportedExtensionsAsList() {
        ArrayList<String> result = new ArrayList<String>();
        ImportDeclaration[] importDeclarationArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ImportDeclaration ext = importDeclarationArray[n2];
            result.add(ext.getImportString().getValue());
            ++n2;
        }
        return result;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Template(ImportDeclaration[] imports, ImportDeclaration[] extensions, Definition[] definitions, Advice[] advices) {
        this.imports = imports;
        this.extensions = extensions;
        int i = 0;
        while (i < definitions.length) {
            definitions[i].setOwner(this);
            ++i;
        }
        this.definitions = definitions;
        i = 0;
        while (i < advices.length) {
            advices[i].setOwner(this);
            ++i;
        }
        this.advices = advices;
    }

    @Override
    public XpandDefinition[] getDefinitions() {
        return this.definitions;
    }

    public List<XpandDefinition> getDefinitionsAsList() {
        return Arrays.asList(this.definitions);
    }

    public AbstractDefinition[] getAllDefinitions() {
        ArrayList l = new ArrayList();
        l.addAll(Arrays.asList(this.definitions));
        l.addAll(Arrays.asList(this.advices));
        Collections.sort(l, new Comparator<SyntaxElement>(){

            @Override
            public int compare(SyntaxElement o1, SyntaxElement o2) {
                return new Integer(o1.getStart()).compareTo(o2.getStart());
            }
        });
        return l.toArray(new AbstractDefinition[l.size()]);
    }

    public ImportDeclaration[] getImports() {
        return this.imports;
    }

    public List<ImportDeclaration> getImportsAsList() {
        return Arrays.asList(this.imports);
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            try {
                ctx = (XpandExecutionContext)ctx.cloneWithResource(this);
                if (ctx.getCallback() != null) {
                    ctx.getCallback().pre((SyntaxElement)this, (ExecutionContext)ctx);
                }
                this.checkDuplicateDefinitions(issues);
                int i = 0;
                while (i < this.definitions.length) {
                    this.definitions[i].analyze(ctx, issues);
                    ++i;
                }
                i = 0;
                while (i < this.advices.length) {
                    this.advices[i].analyze(ctx, issues);
                    ++i;
                }
            }
            catch (RuntimeException ex) {
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, ex.getMessage(), (SyntaxElement)this));
                if (ctx.getCallback() != null) {
                    ctx.getCallback().post(null);
                }
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(null);
            }
        }
    }

    @Override
    public XpandDefinition[] getDefinitionsByName(String aName) {
        ArrayList<Definition> defs = new ArrayList<Definition>();
        int i = 0;
        while (i < this.definitions.length) {
            Definition def = this.definitions[i];
            if (def.getName().equals(aName)) {
                defs.add(def);
            }
            ++i;
        }
        return defs.toArray(new XpandDefinition[defs.size()]);
    }

    public String[] getImportedNamespaces() {
        if (this.commonPrefixes == null) {
            ArrayList<String> l = new ArrayList<String>();
            String thisNs = XpandUtil.withoutLastSegment(this.getFullyQualifiedName());
            int i = 0;
            while (i < this.getImports().length) {
                ImportDeclaration anImport = this.getImports()[i];
                l.add(anImport.getImportString().getValue());
                ++i;
            }
            if (thisNs != null) {
                l.add(thisNs);
            }
            this.commonPrefixes = l.toArray(new String[l.size()]);
        }
        return this.commonPrefixes;
    }

    public List<String> getImportedNamespacesAsList() {
        return Arrays.asList(this.getImportedNamespaces());
    }

    public String[] getImportedExtensions() {
        if (this.importedExtensions == null) {
            ArrayList<String> l = new ArrayList<String>();
            int i = 0;
            while (i < this.getExtensions().length) {
                ImportDeclaration anImport = this.getExtensions()[i];
                l.add(anImport.getImportString().getValue());
                ++i;
            }
            this.importedExtensions = l.toArray(new String[l.size()]);
        }
        return this.importedExtensions;
    }

    @Override
    public XpandAdvice[] getAdvices() {
        return this.advices;
    }

    private void checkDuplicateDefinitions(Set<AnalysationIssue> issues) {
        HashSet<Definition> definitionSet = new HashSet<Definition>();
        Definition[] definitionArray = this.definitions;
        int n = this.definitions.length;
        int n2 = 0;
        while (n2 < n) {
            Definition def = definitionArray[n2];
            if (!definitionSet.contains(def)) {
                definitionSet.add(def);
            } else {
                Definition origDef = null;
                for (Definition d : definitionSet) {
                    if (!d.equals(def)) continue;
                    origDef = d;
                    break;
                }
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Duplicate definition '" + def.getName() + "'", (SyntaxElement)def));
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Duplicate definition '" + origDef.getName() + "'", (SyntaxElement)origDef));
            }
            ++n2;
        }
    }
}

